/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
//
// {}
// ͢ɽ (Export Table)
// {}
#include <assert.h>
#include <stdio.h>
#include "table/export.h"
#include "aum/stdlib.h"
#include "aum/globalid.h"
#include "aum/object.h"
#include "aum/j-c.h"
#include "aum/parallel.h"
#include "aum/trace.h"
#include "aum/alloc.h"
#include "aum/global.h"
#include "class/template.h"

ExportTableClass*  ExportTable;

void
Initialize_ExportTable(int size)
    // {}
    // ͢ɽΰݤ롥
    // {}
{
    ExportTable = (ExportTableClass*)SHARED_ALLOC(sizeof(ExportTableClass));
    ExportTable->Initialize(size);
}

void
End_ExportTable ()
{
    ExportTable->Terminate();
#ifdef PAS_DEBUGGER
    ExportTable->Free();
#endif
    SHARED_FREE(ExportTable,sizeof(ExportTableClass));
    ExportTable = (ExportTableClass*)0;
}
#ifdef PAS_DEBUGGER
void ExportTableClass::Free()
{
    SHARED_FREE((void*)Array,max_of_exports * sizeof(ExportEntry));
}
#endif


//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\

Word ExportEntry::DereferenceLocal()
    // {}
    // ޡΰ褬ꤷƤ顤ʬȤȤΥ롼
    // ˤϤ롥褬ꤷƤʤϲ⤷ʤ
    // {}
{
    local = Dereference_with_Free (local);
    return local;
}

//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
///\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\

void ExportTableClass::Initialize(int size)
{
    if (size < EXPORT_TABLE_SIZE)
	size = EXPORT_TABLE_SIZE;
    max_of_exports = size;
    no_of_exports = 0;

    Array = (ExportEntry*)SHARED_ALLOC(size * sizeof(ExportEntry));
    int n = size;
    while (--n >= 0) Array[n].Initialize();
}

static void
rest_object_warn (int n, Word x)
{
    pelog ("Warning: rest exporting: [%d] -> %s", n, print (x));
    if (IsObject (x)) {
	switch (Pointer(x)->oTag ()) {
	case READY:
	case SUSPENDED:
	case SLEEPING:
	case CLOSED:
	case ERROR:
	case SINK:
	    int max = Object_ptr(x)->ClassTemplate()->no_of_all_slots ();
	    for (int i = Object_ptr(x)->ClassTemplate()->no_of_all_inlets ();
		 i < max; i++) {
		Word s = Object_ptr (x)->Slot (i);
		if (s != UNDEFOUTLET)
		    pelog ("\t%s: %s", Object_ptr(x)->OutletSlotName(i), print (s));
	    }
	    break;

	default:
	    break;
	}
    }
}

void ExportTableClass::Terminate ()
{
    if (Warnning) {
	if (no_of_exports != 0) {
	    for (int n = 0; n < max_of_exports; n++) {
		if (!Array[n].IsEmpty()) {
		    rest_object_warn (n, Array[n].Local ());
		}
	    }
	}
    }
}

inline u_long ExportTableClass::Index(const ExportEntry* x)
    const
{
    return u_long(x - &Array[0]);
}

inline ExportEntry* ExportTableClass::Hash(const u_long x)
{
    return &Array[x % max_of_exports];
}

void
ExportTableClass::pelog_grc(ExportEntry* eep, int dif)
    const
{
    if (!ShowRC)
	return;
    u_long index = eep-&Array[0];
    u_long result = eep->GRC();
    u_long old	 = result - dif;
    char op = (dif < 0) ? '-' : '+';
    dif = (dif < 0) ? -dif : dif;
    {
	char tem[128];
	sprintf(tem, "[%d] GRC: %d %c %d = %d", index, old, op, dif, result);
	if (old == 0)
	    pelog("%s; export %s", tem, print(eep->Local()));
	else if (result == 0)
	    pelog("%s; unexport %s", tem, print(eep->Local()));
	else
	    pelog(tem);
    }
}

GlobalID ExportTableClass::Register(Header* ptr, int weight)
    // {}
    // PE Ϥݻ ptr͢ɽϿ롥ptr Ͽ
    // Ƥʤäϡptr λȲܣ롥
    //
    // weight  2^weight ɽŤդȲǤ롥ptr 
    // ϿƤϡȲû롥Ǹˡ
    // Global ID 롥
    // @item ptr
    //	     @item ϿƤ:0
    //	     @item Ͽ: +1
    // @item ͢ɽ
    //	     grc += (1<<weight)
    // @picture
    // ֵͤϡ
    //	+---------------+-------+---+-+-+
    //	| index		| #PE	|WGT|-|-|
   //	+---------------+-------+---+-+-+
    // @end
    // {}
{
    static const char thisname[] = "ExportTable->Register";

    if (TableisFull())
	fatal(thisname, "Export Table Overflow");

    ExportEntry* eep;

    for (u_int index = (u_int)ptr; TRUE; index++) {
	eep = Hash(index);
	if (eep->IsEmpty()) {
	    no_of_exports++;
	    ptr->LRC()++;
	    eep->Install(ObjectWord(ptr), 1<<weight);
	    break;
	}
	else if (eep->EqualLocalAddress(ptr)) {
	    assert (ptr->LRC() >= 1);
	    eep->GRC() += (1<<weight);
	    break;
	}
    }
    if (PElog)
	pelog_grc(eep, 1<<weight);

    GlobalID gid = GlobalID(Index(eep), PAS_self_peno, weight);
    return gid;
}

Word ExportTableClass::Lookup(const GlobalID gid)
    // {}
    // gid 򥭡Ȥб륪֥Ȥõ륪
    // ֥Ȥ³줿祤Ȥξϡdereference Ԥʤ
    // ʤ顤͢ɽ
    // {}
{
    return Array[gid.Index()].DereferenceLocal();
}

u_long ExportTableClass::GRC(const GlobalID& gid)
    // {}
    // gid 򥭡Ȥб͢ɽγȲ֤
    // {}
{
    int index = gid.Index();
    return Array[index].GRC();
}

u_long ExportTableClass::GRCminus(const GlobalID& gid, u_long x)
    // {}
    // gid 򥭡Ȥб͢ɽγȲ x ֵ
    // ͤϻĤäȲͤǤ롥
    // {}
{
    u_long& grc = Array[gid.Index()].GRC();
    assert (grc >= x);
    if ((grc -= x) == 0)
	--no_of_exports;

    if (PElog)
	pelog_grc(&Array[gid.Index()], -x);

    return grc;
}

u_long	ExportTableClass::decrGRC(const GlobalID& gid)
    // {}
    // gid 򥭡Ȥб͢ɽγȲ 1 
    // {}
{
    u_long& grc = Array[gid.Index()].GRC();
    assert (grc >= 1);
    if (--grc == 0)
	--no_of_exports;

    if (PElog)
	pelog_grc(&Array[gid.Index()], -1);

    return grc;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
