/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef table_atom_h
#define table_atom_h

// {}
// ȥࡦơ֥ʰ̾ȥȥֹбɽ
// {}
//
// AtomHashTable				AtomTable
//  			  
//  	      		   atom number	
//  	      			  
//  	          AtomChain	     >printnamAtomEntry
//     	     	      
//  Chain >entry 	      	
//     		      	
//  	         next  >	      	
//  	         		      	
//  	      			      	
//  	      			      	
//  			      
// {}

#include "aum/word.h"
#include "aum/alloc.h"
#include "utils/utils.h"


// ɸΥȥơ֥礭ʥƥ¸ߤ륢ȥοκ͡
#ifndef MAX_ATOM_NUMBER
#define MAX_ATOM_NUMBER		(4*1024)
#endif

// ȥϥåơ֥礭
#define ATOMHASHSIZE		509


///////////////////////////////////////////////////////////////////////////////

class AtomEntry {
    // {}
    // 32      24	 16	    8	      0
    //	
    //		 Print name (C++ string)      
    //	
    // {}
private:
    Name		printname;

public:
    void		Initialize(const Name name);
    //
    Boolean		Equal(const Name name) const;
    Name		Printname() const;
};


inline void AtomEntry::Initialize(const Name name)
{
    printname = SavePureString(name);
}

inline Boolean AtomEntry::Equal(const Name name) const
{
    return strcmp(name, printname) == 0 ? TRUE : FALSE;
}

inline Name AtomEntry::Printname() const
{
    return printname;
}

///////////////////////////////////////////////////////////////////////////////

class AtomChain {
private:
    AtomEntry*		entry;
    AtomChain*		next;

public:
    inline		AtomChain(AtomEntry*, AtomChain*);
    inline	       ~AtomChain();
    //
    AtomEntry*		Entry() const;
    AtomChain*		Next() const;
    //
    void*		operator new(size_t s);
    void		operator delete(void*);
};

inline AtomChain::AtomChain(AtomEntry* ae, AtomChain* ac)
{
    entry = ae;
    next = ac;
}

inline AtomChain::~AtomChain() {}

inline AtomEntry* AtomChain::Entry() const
{
    return entry;
}

inline AtomChain* AtomChain::Next() const
{
    return next;
}


///////////////////////////////////////////////////////////////////////////////

class _AtomTable {
private:
    int			max_of_atoms;
    int			no_of_atoms;
    AtomEntry*		Array;

public:
    void		Initialize(int size);
    //
    AtomEntry*		NextEntry(Name);
    //
    AtomEntry*		AtomEntry(int);
    Word		Atom(AtomEntry*) const;
    //
    int			No_of_atoms() const;
#ifdef PAS_DEBUGGER
    void		End__AtomTable();
#endif
};

inline int _AtomTable::No_of_atoms() const
{
    return no_of_atoms;
}

extern _AtomTable*	AtomTable;
extern Word		InternAtom(Name);
extern Name		AtomPrintname(Word);
extern u_long		Hash (Name);

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-continued-brace-offset:0
 * c-brace-offset:0
 * c-brace-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-empty-arglist-indent:4
 * c++-friend-offset:0
 * c-imaginary-offset:0
 * c++-electric-colon:t
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif /* !table_atom_h */
