/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stream.h>
#include "config.h"
#include "aum/parallel.h"

extern "C" {
    int		m_next ();
    int		m_get_numprocs ();
    int		m_get_myid ();
    void	Write_message_to_pe ();
    int*	Check_SystemMessage ();
    int		Wait_terminate ();
    void	Initialize_Communication ();
    void	Initialize_PE ();
    void	Begin_monitoring ();
    void	End_monitoring ();
    void	Report_monitoring ();
    void	Sndrcvstats_data_to_shared_memory ();
    void	Sndrcv_reporting ();
};

unsigned char	PAS_self_peno;
unsigned char	PAS_npe = 1;
int*		PAS_message_may_be_received_p;

void
PAS_initialize_shared ()
  // {}
  // ̿ΤνԤʤ
  // {}
{
    Initialize_Communication ();
}
void
PAS_initialize_private ()
  // {}
  // PE ͭξ롥
  // {}
{
    PAS_self_peno = m_get_myid ();
#ifdef PAS_DEBUGGER
    extern int NofPes;
    PAS_npe = NofPes;
#else
    PAS_npe = m_get_numprocs ();
#endif
    Initialize_PE ();
}

int
PAS_wait_for_terminate ()
{
    return Wait_terminate ();
}

unsigned char
PAS_next_pe()
{
#ifdef PAS_DEBUGGER
    extern int NofPes;
    int n = m_next() % NofPes;
#else
    int n = m_next() % m_get_numprocs();
#endif
//  if (n == m_get_myid())
//	return m_next() % m_get_numprocs();
    return (unsigned char)n;
}

void
PAS_send (unsigned char pe, GlobalMessage* gm)
{
    Write_message_to_pe (gm, pe);
}

GlobalMessage*
PAS_receive ()
{
    return (GlobalMessage*) Check_SystemMessage (1);
}

GlobalMessage*
PAS_receive_in_nonblocking ()
{
    return (GlobalMessage*) Check_SystemMessage (0);
}

void
PAS_begin_monitoring ()
{
    Begin_monitoring ();
}

void
PAS_end_monitoring ()
{
    End_monitoring ();
}

void
PAS_report_monitoring ()
{
    Report_monitoring ();
}

void
PAS_sndrcvstats_send_to_pe0 (void* block, int nbytes)
{
    Sndrcvstats_data_to_shared_memory (PAS_self_peno, block, nbytes);
}

void
PAS_report_sndrcvstats (const char *tag, int nitem)
{
    Sndrcv_reporting (PAS_npe, tag, nitem);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
