/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stream.h>
#include <assert.h>
#include "config.h"
#include "aum/error.h"

extern "C" {
	void *shsbrk(int);
	void *shmalloc(int);
	void  shfree(char*);
};

int*	alloc_large_block(int);
void	free_large_block(int*);
void	alloc_and_split(int);
int	check_size(int);

//#define TEST

//#define OVLD

/*
#define DEBUG
#define CHECK_SIZE
*/

/*
  N	 (N+1)/2  ALLOC-SIZE
  1, 2	->  1		 2
  3, 4	->  2		 4
  5, 6	->  3		 6
  7, 8	->  4		 8
  9,10	->  5		10
 11,12	->  6		12
 13,14	->  7		14
 15,16	->  8		16
 17~32	->		32
 33~48	->		48
 49~64	->		64
 65~
*/


#define CONST_ALLOC_SIZE 16
#define CONST_ALLOC_UNIT  2
#define ALLOC_ARRAY_SIZE (CONST_ALLOC_SIZE/CONST_ALLOC_UNIT)+1

static int*	const_size_alloc_table[ALLOC_ARRAY_SIZE];

#define USED	1
#define FREE	0

#define IS_HEAD 1
#define IS_TAIL 2

typedef struct link_header {
    union {
	int size;
	int base[1];
    } x;
    short pos;
    short status;
    union {
	int area[1];
	struct link_header* next;
    } y;
    struct link_header* prev;
} Header;

#define AREA_OFFSET	2
#define LAST_SIZE_OFFSET 1
#define Size	x.size
#define Base	x.base
#define Pos	pos
#define Status	status
#define Next	y.next
#define Area	y.area
#define Prev	prev

typedef struct link_header* pHeader;

Header mlink;

#ifndef NDEBUG
int init = 1;
#endif

void
Initialize_Memory()
{
/*
    register int i;

    for (i = 1; i < ALLOC_ARRAY_SIZE; i++) {
	const_size_alloc_table[i] = NULL;
	alloc_and_split(i);
    }
    mlink.Next = &mlink;
    mlink.Prev = &mlink;
#ifndef NDEBUG
     init = 0;
#endif
*/
}

inline void
rm_queue(register pHeader p)
{
    p->Next->Prev = p->Prev;
    p->Prev->Next = p->Next;
}

inline void
ins_table(register int* p, register int n)
{
    *p = int(const_size_alloc_table[n]);
    const_size_alloc_table[n] = p;
}

#ifndef NDEBUG
void
alloc_check_link(int n)
{
    for (int* p = const_size_alloc_table[n]; p; p = (int*)(*p)) {
	int x = (int)(*p);
	if (x % 4)
	    abort();
    }
}
#endif	/* NDEBUG */

inline
int*
alloc_const_block(register int n)
{
    register int *p;

    n = (n+CONST_ALLOC_UNIT-1) / CONST_ALLOC_UNIT;

    if ((p = const_size_alloc_table[n]) == NULL) {
	alloc_and_split(n);
	p = const_size_alloc_table[n];
    }
#ifndef NDEBUG
    alloc_check_link(n);
#endif
    const_size_alloc_table[n] = (int*)(*p);
    return p;
}

inline void
free_const_block(register int* p, register int n)
{
    n = (n+CONST_ALLOC_UNIT-1) / CONST_ALLOC_UNIT;
    ins_table(p, n);
}

#define ALLOC_SIZE	1024*4

#define SPECIAL_ALLOCATION 1
int last_allocation = SPECIAL_ALLOCATION;


#ifdef TEST
int spec_alloc_count = 0;
int block_alloc_count = 0;
#endif

void
alloc_and_split(register int n)
{
    register int* p;
    register int i;
    int size = n * CONST_ALLOC_UNIT;

#ifndef NDEBUG
#ifdef CHECK_SIZE
    if (init == 0) {
	printf("before_alloc_and_split: ");
	check_size(1);
    }
#endif
#endif
    if (int(p = (int*)shsbrk(ALLOC_SIZE * sizeof (int))) <= 0) {
	fatal ("alloc", "sbrk error");
    }
    for (i = ALLOC_SIZE - size; i > 0; p += size, i -= size) {
	ins_table(p, n);
    }
    n = (i+size)>>1;
    ins_table(p, n);
    last_allocation = SPECIAL_ALLOCATION;
#ifdef TEST
    spec_alloc_count += ALLOC_SIZE;
#endif
#ifdef CHECK_SIZE
    printf("alloc_and_split allocation for %d\n", size);
    if (init == 0) {
	printf("alloc_and_split: ");
	check_size(1);
    }
#endif
}

#define BLOCK_UNIT_SIZE		8
#define BLOCK_ALLOC_SIZE	1024 * 100

int*
alloc_large_block(register int n)
{
    register pHeader p;
    pHeader q;
    int size, pos;
#ifndef NDEBUG
    int oldn = n;
    int xsize, ysize;
    pHeader hp;

#ifdef CHECK_SIZE
    if (init == 0) {
	count = check_size(0);
	if (count != block_alloc_count) {
	    printf("before alloc block: ");
	    check_size(1);
	}
    }
#endif
#endif

    n = ((n + 3 + BLOCK_UNIT_SIZE-1) / BLOCK_UNIT_SIZE) * BLOCK_UNIT_SIZE;

retry:
    for (p = mlink.Next; p != &mlink; p = p->Next) {
	if (p->Size > n) {
	    size = p->Size - n;
	    p->Size = size;
	    p->Base[size-LAST_SIZE_OFFSET] = size;
	    pos = p->Pos;
	    p->Pos = pos & ~IS_TAIL;
	    p = pHeader(&(p->Base[size]));
	    p->Size = n;
	    p->Pos = pos & ~IS_HEAD;
	    p->Status = USED;
	    p->Base[n-LAST_SIZE_OFFSET] = n;
#ifndef NDEBUG
	    goto size_check;
#endif
	    return (int*)p->Area;
	} else if (p->Size == n) {
	    rm_queue(p);
	    p->Status = USED;
#ifndef NDEBUG
size_check:
#ifdef CHECK_SIZE
	    if (init == 0) {
		count = check_size(0) + n;
		if (count != block_alloc_count) {
		    printf("after alloc block: ");
		    check_size(1);
		}
	    }
#endif
	    hp = pHeader(p);
	    xsize = hp->Size;
	    ysize = hp->Base[xsize-LAST_SIZE_OFFSET];
	    if (xsize <= oldn || xsize-oldn > BLOCK_UNIT_SIZE+3 || hp->Status != USED)
		fatal ("alloc", "sbrk error");
	    if (xsize != ysize)
		fatal ("alloc", "sbrk error");
#endif
	    return (int*)p->Area;
	}
    }
    size = (n >= BLOCK_ALLOC_SIZE)? n: BLOCK_ALLOC_SIZE;
    if (int((p = pHeader(shsbrk(size * sizeof (int))))) <= 0) {
	fatal ("alloc", "sbrk error");
    }
#ifdef TEST
    block_alloc_count += size;
#endif
#ifndef NDEBUG
/*
    printf("normal allocation for %d\n", size);
*/
#endif
    if (last_allocation != SPECIAL_ALLOCATION) {
	p->Pos = IS_TAIL;
	q = pHeader(&(p->Base[-(p->Base[-LAST_SIZE_OFFSET])]));
	q->Pos &= ~IS_TAIL;
/*
	printf("alloc: %d, %d\n", p->Base[-LAST_SIZE_OFFSET], q->Size);
*/
    } else {
	p->Pos = IS_HEAD | IS_TAIL;
    }
    p->Size = size;
    p->Base[size-LAST_SIZE_OFFSET] = size;
    last_allocation = (!SPECIAL_ALLOCATION);

    free_large_block(p->Area);

    goto retry;
}

void
free_large_block(int* p)
{
    register pHeader hp;
    pHeader hq;
    register int size;
/*
    int nsize;
*/

    hp = pHeader(&p[-AREA_OFFSET]);
    size = hp->Size;

#ifndef NDEBUG
#ifdef CHECK_SIZE
/*
    if (init == 0) {
	count = check_size(0) + size;
	if (count != block_alloc_count) {
	    printf("before free block: ");
	    check_size(1);
	}
    }
*/
#endif
#endif

    if (!(hp->Pos & IS_TAIL)) {
	hq = pHeader(&(hp->Base[size]));
	if (hq->Status == FREE) {
	    rm_queue(hq);
	    size += hq->Size;
	    hp->Size = size;
	    hp->Base[size-LAST_SIZE_OFFSET] = size;
	    hp->Pos |= hq->Pos;
	}
    }
    if (!(hp->Pos & IS_HEAD)) {
/*
	nsize = hp->Base[-LAST_SIZE_OFFSET];
	hq = pHeader(&(hp->Base[-nsize]));
*/
	hq = pHeader(&(hp->Base[-(hp->Base[-LAST_SIZE_OFFSET])]));
	if (hq->Status == FREE) {
	    rm_queue(hq);
	    hq->Size += size;
	    hq->Pos |= hp->Pos;
	    hq->Base[hq->Size-LAST_SIZE_OFFSET] = hq->Size;
	    hp = hq;
	}
    }
    hp->Next = mlink.Next;
    hp->Prev = &mlink;
    hp->Status = FREE;
    (mlink.Next)->Prev = hp;
    mlink.Next = hp;
#ifndef NDEBUG
#ifdef CHECK_SIZE
    if (init == 0) {
	count = check_size(0);
	if (count != block_alloc_count) {
	    printf("after free block: ");
	    check_size(1);
	}
    }
#endif
#endif
    return;
}
#ifdef PAS_DEBUGGER
//static int shalloc_total = 0;
//static int shfree_total = 0;
//static int shalloc_count = 0;
//staatic int shfree_count = 0;
#endif
void*
shared_alloc(unsigned nbytes)
{
    if (nbytes < 12) nbytes = 12;

#ifdef PAS_DEBUGGER
    //shalloc_total+=nbytes;
    //shalloc_count++;
#endif
/*
    int n = ((nbytes+3) & ~3) / sizeof(long);
    void *p = (n <= CONST_ALLOC_SIZE) ?
	(void*)alloc_const_block(n) : (void*)alloc_large_block(n);
#ifdef OVLD
    cerr << form("%#x = shared_alloc(%d bytes)\n", long(p), nbytes);
#endif
    assert (p != 0);
    return p;
*/
    return shmalloc(nbytes);
}

void
shared_free(void* addr, unsigned nbytes)
{

#ifndef NDEBUG
    int x = nbytes;
    for (char* p = addr; --x >= 0; *p++ = -1) ;
#endif
#ifdef PAS_DEBUGGER
    //shfree_total+=nbytes;
    //shfree_count++;
#endif
    shfree(addr);

/*
#ifdef OVLD
    cerr << form("shared_free(%#x, %d bytes)\n", long(addr), nbytes);
#endif
    int n = ((nbytes+3) & ~3) / sizeof(long);
    if (n <= CONST_ALLOC_SIZE)
	free_const_block((int*)addr, n);
    else
	free_large_block((int*)addr);
*/
}
#ifdef PAS_DEBUGGER
/* ǥХåѴؿ */
/* ͭΰγơ ΥХȿʤɤɽ*/
//static int cc = 0;
//void shared_monitoring()
//{
//    cc++;
//    fprintf(stderr," times %d \n",cc);
//    fprintf(stderr," shared monitoring %d - %d = %d\n",
//	    shalloc_total,shfree_total,shalloc_total-shfree_total);
//    fprintf(stderr," shared count %d - %d = %d\n",
//	    shalloc_count,shfree_count,shalloc_count-shfree_count);
//}
#endif
/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
