/*- -*- Mode: C -*-						       -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/alloc.h"

extern "C" {
    char  *malloc();
    void   free();
    //void   pelog();
};

void*
private_alloc(unsigned size)
{
    if (size < 12) size = 12;
    char *ptr = malloc(size);
    //pelog("%x -> %d\n", ptr, size);
    return ptr;
}

void
private_free(void* ptr, unsigned size)
{
    //pelog("%x <- %d\n", ptr, size);
#ifndef NDEBUG
    for (char *p = ptr; size-- > 0; *p++ = -1) ;
#endif
    free(ptr);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
