/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "sockcom.h"
#include "aum/parallel.h"

unsigned char	PAS_self_peno;
unsigned char	PAS_npe = 1;
int		PAS_message_may_be_received;

extern void Initialize_Environments ();
extern void Initialize_Signals ();
extern void Initialize_Sockets ();
extern

void
PAS_initialize_shared ()
  // {}
  // ̿ΤνԤʤ
  // {}
{
    Initialize_Environments ();
    if (PAS_npe > 1) {
	Initialize_Signals ();
	Initialize_Sockets ();
	if (Scheduling_strategy == ONLY_SEND_SELF)
	    Scheduling_strategy = ROUND_ROBIN;
    }
}

void
PAS_initialize_private ()
  // {}
  // PE ͭξ롥
  // {}
{
}

int
PAS_wait_for_terminate ()
    // {}
    // ¾PEλΤԤġƤνäƤʤ 0 򤫤
    // ޤĤäƤˤ 1 ֤ޤ顼
    // ˤ -1 ֤
    // {}
{
    return Wait_terminate ();
}

unsigned char
PAS_next_pe()
{
    if (PAS_npe > 1) {
	static int pe;
	do {
	    pe = (pe + 1) % PAS_npe;
	} while (pe == PAS_self_peno);
	return pe;
    }
    else
	return 0;
}

void
PAS_send (unsigned char pe, GlobalMessage* gm)
{
    Write_Message (pe, (Message*) gm);
}

GlobalMessage*
PAS_receive ()
{
    return Read_Message (1);
}

GlobalMessage*
PAS_receive_in_nonblocking ()
{
    return Read_Message (0);
}

void
PAS_begin_monitoring ()
{
}

void
PAS_end_monitoring ()
{
}

void
PAS_report_monitoring ()
{
    Report_message_statistics ();
}

void
PAS_sndrcvstats_send_to_pe0 (void* block, int nbytes)
{
}

void
PAS_report_sndrcvstats (const char *tag, int nitem)
{
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
