/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
#include "sockcom.h"

#include <stddef.h>
#include <sys/types.h>
#include <sys/time.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>
#include <assert.h>
#include <memory.h>
#ifndef NO_SYS_FCNTL_H
#include <unistd.h>
#endif
#include "aum/alloc.h"
#include "aum/parallel.h"

extern	"C" {

#   include <netinet/in.h>

};

static void request_resource ();

int
Write_Message (u_char pe, Message * mp)
{
#ifndef NDEBUG
    if (PAS_npe > 0)
	assert (Resource > 0);
#endif

    int	    r;
    mp->Resource (1);
    if (--Resource == 0) {
	request_resource ();
    }
    r = SockSend (pe, mp);
    return r;
}

static void
request_resource ()
{
    if (PAS_self_peno == 0) {
	GlobalResource += MESSAGE_RESOURCE;
    }
    else {
	Message *mp = new_SockMessage (Msg_Request_resource, MESSAGE_RESOURCE);
	SockSend (0, mp);
    }
    Resource += MESSAGE_RESOURCE;
#if RW_DEBUG
    printf ("[%s] New resource is %d.\n", PAS_self_name, Resource);
#endif
}

void
SockCom::Prepend (Message * mp)
{
    mp->Check ();
    if (sring.mq_first == NULL) {
	sring.mq_first = sring.mq_last = mp;
	mp->nextMessage (NULL);
    }
    else {
	mp->nextMessage (sring.mq_first);
	sring.mq_first = mp;
    }
}

void
SockCom::Enqueue (Message * mp)
{
    mp->Check ();
    mp->nextMessage (NULL);
    if (sring.mq_first == NULL) {
	sring.mq_first = sring.mq_last = mp;
    }
    else {
	sring.mq_last->nextMessage (mp);
	sring.mq_last = mp;
    }
}

void
SockCom::Append (Message * first, Message * last)
{
    first->Check ();
    if (sring.mq_first == NULL) {
	sring.mq_first = first;
	sring.mq_last = last;
    }
    else {
	sring.mq_last->nextMessage (first);
	sring.mq_last = last;
    }
}

Message *
SockCom::Dequeue ()
{
    if (sring.mq_first == NULL) {
	return NULL;
    }
    else {
	Message *mp = sring.mq_first;
	sring.mq_first = (Message *) sring.mq_first->nextMessage ();
	mp->Check ();
	mp->nextMessage (NULL);
	return mp;
    }
}


Boolean
Queuing_message_exist (u_char pe)
{
    return Cominfo[pe].Queuing_message_exist ();
}

int
Flush_send_buffer (u_char pe)
{
    return Cominfo[pe].Flush_send_buffer ();
}

int
SockCom::Flush_send_buffer ()
{
    if (sring.nbytes > 0)
	if (Try_to_send_else_buffering (NULL) < 0)
	    return -1;

    Message *mp = sring.mq_first;
    Message *last = sring.mq_last;
    Message *next;
    sring.mq_first = NULL;
    sring.mq_last = NULL;
    for (; mp; mp = next) {
	next = (Message *) mp->nextMessage ();
#if RW_DEBUG
	printf ("Flush: ");
	fflush (stdout);
#endif
	if (Try_to_send_else_buffering (mp) < 0) {
	    Append (mp, last);
#if RW_DEBUG
	    puts ("done");
	    fflush (stdout);
#endif
	    return -1;
	}
#if RW_DEBUG
	puts ("done");
	fflush (stdout);
#endif
    }
    return 1;
}

int
SockSend (u_char pe, Message * mp)
{
    mp->SockDst (pe);
    mp->MsgNo (Cominfo[mp->SockDst ()].One_message_sent (mp));
    mp->SockSrc (PAS_self_peno);

    if (PAS_self_peno == pe) {
	PAS_message_may_be_received++;
	Linking_Message (mp);
	return 1;
    }
    else {
	if (Queuing_message_exist (pe)) {
	    Cominfo[pe].Enqueue (mp);
	    return Flush_send_buffer (pe);
	}
	else {
	    if (Cominfo[pe].Try_to_send_else_buffering (mp) < 0) {
		Cominfo[pe].Enqueue (mp);
		return -1;
	    }
	    return 1;
	}
    }
}

int
SockCom::Try_to_send_else_buffering (Message * mp)
    // {}
    // å mp Ȥ롥»ͤåХåե
    // ĤäƤˤϡեå夹롥Ǥʤ mp 
    // 롥mp äˤ֤ͤեå夷ʤ
    // ο֤
    // {}
{
    assert (sock_fd >= 0);

    if (sring.nbytes > 0) {
	Flush (sring.buffer);
	return -1;
    }
    else {
	assert (0 <= mp->SockDst () && mp->SockDst () < MAX_PE);
	mp->Check ();
#if RW_SUCCESS
	cmsgno = mp->MsgNo ();
#endif
	u_short nbytes = mp->no_of_bytes ();
	sring.nbytes = nbytes;
#ifndef BIG_ENDIAN
	mp->Convert_network_byte_order ();
#endif
	Flush ((const char *) mp);
	FREE (mp, nbytes);
	return 1;
    }
}

int
SockCom::Flush (const char *ptr)
    // {}
    // ptr ؤΰ sock_fd 롥ΰ礭 sring.nbytes 
    // ݻƤ롥ˤο򡤥֥å줿ˤ
    // ο֤֥å줿ˤϡžǤʤäΰ sring.
    // buffer ˥ԡ롥Ȥ ptr ͿΤϡå
    // ΰ buffer ˥ԡΤ򤱤٤Ǥ롥
    // {}
{
#if RW_SUCCESS
    Log ("write");
    printf ("%d bytes ", sring.nbytes);
#endif

    assert (sring.nbytes > 0);
    assert (ptr != NULL);

    n_write++;
    int	    rval = write (sock_fd, ptr, sring.nbytes);
    if (rval == sring.nbytes) {
#if RW_SUCCESS
	if (!sring.success) {
	    sring.success = 1;
	    printf ("success.\n");
	}
	else
	    printf ("\n");
#endif
	sring.nbytes = 0;
	return 1;
    }

    n_write_blocked++;

#if RW_SUCCESS
    if (sring.success) {
	sring.success = 0;
	printf ("suspended (return=%d, rest=%d)\n",
		rval, sring.nbytes - rval);
    }
    else
	printf (" -\n");
    fflush (stdout);
#endif
    switch (rval) {
    case -1:
    case 0:
	if (errno != EWOULDBLOCK) {
	    perror ("Socket Error : Can't terminate [send]");
	    Exit (errno);
	}
	break;
    default:
	ptr += rval;
	sring.nbytes -= rval;
	break;
    }
    bcopy (ptr, sring.buffer, sring.nbytes);
    /* memcpy (sring.buffer, ptr, sring.nbytes); */
    errno = 0;
    return -1;
}

#if RW_SUCCESS
static void
SockCom::Log (const char *msg)
    const
{
    printf ("[%s+%d] PE%d{%d} %s ",
	    PAS_self_name, Resource, peno, cmsgno, msg);
}
#endif

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
