/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
#include "sockcom.h"

#include <stddef.h>
#include <sys/types.h>
#include <sys/time.h>
#include <fcntl.h>
#include <errno.h>
#include <assert.h>
#ifndef NO_SYS_FCNTL_H
#include <unistd.h>
#endif
#include <stdlib.h>
#include <memory.h>
#include "aum/alloc.h"
#include "aum/parallel.h"

extern "C" {

#   include <netinet/in.h>

};

extern void Ending_connection (u_char pe);
extern void Sigio_hold ();
extern void Sigio_release ();

static Message* Received_message_first;
static Message* Received_message_last;
static int  n_sockrecv_error;

static int  select_message (int waitflag);

GlobalMessage*
Read_Message (int waitflag)
{
    PAS_message_may_be_received = 0;
    n_sockrecv_error = 0;
    if (PAS_npe > 1) {
	for (;;) {
	    if (select_message (waitflag) <= 0)
		break;
	    waitflag = 0;
	}
    }
    GlobalMessage* gm = (GlobalMessage*) Received_message_first;
    Received_message_first = 0;
    return gm;
}

static int
select_message (int waitflag)
{
    int	    nfds;
    fd_set  r_ready;
    struct timeval wait;

    wait.tv_sec = 0;
    wait.tv_usec = 0;

    FD_ZERO (&r_ready);
    for (int i = 0; i < PAS_npe; i++)
	Cominfo[i].Fd_Set (&r_ready);

#ifdef MDEBUG
    printf ("[%s] selecting...", PAS_self_name);
    fflush (stdout);
#endif

    errno = 0;
    nfds = select (FD_SETSIZE, &r_ready, 0, 0,
		   waitflag ? (struct timeval*) 0 : &wait);

#ifdef MDEBUG
    printf (", %d selected (wait=%d, errno=%d)\n", nfds, waitflag, errno);
    fflush (stdout);
#endif

    switch (nfds) {
    case -1:
	if (errno != EINTR) {
	    perror ("select");
	    Exit (1);
	}
    case 0:
	return 0;

    default:
	for (int pe = 0; nfds > 0 && pe < PAS_npe; pe++) {
	    if (Cominfo[pe].Fd_IsSet (&r_ready)) {
		--nfds;
		if (Cominfo[pe].Read (pe) < 0) {
		    return -1;
		}
	    }
	}
	return 1;
    }
}

int
SockCom::Read (u_char pe)
    // {}
    // {}
{
#if RW_SUCCESS
    static char success[MAX_PE];
#endif

#ifdef MDEBUG
    printf ("[%s+%d] reading from Socket[%d]... ", PAS_self_name, Resource, pe);
    fflush (stdout);
#endif
    int	  rval;

    if (rring.mptr != NULL) {
	u_short nbytes = (rring.mtop->no_of_bytes ()
			  - (rring.mptr - (char *) rring.mtop));
	rval = ::read (sock_fd, rring.mptr, nbytes);
	if (rval != nbytes) {
#ifdef MDEBUG
	    printf ("%d bytes. (request %d bytes)\n", rval, nbytes);
#endif
	    if (rval <= 0) {
		perror ("read_message_into_ring_buffer");
		if (++n_sockrecv_error > 12)
		    exit (12);
		return -1;
	    }
	    rring.mptr += rval;
	    return 1;
	}
#ifndef BIG_ENDIAN
	((Message *)rring.mtop)->Convert_host_byte_order ();
#endif
	Linking_Message (rring.mtop);
	rring.mtop = NULL;
	rring.mptr = NULL;
    }

    struct header {
	u_char	tag;
	u_char	arity;
	u_short nbytes;
    } h;

    n_read++;
    errno = 0;
    rval = ::recv (sock_fd, (char*) &h, sizeof (h), MSG_PEEK);
    if (rval != sizeof (h)) {
#ifdef MDEBUG
	printf ("%d bytes. (request %d bytes)\n", rval, sizeof (h));
#endif
	if (errno == EWOULDBLOCK) {
	    n_read_blocked++;
#if RW_SUCCESS
	    if (success[pe]) {
		printf ("[%s+%d PE%d read would block\n",
			PAS_self_name, Resource, pe);
		success[pe] = 0;
	    }
#endif
	    errno = 0;
	    return -1;
	}
	if (rval == 0 && errno == 0) {
	    Ending_connection (pe);
	    return 0;
	}
	fflush (stdout);
	fprintf (stderr, "receive from Socket[%d]: ", pe);
	perror ("recv");
	Exit (1);
    }
#ifndef BIG_ENDIAN
    h.nbytes = ntohs (h.nbytes);
#endif
    ((Message*)&h)->Check ();

    switch (rval = read (sock_fd, rring.buffer, RCVBUFSIZ)) {
    case -1:
	perror ("reading stream message");
	return -1;

    case 0:
	if (errno == EINTR) {
	    fprintf (stderr, "EINTR: Socket[%d] = %d\n", pe, sock_fd);
	    sleep (1);
	    return -1;
	}
	else if (errno == EWOULDBLOCK) {
	    fprintf (stderr, "EWOULDBLOCK: Socket[%d] = %d\n", pe, sock_fd);
	    exit (1);
	}
	else if (errno == 0) {
	    Ending_connection (pe);
	    return -1;
	}
	if (errno)
	    fprintf (stderr, "errno = %d\n", errno);
	perror ("recv");
	sleep (1);
	return -1;

    default:
#ifdef MDEBUG
	printf ("%d bytes.\n", rval);
#endif
#if RW_SUCCESS
	if (!success[pe]) {
	    printf ("[%s+%d] PE%d read success. (%d bytes)\n",
		    PAS_self_name, Resource, pe, rval);
	    success[pe] = 1;
	}
#endif
	{
	    char   *ptr = rring.buffer;
	    while (rval > 0) {
		rring.mtop = (Message*) ALLOC (h.nbytes);
		bcopy (ptr, rring.mtop, h.nbytes);
		if (rval >= h.nbytes) {
#ifndef BIG_ENDIAN
		    ((Message *)rring.mtop)->Convert_host_byte_order ();
#endif
		    Linking_Message (rring.mtop);
		    ptr += h.nbytes;
		    rval -= h.nbytes;
		    h = *(struct header *) ptr;
#ifndef BIG_ENDIAN
		    h.nbytes = ntohs (h.nbytes);
#endif
		}
		else {
		    rring.mptr = ((char *) rring.mtop) + rval;
		    break;
		}
	    }
	}
	return 1;
    }
}

void
Linking_Message (Message * mp)
{
    mp->Check ();

#if RW_SUCCESS
    printf ("[%s+%d] PE%d{%d} read %d bytes\n",
	    PAS_self_name, Resource,
	    mp->SockSrc(), mp->MsgNo(),
	    mp->no_of_bytes ());
    fflush (stdout);
#endif

    Count_message_number (mp);
    if (mp->mTag () == Msg_Resource || mp->mTag () == Msg_Request_resource) {
#if RW_DEBUG
	printf ("[%s+%d] Receive resource %d from PE%d{%d}, ",
		PAS_self_name, Resource, mp->Resource (),
		mp->SockSrc(), mp->MsgNo());
#endif

	if (mp->mTag() == Msg_Resource) {
#if RW_DEBUG
	    printf ("(gR=%d->%d)\n",
		    GlobalResource, GlobalResource - mp->Resource ());
#endif
	    GlobalResource -= mp->Resource ();
	}
	else {
	    assert (PAS_self_peno == 0);
#if RW_DEBUG
	    printf ("(gR=%d->%d)\n",
		    GlobalResource, GlobalResource + mp->Resource ());
#endif
	    GlobalResource += mp->Resource ();
	}
	FREE (mp, mp->no_of_bytes());
    }
    else {
	Resource += mp->Resource ();
	mp->nextMessage(0);
	if (!Received_message_first) {
	    Received_message_first = mp;
	}
	else {
	    Received_message_last->nextMessage(mp);
	}
	Received_message_last = mp;
    }
}

Boolean
Linked_Message_exist ()
{
    return Received_message_first ? TRUE : FALSE;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
