/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
#include "sockcom.h"

#include <stddef.h>
#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>
extern int errno;
#include <assert.h>
#ifndef NO_SYS_FCNTL_H
#include <unistd.h>
#endif
#include "aum/parallel.h"

SockCom Cominfo[MAX_PE];

static void make_send_sockets ();
static void let_non_blocking_and_async ();
static void write_ready_message (u_char pe);

void
Initialize_Sockets ()
    // {}
    // ̿ѤΥåȤ롥ʬȤPEֹ礭PE
    // Ƥ³ΤԤʬȤPEֹ꾮PEФ
    // ³׵Ф(Connect)礭PEֹPE¾
    // ³Ԥ򤷤ʤ
    //
    // ˡåȤ°֥å⡼ɤʤӤƱ̿⡼
    // ˤ롥
    // {}
{
    if (PAS_self_peno < PAS_npe - 1) {
	Cominfo[PAS_self_peno].Listen ();
	make_send_sockets ();
	Cominfo[PAS_self_peno].Accept ();
    }
    else
	make_send_sockets ();

    let_non_blocking_and_async ();
}

static void
make_send_sockets ()
    // {}
    // ʬȤPEֹ꾮PEФ³׵Ф
    // 롥
    // {}
{
    for (int pe = 0; pe < PAS_self_peno; pe++) {
	Cominfo[pe].Connect ();
	write_ready_message (pe);
    }
}

static void

let_non_blocking_and_async ()
    // {}
    // åȤ°֥å⡼ɤʤӤƱ̿⡼ɤˤ롥
    // {}
{
    int	    i;
    for (i = 0; i < PAS_npe; i++) {
//	printf ("PE%d's socket is %d\n", i, Cominfo[i].Socket());
	if (!Cominfo[i].Invalid_socket()) {
	    if (Cominfo[i].Fcntl (F_SETOWN, getpid ()) < 0) {
		perror ("Socket Error : fcntl F_SETOWN");
		Exit (errno);
	    }
	    if (Cominfo[i].Fcntl (F_SETFL, FASYNC|FNDELAY) < 0) {
		perror ("Socket Error : fcntl F_SETFL, FASYNC|FNDELAY");
		Exit (errno);
	    }
	}
    }
}

static void
write_ready_message (u_char pe)
    // {}
    // PEֹ pe ˽å롥
    // {}
{
    Message *mp = new_SockMessage (Msg_Initialize, 0);

#if RW_DEBUG
    printf ("[%s] writing READY to %s:%d (%d)... ",
	    PAS_self_name, Cominfo[pe].Hostname (), pe, Cominfo[pe].Port_number());
    fflush (stdout);
#endif
    SockSend (pe, mp);
#if RW_DEBUG
    puts ("done");
    fflush (stdout);
#endif
}

void
Terminate_Sockets ()
    // {}
    // ƤΥåȤĺ롥
    // {}
{
    printf ("[%s+%d] END\n", PAS_self_name, Resource);
    fflush (stdout);
    {
	int	i;
	for (i = 0; i < PAS_npe; i++)
	    Cominfo[i].Shutdown ();
    }
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */

