/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef sysdep_sockcom_h
#define sysdep_sockcom_h

#include "config.h"

#ifndef SOCKET_COMM
#define SOCKET_COMM
#endif

#include <stdio.h>
#include <stddef.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "aum/bool.h"
#include "aum/global.h"
#include "aum/messageq.h"
#include "aum/message.h"

// ǥХåѤΥե饰
#define RW_DEBUG 0
#define RW_SUCCESS 0
#undef MDEBUG

class Msgno {
public:
    int		normal;		// normal message counter
    int		control;	// control message counter
};

struct SndRing {
    short	nbytes;		// # of data in buffer
    short	bufsiz;		// message buffer size
    char*	buffer;		// point to message buffer
    Message*	mq_first;	// queuing messages
    Message*	mq_last;	// queuing messages
#if RW_SUCCESS
    int		success;	// debugging flag
#endif
};

struct RcvRing {
    Message*	mtop;		// point to the top of message buffer
    char*	mptr;		// next receive point
    char*	buffer;		// point to message buffer
    short	bufsiz;		// message buffer size
};

class SockCom {
private:
    const char* name;		// self name (hostname:lport)
    const char* hostname;	// host name
    u_short	port;		// local port
    short	sock_fd;	// socket file descripter
    u_char	debug;		// debug flag
    u_char	peno;		// self PE's number;
    Msgno	sndmsgno;	// counter on sending
    Msgno	rcvmsgno;	// counter on receiving
    SndRing	sring;		// send buffer
    RcvRing	rring;		// receive buffer
#if RW_SUCCESS
    int		cmsgno;		// current message number
#endif

public:
    u_long	n_write;	// # of send
    u_long	n_write_blocked;// # of send blocked
    u_long	n_read;		// # of receive
    u_long	n_read_blocked; // # of receive blocked

    void	Initialize (u_char pe, const char *);

    const char* Hostname () const;
    u_short	Port_number () const;
//    short	Socket () const;

    void	Listen ();
    void	Accept ();
    void	Connect ();
    void	Shutdown ();
    int		Fcntl (int cmd, int arg);
    void	Set_socket_options ();

    void	Fd_Set (fd_set*);
    Boolean	Fd_IsSet (fd_set*);

    int		Read (u_char pe);
    int		Peek (Message*, int siz);
    Boolean	Invalid_socket ();

    Boolean	Queuing_message_exist ();
    int		Flush_send_buffer ();

    int		Try_to_send_else_buffering (Message*);
    int		Flush (const char*);
    void	Prepend (Message*);
    void	Enqueue (Message*);
    void	Append (Message* first, Message* last);
    Message*	Dequeue ();

    u_long	One_message_received (const Message*);
    u_long	One_message_sent (const Message*);
    void	Report (u_char) const;
    void	print_sring () const;
    void	print_rring () const;
#if RW_SUCCESS
    void	Log (const char *) const;
#endif

    friend void Count_message_number (Message*);
    friend void Report_message_number ();

};


extern SockCom	Cominfo[MAX_PE];

// PEξ
extern const char* PAS_self_name; // self name (hostname:port-no)

// ĤPEǽ˻äƤ Resource ͡ޤʤʤä˰
// 䤹
#define MESSAGE_RESOURCE	1000
extern int	GlobalResource;
extern int	Resource;


// åȤХåե礭
#define SNDBUFSIZ	4096
#define RCVBUFSIZ	4096


//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//


extern int     SockSend (u_char pe, Message*);
extern GlobalMessage*	Read_Message (int waitflag);
extern int     Write_Message (u_char pe, Message * mp);
extern void    Linking_Message (Message * mp);
extern Boolean Linked_Message_exist ();
extern int     Wait_terminate ();
extern Boolean Queuing_message_exist (u_char pe);
extern int     Flush_send_buffer (u_char pe);
extern void    Exit (int);
extern void    Report_message_statistics ();

extern "C" {
    int	 recv (int s, void *buf, int len, int flags);
    int	 shutdown (int s, int how);
    int	 getsockopt (int s, int level, int optname, void* optval, int* optlen);
    int	 setsockopt (int s, int level, int optname, const char* optval, int  optlen);
#ifdef i386
    unsigned long htonl (unsigned long);
    unsigned short htons (unsigned short);
    unsigned long ntohl (unsigned long);
    unsigned short ntohs (unsigned short);
#endif
};

//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//

inline const char* SockCom::Hostname ()
    const
{
    return hostname;
}

inline u_short SockCom::Port_number ()
    const
{
    return port;
}

//inline short SockCom::Socket ()
//    const
//{
//    return sock_fd;
//}

inline void SockCom::Fd_Set (fd_set *fd)
{
    if (sock_fd >= 0)
	FD_SET (sock_fd, fd);
}

inline Boolean SockCom::Fd_IsSet (fd_set *fd)
{
    return (sock_fd >= 0 && FD_ISSET (sock_fd, fd)) ? TRUE : FALSE;
}

inline int SockCom::Peek (Message* mp, int siz)
{
    return ::recv (sock_fd, (char*)mp, siz, MSG_PEEK);
}

inline Boolean SockCom::Invalid_socket ()
{
    return sock_fd < 0 ? TRUE : FALSE;
}

inline Boolean SockCom::Queuing_message_exist ()
{
    if (sring.nbytes > 0 || sring.mq_first != NULL)
	return TRUE;
    return FALSE;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !sysdep_sockcom_h */
