/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
#include "sockcom.h"

#include <sys/types.h>
#include <sys/time.h>
#include <fcntl.h>
#include <errno.h>
#include <memory.h>
#ifndef NO_SYS_FCNTL_H
#include <unistd.h>
#endif
#include <stdlib.h>
#include "aum/alloc.h"
#include "aum/error.h"
#include "aum/parallel.h"

extern "C" {

#   include <netinet/in.h>
#   include <netdb.h>

    extern struct hostent* gethostbyname (const char*);
};


static const char* get_host_part (const char* name);
static	      int  get_port_part (const char* name);

void SockCom::Initialize (u_char pe, const char* s)
    // {}
    // ۥ̾:ݡֹηͿ s ۥ̾ȥݡ
    // 򥻥åȤ롥ޤѿνʤӤ˥Хåեγݤ
    // ʤ
    // {}
{
    name = s;
    hostname = get_host_part (s);
    port = get_port_part (s);
    sock_fd = -1;
    peno = pe;

    sndmsgno.normal = sndmsgno.control = 0;
    rcvmsgno.normal = rcvmsgno.control = 0;

    sring.nbytes = 0;
    sring.buffer = ALLOC (SNDBUFSIZ);
    sring.bufsiz = SNDBUFSIZ;
    sring.mq_first = 0;
    sring.mq_last = 0;

    rring.mtop = 0;
    rring.mptr = 0;
    rring.buffer = ALLOC (RCVBUFSIZ);
    rring.bufsiz = RCVBUFSIZ;
}

static const char*
get_host_part (const char* name)
    // {}
    // ۥ̾:ݡֹηͿ name ۥ̾
    // ۥ̾ΰϤǳݤ롥
    // {}
{
    char   *p = ALLOC (strlen (name) + 1);
    char   *q;
    strcpy (p, name);
    q = p;
    while (*p++ != ':');
    *(p - 1) = '\0';
    return q;
}

static int
get_port_part (const char* name)
    // {}
    // ۥ̾:ݡֹηͿ name ݡֹ
    // Ф
    // {}
{
    const char *p = name;
    while (*p++ != ':');
    return atoi (p);
}

u_long SockCom::One_message_received (const Message* mp)
    // {}
    // ååμ˱ơ󥿤ͤܣ롥
    // ͤϼäåθĿǤ
    // {}
{
    switch (mp->mTag()) {
    case Msg_Resource:
    case Msg_Request_resource:
    case Msg_Initialize:
    case Msg_Terminate:
	rcvmsgno.control++;
	break;

    default:
	rcvmsgno.normal++;
	break;
    }
    return rcvmsgno.normal + rcvmsgno.control;
}

u_long SockCom::One_message_sent (const Message* mp)
    // {}
    // äåμ˱ơ󥿤ͤܣ롥֤
    // äåθĿǤ
    // {}
{
    switch (mp->mTag()) {
    case Msg_Resource:
    case Msg_Request_resource:
    case Msg_Initialize:
    case Msg_Terminate:
	sndmsgno.control++;
	break;

    default:
	sndmsgno.normal++;
	break;
    }
    return sndmsgno.normal + sndmsgno.control;
}

void SockCom::Report (u_char pe)
    const
    // {}
    // åξɸϤ˥ץȥȤ롥
    // {}
{
    if (pe == PAS_self_peno)
	return;

    printf ("PE%d  send %d normal, %d control messages\n",
	    pe, sndmsgno.normal, sndmsgno.control);
    printf ("PE%d  recv %d normal, %d control messages\n",
	    pe, rcvmsgno.normal, rcvmsgno.control);
}

void SockCom::Listen ()
    // {}
    // ѤΥåȤ³Ԥ֤ˤ롥
    // {}
{
    struct sockaddr_in server;

    int s = socket (AF_INET, SOCK_STREAM, 0);
    if (s < 0) {
	perror ("Socket Error : listen()");
	//perror ("Socket Error : opening stream receiver socket");
	Exit (errno);
    }
#ifdef SO_REUSEADDR
    {
	int	one = 1;
	setsockopt (s, SOL_SOCKET, SO_REUSEADDR, (char*)&one, sizeof (int));
    }
#endif /* SO_REUSEADDR */

    bzero (&server, sizeof server);
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = htonl (INADDR_ANY);
    server.sin_port = htons (port);

    {
	int	retry = 20;
	while (bind (s, (struct sockaddr *) & server, sizeof server) < 0) {
	    if (--retry == 0) {
		perror ("Socket Error : Binding TCP receiver socket");
		Exit (errno);
	    }
#ifdef SO_REUSEADDR
	    sleep (1);
#else
	    sleep (10);
#endif /* SO_REUSEADDR */
	}
    }
    errno = 0;

#ifdef SO_DONTLINGER
    if (setsockopt (s, SOL_SOCKET, SO_DONTLINGER, (char *) NULL, 0))
	perror ("Socket Error : Setting TCP SO_DONTLINGER");
#else /* not SO_DONTLINGER */
#ifdef SO_LINGER
    {
	static int linger[2] = {0, 0};
	if (setsockopt (s, SOL_SOCKET, SO_LINGER, (char *)linger, sizeof (linger)))
	    perror ("Socket Error : Setting TCP SO_LINGER");
    }
#endif /* SO_LINGER */
#endif /* not SO_DONTLINGER */

#if RW_DEBUG
    printf ("Socket port #%d\n", ntohs (server.sin_port));
#endif

    if (listen (s, PAS_npe) < 0) {
	perror ("Socket Error : receiver listen()");
	Exit (errno);
    }
    sock_fd = s;
}

void SockCom::Accept ()
    // {}
    // ʬPEֹ礭PE³ԤġʼʬPEֹ꾮
    // PEȤδ֤ΥåȤϤ餫³ԤʤΤԤԤʤ
    // ɬפϤʤ³λ顤ΥåȤǽΥå
    // 롥ǽΥåȯξ󤫤ɤPEФ
    // ϩȽǤ롥
    //
    // ɬפʿ̿ϩǤʤС³ԤѤΥåȤĤ롥
    // {}
{
    int	  npe = PAS_self_peno + 1;
    int	  retry = 30;
    while (npe < PAS_npe) {
	int	nfds;
	fd_set	r_ready;
	struct timeval wait;

	wait.tv_sec = 1;
	wait.tv_usec = 0;

	FD_ZERO (&r_ready);
	FD_SET (sock_fd, &r_ready);

	nfds = select (FD_SETSIZE, &r_ready, 0, 0, &wait);
	if (nfds < 0) {
	    perror ("Socket Error : select");
	    continue;
	}
	else if (nfds == 0) {
	    if (npe < PAS_npe) {
		if (--retry == 0) {
		    printf ("[%s] timeout\n", PAS_self_name);
		    Exit (1);
		}
	    }
	    else
		break;
	}
	if (FD_ISSET (sock_fd, &r_ready)) {
	    int	    msgsock;

	    npe++;
#if RW_DEBUG
	    printf ("[%s] accepting... ", PAS_self_name);
	    fflush (stdout);
#endif
	    msgsock = accept (sock_fd, (struct sockaddr *) 0, (int *) 0);
	    if (msgsock < 0) {
		perror ("Socket Error : accept()");
	    }
	    else {
		Message m;
#if RW_DEBUG
		printf ("reading READY... ");
		fflush (stdout);
#endif
		if (read (msgsock, &m, sizeof (Message)) < 0) {
		    perror ("Socket Error : read");
		    sleep (1);
		    break;
		}
		int x = m.SockSrc();
		Cominfo[x].sock_fd = msgsock;
		Cominfo[x].Set_socket_options ();
		Cominfo[x].One_message_received (&m);
#if RW_DEBUG
		printf ("PE%d (%d) done\n", x, msgsock);
#endif
	    }
	}
    }
    Shutdown ();
}

void
SockCom::Set_socket_options ()
    // {}
    // åȤΥץꤹ롥߹ԤʤäƤΤϡǥХå
    // ⡼ɤХåե礭Ǥ롥
    // {}
{
    int s = sock_fd;
    int x;
    if (debug) {
	x = 1;
	if (setsockopt (s, SOL_SOCKET, SO_DEBUG, (char*) &x, sizeof (x)) < 0) {
	    perror ("Socket Error : setsockopt SOL_SOCKET, SO_DEBUG");
	    Exit (errno);
	}
    }
    if (rring.bufsiz != RCVBUFSIZ) {
	x = rring.bufsiz;
	if (setsockopt (s, SOL_SOCKET, SO_RCVBUF, (char*)&x, sizeof (x)) < 0) {
	    perror ("Socket Error : setsockopt SOL_SOCKET, SO_RCVBUF");
	    Exit (errno);
	}
    }
    if (sring.bufsiz != SNDBUFSIZ) {
	x = sring.bufsiz;
	if (setsockopt (s, SOL_SOCKET, SO_RCVBUF, (char*)&x, sizeof (x)) < 0) {
	    perror ("Socket Error : setsockopt SOL_SOCKET, SO_RCVBUF");
	    Exit (errno);
	}
    }
}

void SockCom::Connect ()
    // {}
    // ʬPEֹ꾮PEФ³ߤ롥³λ
    // åȤݡֹФʬ¦Υݡֹκ
    // Ԥʤ
    // {}
{
    short   retry = 10;
    struct hostent *hp;
    struct sockaddr_in server;

    server.sin_family = AF_INET;
    if ((hp = gethostbyname (hostname)) == NULL)
	fatal (name, "unknown host");

    bcopy ((char *) hp->h_addr, (char *) &server.sin_addr, hp->h_length);
    server.sin_port = htons (port);

#if RW_DEBUG
    printf ("[%s] connecting to %s (%d)... ",
	    PAS_self_name, name, ntohs (server.sin_port));
    fflush (stdout);
#endif

    for (;;) {
	if ((sock_fd = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
	    perror ("Socket Error : opening stream sender socket");
	    Exit (errno);
	}

	if (connect (sock_fd, (struct sockaddr *)&server, sizeof server) >= 0)
	    break;
	if (--retry == 0) {
	    perror ("Socket Error : connect()");
	    Exit (errno);
	}
	close (sock_fd);
	sleep (2);
    }
#if RW_DEBUG
    puts ("done");
#endif
    {
	int length = sizeof (server);
	if (getsockname (sock_fd, (struct sockaddr *)&server, &length) < 0) {
	    perror ("Socket Error : getting socket name");
	    Exit (errno);
	}
    }
    port = ntohs (server.sin_port);
#if RW_DEBUG
    printf ("Socket port #%d\n", port);
#endif
}

void SockCom::Shutdown ()
    // {}
    // åȤĺåȤͤ򥻥åȤ롥
    // {}
{
    shutdown (sock_fd, 2);
    sock_fd = (-1);
}

int SockCom::Fcntl (int cmd, int arg)
    // {}
    // åȤ°롥
    // {}
{
    return fcntl (sock_fd, cmd, arg);
}

void SockCom::print_sring ()
    const
{
    printf ("rest %d bytes, mq_first=%x", sring.nbytes, sring.mq_first);
}

void SockCom::print_rring ()
    const
{
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
