/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "sockcom.h"

#include <stddef.h>
#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>
#include <memory.h>
#ifndef NO_SYS_FCNTL_H
#include <unistd.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include "aum/parallel.h"

extern void Sigio_hold ();
extern void Sigio_release ();

static int  wait_terminate_1 ();
static void send_terminate_message ();
static void return_resource_to_pe0 ();

void
Exit (int n)
    // {}
    // åξɽƽλ롥
    // {}
{
    Report_message_statistics ();
    fprintf (stderr, "Exit %d\n", n);
    exit (n);
}

void
Report_message_statistics ()
{
    Report_message_number ();
    {
	u_long n_write = 0;
	u_long n_write_blocked = 0;
	u_long n_read = 0;
	u_long n_read_blocked = 0;

	for (int pe = 0; pe < PAS_npe; pe++) {
	    n_write += Cominfo[pe].n_write;
	    n_write_blocked += Cominfo[pe].n_write_blocked;
	    n_read += Cominfo[pe].n_read;
	    n_read_blocked += Cominfo[pe].n_read_blocked;
	}
	if (n_write)
	    printf ("%d write, %d write blocked. %d%% blocked.\n",
		    n_write, n_write_blocked, n_write_blocked*100/n_write);

	if (n_read)
	    printf ("%d read, %d read blocked. %d%% blocked.\n",
		    n_read, n_read_blocked, n_read_blocked*100/n_read);
    }
    fflush (stdout);
}

void
Ending_connection (u_char pe)
    // {}
    // ̿˰۾郎˥åȤθ򤹤롥
    // {}
{
    printf ("[%s+%d] ending connection to PE%d's socket.\n",
	    PAS_self_name, Resource, pe);
    fflush (stdout);
    Cominfo[pe].Shutdown ();
}

int
Wait_terminate ()
    // {}
    // ¾ PE λΤġ¾ PE λͤ
    // ʬΥåʤȤͳˤưʤ
    // ϣ֤Ǥʤϡ֤ͤ
    // {}
{
#ifdef MDEBUG
    printf ("[%s] waiting terminate.\n", PAS_self_name);
#endif
    if (PAS_npe > 1) {
	{
	    int blocked = 0;
	    for (int pe = 0; pe < PAS_npe; pe++) {
#ifdef MDEBUG
		printf ("[%s] queue[%d] ", PAS_self_name, pe);
		Cominfo[pe].print_sring ();
		printf ("\n");
#endif
		if (Queuing_message_exist (pe))
		    if (Flush_send_buffer (pe) < 0)
			blocked = 1;
	    }
	    if (blocked)
		return 0;
	}
/*	if (PAS_message_may_be_received)
	    return 1;
*/
	int r;
	r = wait_terminate_1 ();
	return r;
    }
    else {
	return Linked_Message_exist () == TRUE ? 1 : -1;
    }
}

static int
wait_terminate_1 ()
    // {}
    // PEֹ椬ݤˤäƽۤʤ롥ʤоΤΥ꥽
    // οPEPEΥ꥽οӤ롥⤷ξԤʤС
    // ƤPEPEλԤ֤ʤΤǽλåPE -1 
    // ֤ʤʤм¹PEĤäƤΤ֤ͤ
    //
    // PEֹ椬Ǥʤ硤Ĥä꥽PE֤¾PE
    // ΥåԤ֤롥θ塤Ƥå
    // PEνλåʤ -1 ֤ʳξˤ
    // ֤ͤ
    //
    // ⤷˥顼ˤ֤ͤ
    // {}
{
    if (PAS_self_peno == 0) {
	if (Resource == GlobalResource) {
	    send_terminate_message ();
	    return -1;
	}
	else {
#ifdef MDEBUG
	    printf ("PE0 waiting, gR=%d, R=%d.\n",
		    GlobalResource, Resource);
	    fflush (stdout);
#endif
	    return 1;
	}
    }
    else {
	if (Resource > 0) {
#if RW_DEBUG
	    printf ("[%s] wait terminate, rest resources=%d\n",
		    PAS_self_name, Resource);
#endif
	    return_resource_to_pe0 ();
	}
	{
	    int	    nfds;
	    fd_set  r_ready;
#ifdef MDEBUG
	    printf ("[%s] selecting. gR=%d, R=%d...",
		    PAS_self_name, GlobalResource, Resource);
	    fflush (stdout);
#endif
	    {
		int	i;
		FD_ZERO (&r_ready);
		for (i = 0; i < PAS_npe; i++)
		    Cominfo[i].Fd_Set (&r_ready);
	    }
	    nfds = select (FD_SETSIZE, &r_ready, 0, 0, 0);
#ifdef MDEBUG
	    printf (", %d selected\n", nfds);
	    fflush (stdout);
#endif
	    if (nfds <= 0) {
		if (errno == EINTR)
		    return wait_terminate_1 ();
		perror ("Socket Error : select()");
		return -1;
	    }
	    else {
		if (Cominfo[0].Fd_IsSet (&r_ready)) {
		    Message m;
		    int	  r;
#ifdef MDEBUG
		    printf ("[%s+%d] peeking... ", PAS_self_name, Resource);
		    fflush (stdout);
#endif
		    if ((r = Cominfo[0].Peek (&m, sizeof (Message))) <= 0) {
			if (r == 0 && errno == 0) {
			    Ending_connection (0);
			    return -1;
			}
			//fprintf (stderr, "+receive from Socket[%d]: ", 0);
			perror ("Socket Error : Can't terminate [recv]");
			puts ("Sleeping");
			fflush (stdout);
			sleep (10);
			return -1;
		    }
#ifdef MDEBUG
		    puts ("done");
#endif
		    if (m.mTag() == Msg_Terminate) {
			m.Convert_network_byte_order ();
			Count_message_number (&m);
#if RW_DEBUG
			printf ("[%s+d] receive TERMINATE message\n",
				PAS_self_name, Resource);
			fflush (stdout);
#endif
			return -1;
		    }
		}
		return 1;
	    }
	}
	return 1;
    }
}

static void
send_terminate_message ()
    // {}
    // PEPEФƽλå롥
    // {}
{
    int	    i;
    for (i = 1; i < PAS_npe; i++) {
	Message *mp = new_SockMessage (Msg_Terminate, 0);
#if RW_DEBUG
	printf ("[%s+%d] send terminate message to PE%d.\n",
		PAS_self_name, Resource, i);
	fflush (stdout);
#endif
	SockSend (i, mp);
	Cominfo[i].Shutdown ();
    }
}

static void
return_resource_to_pe0 ()
    // {}
    // PEֹ棰ФƻĤä꥽֤
    // {}
{
    if (Cominfo[0].Invalid_socket ())
	Exit (0);

    if (Resource > 0) {
#ifdef MDEBUG
	printf ("[%s] return resources to PE0 (gR=%d, R=%d)\n",
		PAS_self_name, GlobalResource, Resource);
	fflush (stdout);
#endif
	Message *mp = new_SockMessage (Msg_Resource, Resource);
	Resource = 0;
	SockSend (0, mp);
    }
}


/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
