/*- -*- Mode: C -*-						       -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>

extern int getrusage ();

static struct rusage rusage;

/*
* UNIX ץ˴ؤ꥽μ롥
*/
void
Reset_rusage()
{
    getrusage(RUSAGE_SELF, &rusage);
}

/*
*  Reset_rusage() ƤӽФ
* UNIX ץ˴ؤ꥽κʬ rup ˥åȤ롥
* {}
*/
void
Report_rusage(rup)
    struct rusage *rup;
{
    struct rusage r;

    getrusage(RUSAGE_SELF, &r);
    rup->ru_utime.tv_sec = r.ru_utime.tv_sec - rusage.ru_utime.tv_sec;
    rup->ru_utime.tv_usec = r.ru_utime.tv_usec - rusage.ru_utime.tv_usec;

    rup->ru_stime.tv_sec = r.ru_stime.tv_sec - rusage.ru_stime.tv_sec;
    rup->ru_stime.tv_usec = r.ru_stime.tv_usec - rusage.ru_stime.tv_usec;

    rup->ru_maxrss   = r.ru_maxrss   - rusage.ru_maxrss;
    rup->ru_ixrss    = r.ru_ixrss    - rusage.ru_ixrss;
    rup->ru_idrss    = r.ru_idrss    - rusage.ru_idrss;
    rup->ru_isrss    = r.ru_isrss    - rusage.ru_isrss;
    rup->ru_minflt   = r.ru_minflt   - rusage.ru_minflt;
    rup->ru_majflt   = r.ru_majflt   - rusage.ru_majflt;
    rup->ru_nswap    = r.ru_nswap    - rusage.ru_nswap;
    rup->ru_inblock  = r.ru_inblock  - rusage.ru_inblock;
    rup->ru_oublock  = r.ru_oublock  - rusage.ru_oublock;
    rup->ru_msgsnd   = r.ru_msgsnd   - rusage.ru_msgsnd;
    rup->ru_msgrcv   = r.ru_msgrcv   - rusage.ru_msgrcv;
    rup->ru_nsignals = r.ru_nsignals - rusage.ru_nsignals;
    rup->ru_nvcsw    = r.ru_nvcsw    - rusage.ru_nvcsw;
    rup->ru_nivcsw   = r.ru_nivcsw   - rusage.ru_nivcsw;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */

