/*- -*- Mode: C -*-						       -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stdio.h>
#include <varargs.h>
#include <sys/types.h>

extern int fprintf ();
extern int vfprintf ();
extern void fflush ();
extern u_char PAS_self_peno;

/* if non zero, print pelog messages */
int PElog;
char *Logfile;

static FILE*
get_file_pointer ()
{
    static FILE* logfp;
    if (!Logfile)
	return stdout;
    if (!logfp) {
	char filename[BUFSIZ];
	sprintf (filename, "%s.%d", Logfile, PAS_self_peno);
	logfp = fopen (filename, "w");
    }
    return logfp;
}

void
pelog (va_alist)
    va_dcl
{
    va_list args;
    char *fmt;
    FILE *out = get_file_pointer ();

    va_start (args);
    (void) fprintf (out, "%02d: ", PAS_self_peno);
    fmt = va_arg (args, char *);
    (void) vfprintf (out, fmt, args);
    (void) fprintf (out, "\n");
    (void) fflush (out);
    va_end (args);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */

