/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "sockcom.h"

#ifdef sequent
extern "C" {
#  include "/usr/include/signal.h"
}
#else
#  include <signal.h>
#endif

#include <stdlib.h>
#include "aum/error.h"
#include "aum/parallel.h"
#include "utils/utils.h"

// Global variables
const char* PAS_self_name;
int   GlobalResource;
int   Resource;


static char TAG[] = "Initialize_Environments";
static void env_isnt_set (const char* env);

static void
initialize_resource ()
{
    if (PAS_self_peno == 0)
	GlobalResource = MESSAGE_RESOURCE * PAS_npe;
    Resource = MESSAGE_RESOURCE;
}

void
Initialize_Environments ()
    // {}
    // Ķѿ鼫ʬ̾:ݡֹ桤PEο¾PE̾:ݡ
    // ֹ롥¾PE˴ؤComInfo[i].Initialize(p)ˤ
    // ƽ롥Ǹ˥꥽ͤͤ򥻥åȤ롥꥽ͤϳ
    // PEνλȽꤹΤѤ롥
    // {}
{
    {
	PAS_self_name = getenv ("AUM_SELF");
	if (!PAS_self_name) {
	    PAS_self_name = "self";
	    PAS_npe = 1;
	    PAS_self_peno = 0;
	    initialize_resource ();
	    return;
	}
	PAS_self_name = SavePureString (PAS_self_name);
    }
    {
	char* aum_npe_name = getenv ("AUM_NPE");
	if (!aum_npe_name)
	    env_isnt_set ("AUM_NPE");
	int x;
	sscanf (aum_npe_name, "%d", &x);
	PAS_npe = x;
	if (PAS_npe > MAX_PE)
	    fatal (TAG, "too many PEs");
    }
    {
	int i;
	int self_peno = -1;
	for (i = 0; i < PAS_npe; i++) {
	    char    env[128];
	    const char	 *p;
	    (void) sprintf (env, "AUM_PE%d", i);

	    p = getenv (env);
	    if (!p)
		env_isnt_set (env);
	    Cominfo[i].Initialize(i, SavePureString (p));
	    if (self_peno < 0 && strcmp (p, PAS_self_name) == 0) {
		self_peno = i;
	    }
	}
	PAS_self_peno = self_peno;
    }
    initialize_resource ();
}

static void
env_isnt_set (const char* env)
{
    error (TAG, "ENVIRONMENT variable %s not defined", env);
}


static void
sigpipe ()
{
    fprintf (stderr, "\n***Catch SIGPIPE\n");
}

static void
sigio ()
{
    /* fprintf (stderr, "\n***Catch SIGIO\n");*/
//    Read_Message ();
    PAS_message_may_be_received++;
}

static void
sigurg ()
{
    fprintf (stderr, "\n***Catch SIGURG\n");
}

void
Sigio_hold ()
{
    signal (SIGIO, SIG_IGN);
}

void
Sigio_release ()
{
    signal (SIGIO, sigio);
}

void
Initialize_Signals ()
{
    signal (SIGPIPE, sigpipe);
    signal (SIGIO, sigio);
    signal (SIGURG, sigurg);
}


void
Count_message_number (Message * mp)
    // {}
    // PEäåθĿ롥ְ֤äƤ
    //  abort () ¹Ԥ롥
    // {}
{
    u_char src = mp->SockSrc ();
    u_long rcvno = Cominfo[src].One_message_received (mp);

    if (mp->MsgNo() != rcvno) {
	fprintf (stderr, "mp->msgno = %d, but request=%d\n",
		 mp->MsgNo (), rcvno);
	abort ();
    }
}

void
Report_message_number ()
    // {}
    //  PE äåθĿɽ롥
    // {}
{
    u_char     pe;
    for (pe = 0; pe < PAS_npe; pe++)
	Cominfo[pe].Report (pe);
}


/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */

