/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
#include "config.h"

#include <stdlib.h>
#include "aum/alloc.h"

#ifdef sequent
extern "C" {
    extern void *shsbrk(int);
    extern void *shmalloc(int);
    extern void	 shfree(void*);
};
#endif /* sequent */

void
Initialize_Memory ()
{
}

void*
pas_alloc (unsigned nbytes)
{
    return malloc (nbytes);
}

void
pas_free (void* addr, unsigned nbytes)
{
#ifndef NDEBUG
    int x = nbytes;
    for (char* p = addr; --x >= 0; *p++ = -1) ;
#endif

    free (addr);
}

////////////////////////////////////////////////////////////////////////

#ifdef sequent

void*
shared_alloc (unsigned nbytes)
{
    return shmalloc (nbytes);
}

void
shared_free (void* addr, unsigned nbytes)
{
#ifndef NDEBUG
    int x = nbytes;
    for (char* p = addr; --x >= 0; *p++ = -1) ;
#endif
    shfree (addr);
}

void*
private_alloc (unsigned nbytes)
{
    return malloc (nbytes);
}

void
private_free (void* addr, unsigned nbytes)
{
#ifndef NDEBUG
    int x = nbytes;
    for (char* p = addr; --x >= 0; *p++ = -1) ;
#endif
    free (addr);
}

#endif /* sequent */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
