/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include <stream.h>
#include "aum/fetch.h"
#include "aum/builtin.h"
#include "aum/msgobj.h"
#include "aum/j-c.h"
#include "aum/who.h"
#include "aum/string.h"
#include "builtin/extern.h"

static	Word
Iam (LocalMessage* (*make_message) (Word), Word x)
{
    Word    merger = new_Merger (1);
    doSend (merger, (*make_message) (x));
    return merger;
}

#ifdef nodef
static	Word
Weare (FPWord_Word make_messages, Word x)
{
    Word    merger = (*make_messages) (x);
    return merger;
}

static	Word
String_to_Messages (int nchars, Word x, Word (*getv) (Word, int))
{
    const ProtocolID length = PID_STRING_LENGTH;
    const ProtocolID contents = PID_STRING_CONTENTS;
    Message* lm = CreateMessage (length, Int2Fix (nchars));
    Word mj  = new_Merger (1);
    J_NC_ptr (mj)->Enqueue (lm);

    int rest;
    for (int i = 0; (rest = nchars - i) > 0; i += AUM_MAXARGS) {
	lm = new_LocalMessage (AUM_MAXARGS, contents);
	J_NC_ptr (mj)->Enqueue (lm);
	if (rest <= AUM_MAXARGS) {
	    for (int j = 0; j < rest; j++)
		lm->Argv (j, (*getv) (x, i + j));
	    for (;j < AUM_MAXARGS; j++)
		lm->Argv (j, PLUS_ATOM);
	    break;
	}
	for (int j = 0; j < AUM_MAXARGS; j++)
	    lm->Argv (j, (*getv) (x, i + j));
    }
    return mj;
}

Word
ASCII_String_Element (Word x, int index)
{
    return ASCII_StrObject_ptr (x)->Element (index);
}

static	Word
ASCII_String_to_Messages (Word x)
{
    assert (IsASCII_StrObject (x));
    int nchars = ASCII_StrObject_ptr (x)->no_of_chars ();
    return String_to_Messages (nchars, x, ASCII_String_Element);
}

Word
EUC_String_Element (Word x, int index)
{
    return EUC_StrObject_ptr (x)->Element (index);
}

static	Word
EUC_String_to_Messages (Word x)
{
    assert (IsEUC_StrObject (x));
    int nchars = EUC_StrObject_ptr (x)->no_of_chars ();
    return String_to_Messages (nchars, x, EUC_String_Element);
}
#endif /* nodef */

Word
doWho (Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS object
    // {} @ NOTATION X:who(Y)
    // {} @ MACRO Y = X ?
    // {} @ EXPLANATION
    // X ɽå Y 롥ϥ֥
    // åѴͣˡǤ롥X ȥߥå֥
    // Ȥξ硤ȥߥåå Y 롥
    //
    // X ʸ󡤥ꥹȡ󤽤ƥå֥Ȥξϥ
    // ݡȤƤʤ
    // {} @ METHOD END
{
    Word x = ax;
 retry:
    switch (Type_of (x)) {
    case AUm_Atom:
    case AUm_Fixnum:
	return Iam (CreateAtomicMessage, x);

    case AUm_Object:
	switch (Pointer (x)->oTag ()) {
	case CONNECTED:
	    x = J_C_ptr (x)->Destination ();
	    goto retry;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    return SendBuiltinMessage1 (x, PID_WHO);

#ifdef nodef
	case WC_ASCII_STR:
	case ASCII_STR:
	    return Weare (ASCII_String_to_Messages, x);

	case WC_EUC_STR:
	case EUC_STR:
	    return Weare (EUC_String_to_Messages, x);

	case DFLOAT:
	    return Iam (CreateAtomicMessage, ClassNameDFloat);

	case WC_MESSAGE_OBJ:
	case MESSAGE_OBJ:
	    return Iam (CreateAtomicMessage, ClassNameMessage);

	case WC_VECTOR:
	case VECTOR:
	    return Iam (CreateAtomicMessage, ClassNameVector);

	case WC_LISToo:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISTii:
	case LISToo:
	case LISTio:
	case LISToi:
	case LISTii:
	    return Iam (CreateAtomicMessage, ClassNameList);
#endif

	default:
	    break;
	}
	break;

    default:
	if (IsSFloat (x) || IsBool (x))
	    return Iam (CreateAtomicMessage, x);
	else {
	    const char* t_name = "unknown";
	    if (IsSink (x))
		t_name = "sink";
	    if (IsUndefOutlet (x))
		t_name = "undefined outlet";
	    if (IsUndefInlet (x))
		t_name = "undefined inlet";

	    error (form ("%s:who(Y)", print (x)),
		   CAN_NOT_FIND_METHOD,"who/-");

	    //warn (form ("%s :who(Y)", print (x)),
	    //"The message \"Who are you\" reached %s", print (x));

	    return SINKOBJ;
	}
    }
    error (form ("%s:who(Y)", print (x)),
	   CAN_NOT_FIND_METHOD,"who/-");
    //"Sorry, the message \":who/-\" reached %s, \n	  but it doesn't still support it", print (x));
    return SINKOBJ;
}

METHOD (who, R2_OP)
    // {}
    // who Ri,Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // Ri ï Rj Ȥ.
    // {}
{
    Fetch112 ();
    Word x = Reg[ip->b0];
    Reg[ip->b1] = doWho (x);
    doClose (x);
    JumpNextInstruction ();
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
