/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/word.h"
#include "aum/wait.h"
#include "aum/error.h"
#include "aum/object.h"
#include "aum/sideeffect.h"
#include "aum/string.h"
#include "aum/vector.h"
#include "aum/list.h"
#include "aum/msgobj.h"
#include "class/template.h"
#include "class/clink.h"

static const char NOT_LOADED[] = "Library \"wait.aao\" has not been loaded";

static ClassInfo*
wait_find_class (const char* name)
{
    ClassInfo* ci = Find_class_info (name);
    if (!ci)
	fatal (name, NOT_LOADED);
    return ci;
}

static Word
create_wait_instance (ClassInfo* waitclass, SideEffect* h)
{
    Word wait_object = Create_local_instance (waitclass);
    Object_ptr (wait_object)->Slot (0, ObjectWord (h));
    return wait_object;
}


////////////////////// VECTOR ///////////////////////////////////////////

Word
Create_wait_vector_index_object (VectorObject* v)
{
    static ClassInfo* wait_vector_index;

    if (!wait_vector_index)
	wait_vector_index = wait_find_class ("wait_vector_index");

    return create_wait_instance (wait_vector_index, v);
}


////////////////////// STRING ///////////////////////////////////////////

Word
Create_wait_string_index_object (StringObject* s)
{
    static ClassInfo* wait_string_index;

    if (!wait_string_index)
	wait_string_index = wait_find_class ("wait_string_index");

    return create_wait_instance (wait_string_index, s);
}


////////////////////// LIST ///////////////////////////////////////////

Word
Create_wait_list_index_object (ListObject* l)
{
    static ClassInfo* wait_list_index;

    if (!wait_list_index)
	wait_list_index = wait_find_class ("wait_list_index");

    return create_wait_instance (wait_list_index, l);
}


////////////////////// MESSAGE_OBJ ////////////////////////////////////

Word
Create_wait_message_index_object (MessageObject* m)
{
    static ClassInfo* wait_message_index;

    if (!wait_message_index)
	wait_message_index = wait_find_class ("wait_message_index");

    return create_wait_instance (wait_message_index, m);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
