/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "config.h"

#include <stdio.h>
#include <stream.h>
#include <stdarg.h>
#include "aum/error.h"
#include "aum/tstream.h"
#include "aum/alloc.h"

#define MAX_PAGES 8
class tstream*	TraceStream;

#if defined(__GNUG__) & __GNUG__ >= 2
int	    tstream::level;
tstreambuf* tstream::linktop;
int	    tstream::bfpages;
#endif

void
Initialize_TraceStream()
{
    if (!TraceStream)
	TraceStream = new tstream;
    TraceStream->Initialize();
}

#ifdef PAS_DEBUGGER
void End_TraceStream()
{
    TraceStream->Initialize();
    SHARED_FREE(TraceStream,sizeof(tstream));
    TraceStream = (tstream*)0;
}
#endif

class tstreambuf {
friend class tstream;
private:
    short	nbytes;
    short	size;
    tstreambuf* next;
    char	buf[1];
public:
    void	Initiate(int size);
    char*	Copy(const char*, int size);
};

void
tstreambuf::Initiate(int sz)
{
    nbytes = sz;
    size = sz - sizeof(class tstreambuf);
    next = 0;
}

char*
tstreambuf::Copy(const char* from, int sz)
{
    size -= sz;
    char* to = &buf[size];
    memcpy(to, from, sz);
    return to;
}

void tstream::Initialize()
{
    for (register tstreambuf* tb = linktop; tb != (tstreambuf*)0; ) {
	register tstreambuf* wp = tb;
	tb = tb->next;
	SHARED_FREE(wp, wp->nbytes);
    }
    level = 2;
    linktop = (tstreambuf*)0;
}

void  tstream::Link(tstreambuf* tb)
{
    tb->next = linktop;
    linktop = tb;
}

char* tstream::Result()
{
    static tstreambuf* curbuf;
#ifdef IOSTREAM_2_0
    char *bufptr = ostrstream::str ();
    int size = ostrstream::pcount ();
#else /* IOSTREAM_2_0 */
    char *bufptr = ostream::bufptr ();
    int size = bp->pptr - bp->base;
#endif /* IOSTREAM_2_0 */
    bufptr[size++] = '\0';

    if (curbuf == 0) {
	curbuf = (tstreambuf*)SHARED_ALLOC(BUFSIZ);
	curbuf->Initiate(BUFSIZ);
    }

    if (curbuf->size < size) {
	Link(curbuf);
	int buflen = size + sizeof(class tstreambuf);
	//buflen = (buflen > BUFSIZ) ? (buflen+BUFSIZ-1) & ~(BUFSIZ-1) : BUFSIZ;
	curbuf = (tstreambuf*)SHARED_ALLOC(buflen);
	curbuf->Initiate(buflen);
    }
    char *line = curbuf->Copy(bufptr, size);
    return line;
}

//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\

tstream::tstream (int sz)
    : PARENT_OSTREAM_CONSTRUCTOR (sz, (char*)0)
{
    bfpages = sz/BUFSIZ+1;
}

tstream::tstream (int sz, char* buf)
    : PARENT_OSTREAM_CONSTRUCTOR (sz, buf)
{
    bfpages = sz/BUFSIZ+1;
}

tstream::~tstream()
{
}

#ifndef IOSTREAM_2_0

tstream& tstream::operator << (const char* s)
{
    return tstream::put(s);
}

tstream& tstream::form(const char* fmt...)
{
    va_list args;
    va_start(args,fmt);
    char buf[BUFSIZ];
    vsprintf(buf,fmt,args);
    va_end(args);
    return tstream::put(buf);
}

tstream& tstream::put(const char* s)
{
    unsigned int slength = strlen(s)+1;
    *bp->pptr = '\0';
    char* source = bp->base;
    int current = (strlen(source)+1);
    int bfarea = (current+slength)/BUFSIZ+1;
    if (bfarea > MAX_PAGES){
	fatal ("trace stream",
		     "buffer overflow when putting string to buffer");
    }
    if ((bp->pptr+slength) > (bp->eptr)) {
	streambuf* wp = bp;
	char* ww = wp->base;
	bfpages = bfarea;
	unsigned int resize = bfarea*BUFSIZ;
	char* nb = new char[resize];
	bp = new streambuf(nb,resize);
	bp->setbuf(nb,resize);
	ownbuf = 1;
	bp->alloc = 1;
	state = _good;
	while(*(ww)){
	    *bp->pptr = *ww;
	    bp->pptr++;
	    ww++;
	}
	ww = (char*)s;
	while(*ww){
	    *bp->pptr = *ww;
	    bp->pptr++;
	    ww++;
	}
	*bp->pptr = '\0';
	if (ownbuf) {
	    delete wp;
	}
    } else {
	while(*s){
	    *bp->pptr = *s;
	    bp->pptr++;
	    s++;
	}
	*bp->pptr = '\0';
    }
    return *this;
}

#endif /* IOSTREAM_2_0 */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
