/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/stdlib.h"
#include "aum/bool.h"
#include "aum/code.h"
#include "aum/trace.h"
#include "aum/error.h"
#include "aum/global.h"
#include "aum/object.h"
#include "aum/message.h"
#include "aum/tstream.h"
#include "aum/parallel.h"
#include "aum/fetch.h"

extern const char *disasm (const Instruction *);

#ifdef PAS_DEBUGGER
int TraceStreamLevel = 2;
#else
static int TraceStreamLevel = 2;
#endif

void	PrintWord (Word);

TraceParameter *Trace;

void
Initialize_Trace ()
{
    if (!Trace)
	Trace = new TraceParameter;
    Trace->Initialize ();
}

void
TraceParameter::Initialize ()
{
    ResetAll ();
    // SetAll();
    // flag.create = 1;
    // flag.destroy = 1;
}

void
TraceParameter::SetAll ()
{
    mode = 0xFFFFFFFF;
    show = TRUE;
}

void
TraceParameter::ResetAll ()
{
    mode = 0;
    show = TRUE;
}

void
TraceParameter::Create (Name tag, Name object, Name option = Name (0))
{
    cout << " ";
    if (option) {
	cout.form ("NEW(\"%s\") ==> ^%s", option, object);
    }
    else {
	cout.form ("NEW(\"%s\") ==> ^%s", tag, object);
    }
    cout << ",\n";
    cout.flush ();
    TraceStream->Initialize ();
}

void
TraceParameter::Destroy (Name tag, Name object)
{
    cout.form (" DELETE %s(%s).\n", tag, object);
    cout.flush ();
    TraceStream->Initialize ();
}

void
TraceParameter::BeginSend (Name dest, Name msg)
{
    if (flag.send == FALSE)
	return;
    cout.form (" SEND(%s,%s) ==>", dest, msg);
    cout.flush ();
    TraceStream->Initialize ();
}

void
TraceParameter::EndSend (Name rest)
{
    if (flag.send == FALSE)
	return;
    cout.form (" ^%s,\n", rest);
    cout.flush ();
    TraceStream->Initialize ();
}

void
TraceParameter::BeginClose (Name dest)
{
    if (flag.close == FALSE)
	return;
    cout.form (" CLOSE(%s) ==>", dest);
    cout.flush ();
    TraceStream->Initialize ();
}

void
TraceParameter::EndClose (Name dest)
{
    if (flag.close == FALSE)
	return;
    cout.form (" %s", dest) << dotnl ();
    cout.flush ();
    TraceStream->Initialize ();
}

void
TraceParameter::Connect (Name src, Name dest)
{
    cout.form (" %s = ^%s", src, dest) << dotnl ();
    cout.flush ();
    TraceStream->Initialize ();
}

void
TraceParameter::Receive ()
{
}

void
TraceParameter::IsClosed ()
{
}

void
TraceParameter::Show (int i)
{
    if (show == FALSE)
	return;
    pelog ("R%d is %s", i, print (Reg[i]));
    TraceStream->Initialize ();
}

void
PrintInstruction (const Instruction * ip)
    // ݥ ip ؤ̿ɸϤ˽Ϥ롥
{
    TraceStream->Initialize ();
#ifdef PAS_DEBUGGER
    {
	extern void message_to_Listener(debugger_symbol,unsigned char*);
	char* msgs;
	if (CurrentMessage) {
	    tstream tout = tstream();
	    TraceStream->Level (TraceStreamLevel);
	    tout << CurrentMessage->Print ();
	    msgs = tout.Result ();
	    tout.Initialize();
	} else
	    msgs = (char*)":";
	tstream trout = tstream();
	trout.form("%02d:",PAS_self_peno);
	trout << CurrentObject->Printname()<<":"<< msgs
	    <<"	 "<< (char*)disasm (ip)<<"\n";
	if (Logfile)
	    pelog("%s:%s  %s",CurrentObject->Printname(),msgs,disasm(ip));
	message_to_Listener(TRECEIVE,(unsigned char*)trout.Result());
	trout.Initialize();
    }
#else
   {
	char	buf[BUFSIZ];
	tstream tout = tstream (BUFSIZ, buf);
	const char *msgs;

	if (CurrentMessage) {
	    TraceStream->Level (TraceStreamLevel);
	    tout << CurrentMessage->Print ();
	    msgs = tout.Result ();
	}
	else {
	    msgs = ":";
	}
	pelog ("%s:%s  %s", CurrentObject->Printname (), msgs, disasm (ip));
    }
#endif
    TraceStream->Initialize ();
}

void
mlog2 (const char *tag, Word x)
{
    pelog ("%s: %s", tag, printwq (x));
    TraceStream->Initialize ();
}

void
mlog3 (const char *tag, Word x, const class Message * mp)
{
    const char *object_name;
    if (IsUserObject (x))
	object_name = Object_ptr (x)->Printname ();
    else
	object_name = print (x);
    pelog ("%s: %s:%s", tag, object_name, mp->Print ());
    TraceStream->Initialize ();
}

void
mlog4 (const char *tag, const char *x, const char *a0, const char *a1)
{
    pelog ("%s: %s %s%s", tag, x, a0, a1);
    TraceStream->Initialize ();
}

void
mlog_mon (const char *op, Word y)
{
    pelog ("Cond: ( %s %s )?", op, print (y));
    TraceStream->Initialize ();
}

void
mlog_bin (Word x, const char *op, Word y)
{
    pelog ("Cond: ( %s %s %s )?", print (x), op, print (y));
    TraceStream->Initialize ();
}

void
log_stream (const char *tag, const char *ex, int index, const char *name)
{
    pelog ("%s stream: %s -> #%d<%d>  {%s}",
	   tag, ex, PAS_self_peno, index, name);
    TraceStream->Initialize ();
}

METHOD (trace, R1_OP)
    // {}
    // trace Ri;
    // {}
    // [	   address ]
    // [  Ri|	0|	  0]
    // {}
    // δؿϥǥХåѤ˺졤ȥ졼⡼ɤԤʤ
    // Ri = 0: off
    // Ri = 1: trace
    // Ri = 2: ptrace
    // Ri = 4: itrace
    // {}
{
    Fetch112 ();
    Word    x = Dereference (Reg[ip->b0]);
    if (IsFixnum (x)) {
	int	n = Fix2Int (x);
	if (n == 0) {
#ifdef ENABLE_INSTRUCTION_TRACE
	    TraceInstruction = FALSE;
#endif
	    PElog = 0;
	    TraceMessage = FALSE;
	}
	else {
	    if (n & 1)
		TraceMessage = TRUE;
	    if (n & 2)
		PElog = 1;
#ifdef ENABLE_INSTRUCTION_TRACE
	    if (n & 4)
		TraceInstruction = TRUE;
#endif
	}
    }
    else {
	//fatal (form ("trace %s", print (x)),
	//"BIT; 0:off, 1:trace, 2:ptrace, 4:itrace");
    }
    JumpNextInstruction ();
}


/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
