/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/object.h"
#include "aum/localmsg.h"

#ifdef PAS_DEBUGGER
#include <stdio.h>
#include <stream.h>
#endif

METHOD (send_self, RnVp_OP)
    // {}
    // send_self Vp,R0,R1, ..., Rn
    // {}
    // [	   address ]
    // [   0|	0|	 n ]
    // [		Vp ]
    // [  R0|  R1| ...	   ]
    // {}
    // {}
    // ץȥɣ Vp ĥåꡤʬȤ롥
    // ΰϡR0, R1, ..., Rn Ϳ롥ʬȤؤΥ
    // ϡإåƬǤĵ޹إåθ
    // 롥
    // {}
{
    Fetch12pid ();
#ifdef PAS_DEBUGGER
    extern void message_to_Listener (debugger_symbol, unsigned char *);
    char    tb[BUFSIZ];
#endif
    InstructionPointer += sizeof (*ip) / sizeof (Instruction);
    {
	LocalMessage *mp;
	if (ip->s0 == 0)
	    mp = new_AtomicMessage (ip->vp);
	else {
	    mp = new_LocalMessage (ip->s0, ip->vp);
	    SetMessageArgs (mp, ip->s0);
	}
	CurrentObject->Prepend (mp);
#ifdef PAS_DEBUGGER
	stop = (step && (!trace_switch));
	if (trace_switch || stop || CurrentObject->IsTraceObject ()) {
	    sprintf (tb, "%02d:%s:%s\n", PAS_self_peno,
		     CurrentObject->Printname (), mp->Printname ());
	    message_to_Listener (TRECEIVE, (unsigned char *) tb);
	}
	if (next_step) {
	    next_step = FALSE;
	}
	else {
	    if (stop) {
		BREAK_LOOP;
	    }
	}
#endif
    }
#ifdef PAS_DEBUGGER
    JumpNext ();
#else
    DO_TRACE_INSTRUCTION;
    JUMPNEXT;
#endif
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
