/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/appender.h"
#include "aum/execbmsg.h"
#include "aum/fetch.h"
#include "aum/global.h"
#include "aum/localmsg.h"
#include "aum/globlmsg.h"
#include "aum/merger.h"
#include "aum/object.h"
#include "aum/parallel.h"
#include "aum/send.h"
#include "aum/stdlib.h"
#include "aum/trace.h"

#ifdef PAS_DEBUGGER
#include "class/template.h"
#endif

void
doSend (Word dest, Message * msg)
    // {}
    // dest ɽ륪֥Ȥ뤤ϥ祤Ȥ˥å msg
    // 롥祤Ȥξ硤褬ޤäƤ dereference ơ
    // ΰ msg 롥
    //
    // @item ֥Ȥξ硧
    // ֥Ȥμ塼˥åɲä롥ޤ֥
    // ȤԤ(SLEEPING)ä硤塼ɽϿ¹
    // ֤ˤ롥
    //
    // @item 祤Ȥξ硧
    // ³褬ꤷƤʤСå򤽤³ž롥
    // ʾ dest Υ祤ȻȤѤʤȤơңä
    // 롥³褬̤ʤСå򥸥祤Ȥα
    // Ȥ˷Ҥ
    //
    // @item ͢줿֥Ȥޤϥ祤Ȥξ
    // ååѴơΣУŤ롥
    //
    // @item ȹ֥ȤӤ¾ξ硧
    // åľܼ¹Ԥ롥
    // {}
{
    if (Trace->doit ())
	Trace->BeginSend (print (dest), msg->Print ());
retry:
    switch (Type_of (dest)) {

    case AUm_Fixnum:
    case AUm_Atom:
    default:
execute_builtin_message:
	switch (msg->mTag ()) {
	case Msg_Shared_Args:
	    msg = ((GlobalMessage *) msg)->mut2_local ();
	    /* no break */
	case Msg_Atomic:
	case Msg_Private_Args:
	    ExecuteBuiltinMessage (dest, msg);
	    break;

	case Msg_WhereAreYou:
	    if (TraceMessage)
		mlog3 ("Exec", dest, msg);
	    break;

	default:
	    if (TraceMessage)
		mlog3 ("Exec", dest, msg);
	    fatal ("Execute", "Unknown message %s", msg->Print ());
	}
	break;

    case AUm_Object:
	switch (Pointer (dest)->Type ()) {
	case MJ_C:
	    dest = MJ_C_ptr (dest)->Destination ();
	    goto retry;

	case MJ_Mut:
	    dest = MJ_Mut_ptr (dest)->Destination ();
	    goto retry;

	case AJ_C:
	    if (msg->mTag () == Msg_WhereAreYou) {
		Answer_where_are_you ((GlobalMessage *) msg, AJ_C_ptr (dest));
		break;
	    }
	    else {
		dest = AJ_C_ptr (dest)->Destination ();
		goto retry;
	    }

	case ASCII_STR:
	case DFLOAT:
	case EUC_STR:
	case FILE_STREAM:
	case LISTii:
	case LISTio:
	case LISToi:
	case LISToo:
	case MESSAGE_OBJ:
	case VECTOR:
	case WC_ASCII_STR:
	case WC_EUC_STR:
	case WC_LISTii:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISToo:
	case WC_VECTOR:
	    goto execute_builtin_message;

	case MJ_NC:
	case MJ_W:
	    MJ_NC_ptr (dest)->AppendMessage (msg);
	    if (TraceMessage)
		mlog2 ("Hold", dest);
	    break;

	case AJ_NC:
	    if (msg->mTag () == Msg_WhereAreYou) {
		Answer_where_are_you ((GlobalMessage *) msg, AJ_C_ptr (dest));
		break;
	    }
	    else {
		AJ_NC_ptr (dest)->AppendMessage (msg);
		if (TraceMessage)
		    mlog2 ("Hold", dest);
	    }
	    break;

	case READY:
	case SUSPENDED:
	    Object_ptr (dest)->AppendMessage (msg);
	    if (TraceMessage)
		mlog2 ("Recv", dest);
	    break;

	case SLEEPING:
	    Object_ptr (dest)->AppendMessage (msg);
	    Object_ptr (dest)->Scheduling ();
	    if (TraceMessage)
		mlog2 ("Recv", dest);
	    break;

	case ERROR:
	    ExecuteBuiltinMessage (ERROROBJECT, msg);
	    break;

	case SINK:
	    ExecuteBuiltinMessage (SINKOBJ, msg);
	    break;

	case IMP_OBJ_NT:
	    MJ_IMP_OBJ_NT_ptr (dest)->mut2_IMP_OBJ ();
	    /* no break */

	case IMP_OBJ:
	    MJ_IMP_OBJ_ptr (dest)->Send (msg);
	    break;

	case IMP_OUTLET:
	    MJ_IMP_OUTLET_ptr (dest)->Send (msg);
	    break;

	default:
	    fatal (form ("Send \"%s\" to \"%s\"",msg->Print (),print (dest)),
		   "Destination is unknown object type");
	    abort ();
	}
	break;
    }
    if (Trace->doit ())
	Trace->EndSend (print (dest));
}

#ifdef PAS_DEBUGGER
#include "aum/tstream.h"
#endif

METHOD (send, RoVp_OP)
    // {}
    // send Ri,Vp,R0,R1,...,Rn
    // {}
    // [	   address ]
    // [  Ri|	0|	 n ]
    // [		Vp ]
    // [  R0|  R1| ...	   ]
    // {}
    // ץȥɣ Vp ĥå롥åΰϡ
    // R0, R1, ..., Rn Ϳ롥ǽ襪֥Ȥ뤤Ϥ
    // ˸¤ʤ᤯Υ祤Ȥޤǥåã.
    // {}
{
    Fetch12pid ();

#if 1
    if (PAS_message_may_be_received) {
#ifdef PAS_DEBUGGER
	if (global_message_queue)
	    Receive_SystemMessage(global_message_queue);
	global_message_queue = (GlobalMessage*)0;
#endif
	GlobalMessage *message = PAS_receive_in_nonblocking ();
	if (message)
	    Receive_SystemMessage (message);
    }
#endif

    {
	LocalMessage *mp;

	InstructionPointer += sizeof (*ip) / sizeof (Instruction);
	if (ip->s0 == 0)
	    mp = new_AtomicMessage (ip->vp);
	else {
	    mp = new_LocalMessage (ip->s0, ip->vp);
	    SetMessageArgs (mp, ip->s0);
	}
#ifdef PAS_DEBUGGER
	extern void is_enter_break_loop_send(Word x,LocalMessage* mp);
	is_enter_break_loop_send(Reg[ip->b0],mp);
	if (next_step) {
	    next_step = FALSE;
	} else {
	    if (stop) {
		BREAK_LOOP;
	    }
	}
#endif
	doSend (Reg[ip->b0], mp);
    }
#ifdef PAS_DEBUGGER
    JumpNext();
#else
    DO_TRACE_INSTRUCTION;
    JUMPNEXT;
#endif
}



// //////////////////////////////////////////////////////////////////////
// //////////////////////////////////////////////////////////////////////
// //////////////////////////////////////////////////////////////////////
void
Sendm_noarg (Word dest, ProtocolID pid)
    // {}
    // ʤΥåơdest 롥
    // {}
{
    LocalMessage *lm = new_AtomicMessage (pid);

    doSend (dest, lm);
}

void
Sendm_1arg (Word dest, ProtocolID pid, Word x)
    // {}
    //  x ĥåơdest 롥
    // {}
{
    LocalMessage *lm = new_LocalMessage (1, pid);

    lm->Argv (0, x);

    doSend (dest, lm);
}

void
Sendm_2args (Word dest, ProtocolID pid, Word x, Word y)
    // {}
    //  x, y ĥåơdest 롥
    // {}
{
    LocalMessage *lm = new_LocalMessage (2, pid);

    lm->Argv (0, x);
    lm->Argv (1, y);

    doSend (dest, lm);
}

void
Sendm_3args (Word dest, ProtocolID pid, Word x, Word y, Word z)
    // {}
    //  x, y, z ĥåơdest 롥
    // {}
{
    LocalMessage *lm = new_LocalMessage (3, pid);

    lm->Argv (0, x);
    lm->Argv (1, y);
    lm->Argv (2, z);

    doSend (dest, lm);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
