/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stdio.h>
#include <stream.h>
#include <assert.h>
#include "config.h"
#include "aum/error.h"
#include "aum/scheduler.h"

class Scheduler ScheduleTable;

#ifdef PAS_DEBUGGER
#include "aum/debugger.h"
#include "aum/tstream.h"
extern void message_to_Listener(debugger_symbol,unsigned char*);
extern void message_to_Listener(debugger_symbol);
char tb[BUFSIZ];
#endif

void
Scheduler::Initialize()
    // {}
    // 塼롥
    // {}
{
    for (int i = 0; i < MAX_PRIORITY; i++)
	queue[i].Initialize();
}

Object*
Scheduler::ActiveObject()
    // {}
    // 塼롦ơ֥뤫鸽ߤΥץ饤ƥĥ֥
    // ȤļФ֤ 塼롦ơ֥˺ܤäƤ
    // 륪֥Ȥ̵ϡNULLݥ󥿤֤
    // {}
{
    return queue[active].PopObject(active);
}

void
Scheduler::Register(Object* object)
    // {}
    // ߤͥ٤ɽ֥ȥ塼˥֥Ȥ롥
    // ֤ϥ֥ȥ塼ƬǤ롥
    // {}
{
    queue[active].PushObject(object);
}

void
Scheduler::AppendObject(Object* object)
    // {}
    // ֥Ȥλͥ٤б륪֥ȥ塼˥֥
    // Ȥ롥֤ϥ֥ȥ塼Ǥ롥
    // {}
{
    Priority p = object->Priority();
    queue[p].AppendObject(object);
}


Boolean
Scheduler::PriorityControl()
    // {}
    // ֹ⤤ͥ٤ĥ֥ȥ塼õĤп
    // Ǥʤе֤
    // {}
{
    register int p = MAX_PRIORITY;
    while (--p >= 0) {
	if (queue[p].IsEmpty() == FALSE) {
	    active = Priority(p);
	    max = Priority(p);
	    return TRUE;
	}
    }
    return FALSE;
}

void
Scheduler::CurrentPriority(const Priority p)
    // {}
    // ߤͥ٤ p ˤ롥⤷p ߤͥ٤⤱С
    // max ͤѹ롥
    // {}
{
    assert (p < MAX_PRIORITY);
    active = p;
    if (max < active)
	max = active;
}

void
Scheduler::Dump(int indent = 0)
    // {}
    // ǥХåѴؿ
    // {}
{
    for (register int p = MAX_PRIORITY-1; p >= 0; --p) {
	if (queue[p].IsEmpty() == TRUE)
	    continue;
	cout << tabs(indent) << form("Priority[%d]", p) << nl();
	queue[p].Dump(indent+DUMPINDENT);
    }
}

void
ScheduleLink::Dump(int indent = 0)
    // {}
    // ǥХåѴؿ
    // {}
{
#ifdef PAS_DEBUGGER
    sprintf(tb,"%s first = %#x, last = %#x \n",tabs(indent),(long)(first),(long)(last));
    message_to_Listener(TRECEIVE,(unsigned char*)tb);
    indent += DUMPINDENT;
    if (first != ObjectP(0)) {
	cout << tabs(indent);
	sprintf(tb,"%s",tabs(indent));
	message_to_Listener(TRECEIVE,(unsigned char*)tb);
	first->Dump(indent);
    }
#else
    cout << tabs(indent) <<
	form("first = %#x, last = %#x", long(first), long(last)) << nl();

    indent += DUMPINDENT;
    if (first != ObjectP(0)) {
	cout << tabs(indent);
	first->Dump(indent);
	cout << dotnl();
    }
#endif
}

void
DumpScheduleTable()
{
#ifdef PAS_DEBUGGER
    message_to_Listener(TRECEIVE,(unsigned char*)"\n************ Dump Schedule Table ************\n");
    ScheduleTable.Dump(0);
    message_to_Listener(NRECEIVE);
#else
    cout << "\n************ Dump Schedule Table ************\n";
    ScheduleTable.Dump(0);
#endif
}

#ifdef PAS_DEBUGGER

Boolean ScheduleLink::Search_object_queue(Object* o)
{
    for(Object* count = first;count!=last;count = count->SchedulerNext()){
	if (count == o)return TRUE;
    }
    if (count == o)return TRUE;
    return FALSE;
}

void ScheduleLink::Dump_object_queue(int level = 0)
{
    tstream tout = tstream();
    for(Object* count = first;count;count = count->SchedulerNext()){
	tout <<"   "<<count->Print() << "\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
    }
}

Boolean ScheduleLink::NoWhere()
    // {}
    // 塼Τͥ٤˥֥Ȥп򤽤Ǥʤ
    // е֤
    // {}
{
    if (first)
	return TRUE;
    return FALSE;
}

Boolean
Scheduler::NoWhere()
{
    //Dump_wait_object();
    register int p = MAX_PRIORITY;
    while (--p >= 0) {
	if (queue[p].NoWhere()) {
	    return FALSE;
	}
    }
    return TRUE;
}
ScheduleLink*
Scheduler::object_queue(int pri = 0)
{
    return queue+pri;
}
void
Scheduler::Dump_wait_object(int level = 0)
{
    for (int sclink = 0;sclink < MAX_PRIORITY;sclink++){
	(queue+sclink)->Dump_object_queue(level);
    }
}
#endif

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
