/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/stdlib.h"
#include "aum/aumtype.h"
#include "aum/object.h"
#include "aum/builtin.h"
#include "aum/vector.h"
#include "aum/msgobj.h"
#include "aum/fstream.h"
#include "aum/string.h"
#include "aum/list.h"
#include "aum/aj-nc.h"
#include "aum/aj-c.h"
#include "aum/tstream.h"
#include "aum/trace.h"
#include "aum/printstack.h"
#include "class/template.h"
#include "table/atomhash.h"

/* ʸǰϤफɤޤʸ򥪥ǽФ */
Boolean String_quote_p = TRUE;

Name	print (Word word);

static Boolean Print_message_queue_p;

static Name
print_fixnum (Word x)
{
    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    tout.form ("%d", Fix2Int (x));
    return tout.Result ();
}

static Name
print_sfloat (Word x)
{
    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    tout.form ("%g", Single2float (x));
    return tout.Result ();
}

static Name
print_object (Word x)
{
    switch (Object_ptr (x)->Type ()) {
    case MJ_C:
    case MJ_Mut:
	return MJ_C_ptr (x)->Print ();

    case AJ_C:
	return AJ_C_ptr (x)->Print ();

    case MJ_NC:
	return MJ_NC_ptr (x)->Print ();

    case MJ_W:
	return MJ_W_ptr (x)->Print ();

    case AJ_NC:
	return AJ_NC_ptr (x)->Print ();

    case IMP_OBJ:
	return MJ_IMP_OBJ_ptr (x)->Print ();

    case IMP_OBJ_NT:
	return MJ_IMP_OBJ_NT_ptr (x)->Print ();

    case IMP_INLET:
	return MJ_IMP_INLET_ptr (x)->Print ();

    case IMP_OUTLET:
	return MJ_IMP_OUTLET_ptr (x)->Print ();

    case READY:
    case SUSPENDED:
    case SLEEPING:
    case CLOSED:
	return Object_ptr (x)->Print ();
    case ERROR:
	return "*Error Object*";
    case SINK:
	return "*Sink Object*";
    case DFLOAT:
	return DFloatObject_ptr (x)->Print ();
    case CLASS_OBJ:
	return ClassObject_ptr (x)->Print ();
    case WC_MESSAGE_OBJ:
    case MESSAGE_OBJ:
	return MessageObject_ptr (x)->Print ();
    case FOREIGN_OBJ:
	return ForeignObject_ptr (x)->Print ();
    case WC_ASCII_STR:
    case ASCII_STR:
	return ASCII_StrObject_ptr (x)->Print ();
    case WC_EUC_STR:
    case EUC_STR:
	return EUC_StrObject_ptr (x)->Print ();
    case WC_VECTOR:
    case VECTOR:
	return VectorObject_ptr (x)->Print ();
    case WC_LISTii:
    case WC_LISTio:
    case WC_LISToi:
    case WC_LISToo:
    case LISToo:
    case LISToi:
    case LISTio:
    case LISTii:
	return ListObject_ptr (x)->Print ();
    case FILE_STREAM:
	return (Name) (FileStreamObject_ptr (x)->Print ());
    case GARBAGE:
	return "*GARBAGE*";
    case TRACE_INLET:
	return "CONNECTED";
    default:
	break;
    }
    return "*BUILTIN-ERROR*";
}

static Name
print_defaults (Word word)
{
    if (IsSFloat (word))
	return print_sfloat (word);

    if (IsBool (word)) {
	if (IsTrue (word))
	    return "`true";
	if (IsFalse (word))
	    return "`false";
	return "*BOOLEAN-ERROR*";
    }

    if (IsSink (word)) {
	return "$sink";
    }

    if (IsUndefOutlet (word))
	return "![No initialized]";

    if (IsUndefInlet (word))
	return "@[No initialized]";

    if (IsErrorObject (word))
	return "*Error Object*";

    if (IsEncodedDoubleFloat (word))
	return "encoded double float";

    if (IsEncodedASCIIString (word))
	return "encoded ascii string";

    if (IsEncodedEUCString (word))
	return "encoded jis string";

    return "*PRINT ERROR*";
}

static Name
subprint (Word word)
{
    PrintStack.push (word);
    Name    ans;
    switch (Type_of (word)) {
    case AUm_Fixnum:
	ans = print_fixnum (word);
	break;
    case AUm_Atom:
	ans = AtomPrintname (word);
	break;
    case AUm_Object:
	ans = print_object (word);
	break;
    default:
	ans = print_defaults (word);
	break;
    }
    PrintStack.pop ();
    return ans;
}

Name
print (Word word)
    // {}
    // ɤΰ᡼ʸˤ֤УͭǤ롥
    // {}
{
    Print_message_queue_p = FALSE;
    return subprint (word);
}

Name
printwq (Word word)
    // {}
    // ɤΰ᡼ʸˤ֤УͭǤ롥
    // ֥ȤΥå塼롥
    // {}
{
    Print_message_queue_p = TRUE;
    return subprint (word);
}

Name
print_by_private (Word x)
    // {}
    // ɤΰ᡼ʸˤ֤УͭǤ롥
    // {}
{
    return print (x);
}

Name
print_by_shared (Word x)
    // {}
    // ɤΰ᡼ʸˤ֤УųͭǤ롥
    // {}
{
    switch (Type_of (x)) {
    case AUm_Fixnum:
	return print_fixnum (x);

    case AUm_Atom:
	return AtomPrintname (x);

    case AUm_Object:
	GlobalID gid = x;
	return gid.Print ();

    default:
	return print_defaults (x);
    }
}

void
PrintWord (Word word)
{
    cout << print (word);
    cout.flush ();
}

void
dump (Word word)
{
    switch (Type_of (word)) {
    case AUm_Object:
	Object_ptr (word)->Dump ();
	break;
    default:
	cout << print (word);
	break;
    }
    cout.flush ();
}

// //////////////////////////////////////////////////////////////////////
// ////////////////////////////	 MessageLink ////////////////////////////
// //////////////////////////////////////////////////////////////////////

Name
MessageLink::PrintQueue ()
const
    // {}
    // ǥХåѴؿå塼Ƥʸˤ֤
    // {}
{
    if (Print_message_queue_p == FALSE)
	return "";
    if (PrintStack.isloop (ObjectWord (this)))
	return next ? ":..." : "";

    PrintStack.push (ObjectWord (this));
    Name    string = (next) ? ((Message *) next)->printLink () : "";
    PrintStack.pop ();
    return string;
}

// //////////////////////////////////////////////////////////////////////
// ////////////////////////////	 Obejct	 ////////////////////////////////
// //////////////////////////////////////////////////////////////////////

Name
Object::Printname ()
    // {}
    // ǥХåѴؿ饹̾øʸȤ֤
    // {}
{
    char    tem[128];
    tstream tout = tstream (128, tem);
    if (ShowRC) {
	u_short rc = LRC ();
	tout.form ("%d", rc);
    }
    tout.form ("%s_%x", classtmpl->Printname (), this);
    return tout.Result ();
}

Name
Object::Print ()
    // {}
    // ǥХåѴؿ֥Ȥ̾ӥå塼ΰ
    // ᡼ʸȤ֤
    // {}
{
    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    tout << Printname () << PrintQueue ();
    return tout.Result ();
}


const char *
Object::printStatus ()
{
    switch (Type ()) {
    case READY:
	return "READY";
    case SUSPENDED:
	return "SUSPENDED";
    case SLEEPING:
	return "SLEEPING";
    case CLOSED:
	return "CLOSED";
    case ERROR:
	return "ERROR";
    case SINK:
	return "SINK";
    default:
	return "????";
    }
}

void
Object::Dump (int indent = 0)
    // {}
    // ǥХåѴؿ
    // {}
{
    cout << printStatus ();
    cout.form ("<%s>", Printname ());
    switch (Type ()) {
    case READY:
    case SUSPENDED:
	if (!Empty ()) {
	    cout << "=";
	    SchedulerNext ()->Dump (indent);
	}
	break;

    default:
	break;
    }
}

// //////////////////////////////////////////////////////////////////////
// ////////////////////////////	 AJ_NC_t ////////////////////////////////
// //////////////////////////////////////////////////////////////////////

Name
AJ_NC_t::Printname ()
    // {}
    // ǥХåѴؿڥΰ̾ʸȤ֤
    // {}
{
    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    if (ShowRC)
	tout.form ("%d", h.lrc);
    tout.form ("AJ%x", this);
    return tout.Result ();
}

Name
AJ_NC_t::Print ()
    // {}
    // ǥХåѴؿڥ̾¤Ӥ˥ڥ˷ҤäƤ
    // 奦ƤʸȤ֤
    // {}
{
    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    tout << Printname () << PrintQueue () << "+";
    switch (next_joint->oTag ()) {
    case AJ_NC:
	tout << Next_ajoint ()->Print ();
	break;
    case MJ_NC:
	tout << Next_mjoint ()->Print ();
	break;
    default:
	tout << "*ERROR*";
    }
    return tout.Result ();
}

// //////////////////////////////////////////////////////////////////////
// ////////////////////////////	 AJ_C_t /////////////////////////////////
// //////////////////////////////////////////////////////////////////////

Name
AJ_C_t::Print ()
    // {}
    // ǥХåѴؿڥ̾¤Ӥ˥ڥ˷ҤäƤ
    // 奦ƤʸȤ֤
    // {}
{
    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    if (ShowRC)
	tout.form ("%d", h.lrc);
    tout.form ("AJ%x(%s)+%s", this,
	       print (Destination ()),
	       print (ObjectWord (next_joint)));
    return tout.Result ();
}

// //////////////////////////////////////////////////////////////////////
// ////////////////////////////	 MJ_NC_t ////////////////////////////////
// //////////////////////////////////////////////////////////////////////

Name
MJ_NC_t::Printname ()
    // {}
    // ǥХåѴؿ祤ȥޡΰ̾ʸȤ֤
    // {}
{
    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    if (ShowRC)
	tout.form ("%d", h.lrc);
    tout.form ("MJ%x", this);
    return tout.Result ();
}

Name
MJ_NC_t::Print ()
    // {}
    // ǥХåѴؿޡ̾¤Ӥ˥ޡ˷ҤäƤ
    // 奦ƤʸȤ֤
    // {}
{
    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    tout << Printname () << PrintQueue ();
    return tout.Result ();
}


void
MJ_NC_t::Dump (int indent = 0)
    // {}
    // ǥХåѴؿ
    // {}
{
    cout << form ("MJ_NC[%s]\n", Printname ());
    cout << "  Queue	   = ";
    PrintQueue ();
    cout << dotnl ();
    cout.flush ();
}

// //////////////////////////////////////////////////////////////////////
// ////////////////////////////	 MJ_W_t /////////////////////////////////
// //////////////////////////////////////////////////////////////////////

Name
MJ_W_t::Print ()
    // {}
    // ǥХåѴؿޡ̾¤Ӥ˥ޡ˷ҤäƤ
    // 奦ƤʸȤ֤
    // {}
{
    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    if (ShowRC)
	tout.form ("%d", h.lrc);
    tout.form ("MJ_W%x", this);
    if (MessageExist ())
	tout << First ()->printLink ();
    return tout.Result ();
}

// //////////////////////////////////////////////////////////////////////
// ////////////////////////////	 MJ_C_t /////////////////////////////////
// //////////////////////////////////////////////////////////////////////

Name
MJ_C_t::Print ()
    // {}
    // ǥХåѴؿޡ̾¤Ӥ˥ޡ˷ҤäƤ
    // 奦ƤʸȤ֤
    // {}
{
    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    if (ShowRC)
	tout.form ("%d(", h.lrc);
    tout << print (Destination ());
    if (ShowRC)
	tout << ")";
    return tout.Result ();
}

// //////////////////////////////////////////////////////////////////////
// ////////////////////////////	 MJ_IMP_t ///////////////////////////////
// //////////////////////////////////////////////////////////////////////

Name
MJ_IMP_t::Print ()
{
    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    if (ShowRC)
	tout.form ("%d_%x", h.lrc, this);
    switch (oTag ()) {
    case IMP_OBJ:
	tout.form ("%%obj#%d[%d]", gid.PE (), gid.Index ());
	break;
    case IMP_OBJ_NT:
	tout.form ("%%obj-nt#%d[%d]", gid.PE (), gid.Index ());
	break;
    case IMP_INLET:
	tout.form ("%%inlet#%d[%d]", gid.PE (), gid.Index ());
	break;
    case IMP_OUTLET:
	tout.form ("%%outlet#%d[%d]", gid.PE (), gid.Index ());
	break;
    default:
	abort ();
    }
    if (ShowRC)
	tout.form ("*%d", gid.WRC ());
    return tout.Result ();
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

Name
name_of_object_type (Word ax)
{
    Word x = Dereference (ax);
    switch (Type_of (x)) {
    case AUm_Fixnum:
	return "integer";
    case AUm_Atom:
	return "symbol";
    case AUm_Object:
	return name_of_object_tag (Object_ptr (x)->Type ());
    default:
	if (IsSFloat (x))
	    return "single float";
	if (IsBool (x)) {
	    if (IsTrue (x))
		return "`true";
	    else
		return "`false";
	}
	if (IsSink (x)) {
	    return "$sink";
	}
    }
    return "ERROR";
}

Name
name_of_object_tag (ObjectTag t)
{
    switch (t) {
    case MJ_NC:
    case MJ_W:
    case AJ_NC:
	return "JOINT";
    case IMP_OBJ:
    case IMP_OBJ_NT:
    case IMP_OUTLET:
	return "IMPORTED";
    case READY:
    case SUSPENDED:
    case SLEEPING:
    case CLOSED:
    case ERROR:
	return "user";
    case SINK:
	return "sync";
    case DFLOAT:
	return "double float";
    case WC_MESSAGE_OBJ:
    case MESSAGE_OBJ:
	return "message";
    case FOREIGN_OBJ:
	return "foreign";
    case WC_ASCII_STR:
    case ASCII_STR:
    case WC_EUC_STR:
    case EUC_STR:
	return "string";
    case WC_VECTOR:
    case VECTOR:
	return "vector";
    case WC_LISTii:
    case WC_LISTio:
    case WC_LISToi:
    case WC_LISToo:
    case LISToo:
    case LISToi:
    case LISTio:
    case LISTii:
	return "cons";
    case FILE_STREAM:
	return "file stream";
    default:
	break;
    }
    return "ERROR";
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
