/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/error.h"
#include "aum/alloc.h"
#include "aum/bool.h"
#include "aum/printstack.h"

PrintStackClass PrintStack;

void
PrintStackClass::Initialize (int size, int max)
{
    sp = 0;
    length = size;
    limit = max;
    stack = (Word*) SHARED_ALLOC (size * sizeof (Word));
}

void
PrintStackClass::push (Word x)
{
    if (sp == length) {
	fatal ("PrintStack.push", "loop checking stack overflow");
    }
    stack[sp++] = x;
}

void
PrintStackClass::pop ()
{
    --sp;
}

Boolean
PrintStackClass::isloop (Word x)
{
    if (sp > limit) {
	int times = 0;
	for (int n = 0; n < sp; n++) {
	    if (stack[n] == x)
		if (++times > 1)
		    return TRUE;
	}
    }
    return FALSE;
}

#ifdef PAS_DEBUGGER
void PrintStackClass::Free()
{
    SHARED_FREE((void*)stack,length*sizeof(Word));
}
#endif

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
