/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include <stdio.h>
#include "aum/stdlib.h"
#include "aum/fetch.h"
#include "aum/split.h"
#include "aum/trace.h"
#include "aum/object.h"
#include "class/template.h"

#ifdef PAS_DEBUGGER
#include "aum/global.h"
#include "aum/tstream.h"
extern int outletslotindex (const ClassTmpl * ctmp, unsigned char *str, Boolean = TRUE);
extern void message_to_Listener (debugger_symbol, unsigned char *);
extern void is_enter_break_loop_getoutlet(Word x,int index,short lab);
extern void is_enter_break_loop_setoutlet(Word x,int index,short lab);
#endif

static const char GET_OUTLET[] = "get_outlet";
// static const char SET_OUTLET[] = "set_outlet";

static void mlog_get_outlet (const char *, u_short slotno, Word);
static void mlog_set_outlet (const char *, u_short slotno, Word);

// {}
// get_outlet Ri, Vn;
// {}
// [	       address ]
// [  Ri|   0|	     Vn]
// {}
METHOD (get_outlet, R1X1_OP)
    // {}
    // ȡ֥ȤνüåȤ򥯥饹⥪եåȤˤ
    // 껲Ȥüʬ.
    // {}
{
    Fetch112 ();
    Word    x = OutletSlotBase[ip->s0];
#ifdef PAS_DEBUGGER
    Word*    xadd = OutletSlotBase+(ip->s0);
    ClassTmpl* ctmpl = CurrentObject->ClassTemplate ();
    int	    index = outletslotindex (ctmpl, (unsigned char *)(CurrentClass->OutletSlotName ((int) ip->s0)));
    Boolean is_this = (xadd == (CurrentObject->Slot_address(index+ctmpl->no_of_all_inlets()))) ? TRUE:FALSE;
#endif
    if (x != UNDEFOUTLET) {
#ifndef NDEBUG
	if (IsObject (x))
	    assert (Pointer (x)->LRC () > 0);
#endif
#ifdef PAS_DEBUGGER
	if ((index >= 0)&&is_this) {
	    index += ctmpl->no_of_all_inlets ();
	    is_enter_break_loop_getoutlet(x,index,ip->s0);
	}
	if (next_step) {
	    next_step = FALSE;
	}
	else {
	    if (stop) {
		BREAK_LOOP;
	    }
	}
#endif
	doSplit (x);
	Reg[ip->b0] = x;
	if (TraceMessage)
	    mlog_get_outlet ("Gets", ip->s0, x);
	JumpNextInstruction ();
    }
    error (GET_OUTLET, "Outlet slot \"%s\" is not initialized",
	   CurrentClass->OutletSlotName (ip->s0));
}


// {}
// set_outlet Ri, Vn;
// {}
// [	       address ]
// [  Ri|   0|	     Vn]
// {}
METHOD (set_outlet, R1X1_OP)
    // {}
    // ȡ֥ȤνüåȤ򥯥饹⥪եåȤˤ
    // 롥üĺ, Ri 򿷥åȤȤ.
    // {}
{
    Fetch112 ();
    {
	Word	old = OutletSlotBase[ip->s0];
#ifdef PAS_DEBUGGER
	Word*	 oldadd = OutletSlotBase+(ip->s0);
	ClassTmpl* ctmpl = CurrentObject->ClassTemplate ();
	int	index = outletslotindex (ctmpl, (unsigned char *) (CurrentClass->OutletSlotName (ip->s0)));
	Boolean is_this = (oldadd == (CurrentObject->Slot_address(index+ctmpl->no_of_all_inlets()))) ? TRUE:FALSE;
	if ((index >= 0)&&is_this) {
	    index += ctmpl->no_of_all_inlets();
	    is_enter_break_loop_setoutlet(Reg[ip->b0],index,(short)(ip->s0));
	}
	if (next_step) {
	    next_step = FALSE;
	}
	else {
	    if (stop) {
		BREAK_LOOP;
	    }
	}
#endif
	if (IsObject (old))
	    doClose (old);
    }
    OutletSlotBase[ip->s0] = Reg[ip->b0];
#ifndef NDEBUG
    if (IsObject (Reg[ip->b0]))
	assert (Pointer (Reg[ip->b0])->LRC () > 0);
#endif
    if (TraceMessage)
	mlog_set_outlet ("Sets", ip->s0, Reg[ip->b0]);
    JumpNextInstruction ();
}


static void
mlog_get_outlet (const char *tag, u_short slotno, Word x)
{
    char    name[BUFSIZ];

    sprintf (name, "%s: !%s", CurrentObject->Printname (),
	     CurrentClass->OutletSlotName (slotno));
    mlog4 ("Gets", name, "=> ", print (x));
}

static void
mlog_set_outlet (const char *tag, u_short slotno, Word x)
{
    char    name[BUFSIZ];

    sprintf (name, "%s: !%s", CurrentObject->Printname (),
	     CurrentClass->OutletSlotName (slotno));
    mlog4 ("Sets", name, "<= ", print (x));
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
