/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "config.h"

#include <stream.h>
#include <ctype.h>

#include "aum/global.h"
#include "aum/bool.h"
#include "aum/word.h"
#include "aum/parallel.h"
#include "aum/error.h"
#include "aum/alloc.h"

////////////////////////////////////////////////////////////////////////

static Boolean
IsOption (const char *x)
{
    return (*x == '-' || *x == '+') ? TRUE : FALSE;
}

static void
usage ()
{
    cerr << "Usage: " << Programname << " [ options ] filename..." << nl ();
    cerr << "Options:" << nl ();
    cerr << " -help:	   Print out this message" << dotnl ();
    cerr << " -showrc:	   Show RC in print image" << dotnl ();
    cerr << " -trace:	   Enter trace mode" << dotnl ();
#ifdef ENABLE_INSTRUCTION_TRACE
    cerr << " -itrace:	   Enter instruction trace mode" << dotnl ();
#endif
    cerr << " -ptrace:	   Enter PE trace mode" << dotnl ();
    cerr << " -verbose:	   Enter verbose mode" << dotnl ();
#ifdef sequent
    cerr << " -Npe N	   Set number of PE to N" << dotnl ();
#endif
    cerr << " -Tname size: Change following table size," << nl ();
    cerr << "	    name = atom: atom table" << nl ();
    cerr << "	    name = protocol: protocol table" << nl ();
    cerr << "	    name = export: export table" << nl ();
    cerr << "	    name = import: import table" << nl ();
    cerr << "	    name = timeslice: time slice value" << nl ();
    cerr << " -Sxxxx	   Change scheduling strategy," << nl ();
    cerr << "	    xxxx = round-robin: round robin strategy" << nl ();
    cerr << " -Dxxxx	   debug switch on," << nl ();
    cerr << "	    xxxx = connect: connection debugging" << nl ();
#ifdef ALLOC_STATS
    cerr << " -statistics  report allocation statistics" << nl ();
#endif
    cerr << " -external	   always create object on external PE" << nl ();
    cerr << " -external-odd create object on external PE if counter is odd" << nl ();
    cerr << " -external-even create object on external PE if PE is even" << nl ();
    cerr << " -Wall	   print out warnning" << nl ();
    cerr << " -log file	   print out logging to file" << nl ();
    cerr << " -nlist	   loading nlist of pas. (foreign language interface)" << nl ();

    ExitStatus++;
    exit (ExitStatus);
}

static void
set_program_name (const char *filename)
{
    register const char *p;
    for (p = filename; *p; p++);
    while (*--p != '/' && filename < p);
    Programname = *p == '/' ? p + 1 : p;
}

static void
initialize_arguments (const int argc, const char *argv[])
{
    int	    i;

    Argc = 0;
    PasArgc = 0;
    for (i = 1; i < argc; i++) {
	if (argv[i][0] == '-') {
	    if (argv[i][1] == '-')
		break;
	}
	else {
	    PasArgc++;
	}
    }
    for (; i < argc; i++)
	Argc++;

    if (PasArgc == 0)
	usage ();

    PasArgv = (const char **) SHARED_ALLOC ((PasArgc + 1) * sizeof (char **));
    PasArgv[PasArgc] = NULL;

    Argv = (const char **) SHARED_ALLOC ((Argc + 1) * sizeof (char **));
    Argv[Argc] = NULL;
}

void
parse_options (const int argc, const char *argv[])
{
    register int n;

    set_program_name (argv[0]);
    initialize_arguments (argc, argv);

    PasArgc = 0;
    for (n = 1; n < argc; n++) {
	if (IsOption (argv[n])) {
	    const char	 *option = argv[n] + 1;
	    switch (*option) {
	    case '-':
		n++;
		goto parse_end;

	    case 'h':
		usage ();
		break;
	    case 'e':
		if (strcmp (option, "external") == 0)
		    Always_external_creation = TRUE;
		else if (strcmp (option, "external-odd") == 0)
		    Odd_external_creation = TRUE;
		else if (strcmp (option, "external-even") == 0)
		    Even_external_creation = TRUE;
		else
		    usage ();
		break;
	    case 'l':
		if (n + 1 < argc && strcmp (option, "log") == 0) {
		    n++;
		    Logfile = argv[n];
		    break;
		}
		usage ();
		break;
	    case 'n':
		if (strcmp (option, "nlist") == 0)
		    NameList_load_p = TRUE;
		else
		    usage ();
		break;
	    case 's':
		if (strcmp (option, "showrc") == 0)
		    ShowRC = TRUE;
		else if (strcmp (option, "statistics") == 0)
		    Statistics_flag = TRUE;
		else
		    usage ();
		break;
	    case 't':
		if (strcmp (option, "trace") == 0) {
		    TraceMessage = TRUE;
		}
		else
		    usage ();
		break;
	    case 'p':
		if (strcmp (option, "ptrace") == 0) {
		    PElog = 1;
		}
		else
		    usage ();
		break;
#ifdef ENABLE_INSTRUCTION_TRACE
	    case 'i':
		if (strcmp (option, "itrace") == 0) {
		    TraceInstruction = TRUE;
		}
		else
		    usage ();
		break;
#endif
	    case 'v':
		if (strcmp (option, "verbose") == 0)
		    Verbose = TRUE;
		else
		    usage ();
		break;

	    case 'D':
		if (strcmp (option + 1, "connect") == 0)
		    DebugConnect = TRUE;
		else
		    usage ();
		break;

	    case 'T':
		if (n + 1 < argc && isdigit (*argv[n + 1])) {
		    n++;
		    if (strcmp (option + 1, "atom") == 0) {
			Tatom = atoi (argv[n]);
			break;
		    }
		    if (strcmp (option + 1, "protocol") == 0) {
			Tprotocol = atoi (argv[n]);
			break;
		    }
		    if (strcmp (option + 1, "export") == 0) {
			Texport = atoi (argv[n]);
			break;
		    }
		    if (strcmp (option + 1, "import") == 0) {
			Timport = atoi (argv[n]);
			break;
		    }
		    if (strcmp (option + 1, "timeslice") == 0) {
			TimeSlice = atoi (argv[n]);
			break;
		    }
		}
		usage ();
		break;
#ifdef sequent
	    case 'N':
		if (n + 1 < argc && isdigit (*argv[n + 1])) {
		    if (strcmp (option + 1, "pe") == 0)
			PAS_npe = atoi (argv[n + 1]);
		    else
			usage ();
		    n++;
		}
		else
		    usage ();
		break;
#endif				/* sequent */
	    case 'S':
		if (n + 1 < argc) {
		    if (strcmp (option + 1, "round-robin") == 0)
			Scheduling_strategy = ROUND_ROBIN;
		    else
			usage ();
		}
		else
		    usage ();
		break;
	    case 'W':
		if (strcmp (option + 1, "all") == 0)
		    Warnning = 0xFFFFFFFF;
		else
		    usage ();
		break;

	    default:
		usage ();
		break;
	    }
	}
	else {
	    PasArgv[PasArgc++] = argv[n];
	}
    }
parse_end:
    Argc = 0;
    for (; n < argc; n++)
	Argv[Argc++] = argv[n];
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
