/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/stdlib.h"
#include "aum/error.h"
#include "aum/object.h"
#include "aum/mj-nc.h"
#include "aum/mj-imp.h"
#include "aum/aj-nc.h"
#include "aum/scheduler.h"
#include "aum/connect.h"
#include "aum/close.h"
#include "aum/trace.h"
#include "aum/alloc.h"
#include "aum/allocstats.h"
#include "aum/global.h"
#include "aum/parallel.h"
#include "table/export.h"
#include "class/template.h"
#include "class/clink.h"

// #define ALLOC_DEBUG 1

#ifdef ALLOC_DEBUG
#include <stream.h>
#endif

static const char OBJECT_[] = "Object";

Object *
new_Object (ClassTmpl * tmpl)
    // {}
    // 饹ƥץ졼 tmpl Ϳ륯饹Υ󥹥󥹥֥
    // Ȥ롥
    // {}
{
    if (tmpl->DefineOnly () == TRUE) {
	fatal ("create_instance",
	       "class \"#%s\" is not defined", tmpl->Printname ());
    }
    UPDATE_ALLOC_STATS (object_alloc);
    Object *op = (Object *) SHARED_ALLOC (tmpl->size_of_instance ());
    op->Initialize (tmpl);
#ifdef ALLOC_DEBUG
    pelog ("obj alloc %x", op);
#endif
    return op;
}

Object *
new_InstanceObject (int index)
    // {}
    // ClassInfoTable Υǥå饤󥹥󥹥֥Ȥ
    // ֤
    // {}
{
    if (index < 0 || index >= MAX_CLASSES)
	fatal ("new_Instance"," %d is too large index", index);
    ClassTmpl *tmpl = ClassInfoTable[index].ClassTemplate ();
    return new_Object (tmpl);
}

Word
CreateObject (ClassTmpl * tmpl, Priority p = 0)
    // {}
    // 饹ƥץ졼 tmpl Ϳ륯饹Υ󥹥󥹥֥
    // Ȥ롥ޤ֥ȤΥץ饤ƥ
    // p ꤹ롥
    // {}
{
    Object *op = new_Object (tmpl);
    op->Priority (p);
    if (Trace->doit ())
	Trace->Create (OBJECT_, op->Print (), tmpl->Print ());
    return ObjectWord (op);
}

void
Object::Free ()
    // {}
    // ֥Ȥ롥
    // {}
{
    if (Trace->doit ())
	Trace->Destroy (OBJECT_, Print ());
    UPDATE_ALLOC_STATS (object_free);
#ifdef ALLOC_DEBUG
    pelog ("obj free  %x", this);
#endif
    SHARED_FREE (this, classtmpl->size_of_instance ());
}

void
Object::Initialize (ClassTmpl * tmpl)
    // {}
    // ֥Ȥ롥
    // {}
{
    if (tmpl->DefineOnly () == TRUE)
	fatal ("create_instance",
	       "class \"#%s\" is not defined", tmpl->Printname ());

    MessageQueue::Initialize (SLEEPING, 1);
    classtmpl = tmpl;
    priority = 0;
    {
	int	ninlets = classtmpl->no_of_all_inlets ();
	int	nslots = classtmpl->no_of_all_outlets () + ninlets;
	int	n = 0;
	while (n < ninlets)
	    slot[n++] = UNDEFINLET;
	while (n < nslots)
	    slot[n++] = UNDEFOUTLET;
#ifdef PAS_DEBUGGER
	int  db = ((nslots+classtmpl->no_of_methods())*2)/(sizeof(Word))+1;
	while (n <= db) {
	    slot[n++] = 0;
	}
	debugg_bits = 0;
#endif
    }
}

void
Object::InitializeInlet (u_long i)
    // {}
    // ֥ȤüåȤ롥
    // {}
{
    slot[i] = UNDEFINLET;
}

void
Object::InitializeOutlet (u_long i)
    // {}
    // ֥ȤνüåȤ롥
    // {}
{
    slot[i] = UNDEFOUTLET;
}

void
Object::Set_slot_bases (short ibase, short obase)
    // {}
    // ƥåȥ١ꤹ롥
    // {}
{
    InletSlotBase = &slot[ibase];
    OutletSlotBase = &slot[classtmpl->no_of_all_inlets () + obase];
}

void
Object::TerminateSlots ()
    // {}
    // ֥ȤüåȤ򥨥顼˷ҤüåȤ
    // 롥
    // {}
{
    int	    ninlets = classtmpl->no_of_all_inlets ();
    int	    nslots = classtmpl->no_of_all_outlets () + ninlets;
    int	    n = 0;
    for (; n < ninlets; n++) {
	if (!IsUndefInlet (slot[n])) {
	    if (Warnning) {
		if (J_NC_ptr (slot[n])->MessageExist ()) {
		    warn ("Terminate",
			  "When object \"%s\" become extinct,\n\
message \"%s\" was left at inlet slot \"%s\".",
			  Printname (),
			  J_NC_ptr (slot[n])->First ()->Print (),
			  InletSlotName (n));
		}
	    }
	    Word    x = ERROROBJECT;
	    doConnect (x, J_NC_ptr (slot[n]));
	    slot[n] = UNDEFINLET;
	}
    }
    for (; n < nslots; n++) {
	if (!IsUndefOutlet (slot[n])) {
	    if (PElog)
		pelog ("Close slot: %s", print (slot[n]));
	    doClose (slot[n]);
	    slot[n] = UNDEFOUTLET;
	}
    }
}

Name
Object::InletSlotName (short n)
    const
    // {}
    // åֹ n ͿüåȤΰ֤̾
    // {}
{
    return classtmpl->InletSlotName (n);
}

Name
Object::OutletSlotName (short n)
    const
    // {}
    // åֹ n ͿüåȤΰ֤̾
    // {}
{
    return classtmpl->OutletSlotName (n);
}

Name
Object::ClassPrintname ()
    const
{
    return classtmpl->Printname ();
}

Word
Object::ClassName ()
    const
{
    return classtmpl->ClassName ();
}

Boolean
Object::IsClassDefined ()
    const
{
    return classtmpl->DefineOnly () ? FALSE : TRUE;
}

// //////////////////////////////////////////////////////////////////////
// ////////////////////////////	 Connect  ///////////////////////////////
// //////////////////////////////////////////////////////////////////////

void
Object::Connect (J_NC_t * head)
    // {}
    // 祤head ˤƤΥåʬˤĤʤľ³
    // ̡祤ȤλȲˤʤä餽ʬ
    // ȲʬȤ麹ߤˤʤʤХ祤
    // head Υå塼ˤ롥
    // {}
{
    switch (head->Type ()) {
 case MJ_NC:
	Join ((MJ_NC_t *) head);
	if (TraceMessage && head->MessageExist ())
	    mlog2 ("Recv", ObjectWord (this));
	if (head->LRC () == 1) {
	    ((MJ_NC_t *) head)->Free ();
	    h.lrc--;
	}
	else {
	    head->LRC ()--;
	    head->ResetMessageQueue ();
	    (void) ((MJ_NC_t *) head)->mut2_MJ_C (ObjectWord (this));
	}
	return;

    case AJ_NC:
	Join ((AJ_NC_t *) head);
	if (TraceMessage && head->MessageExist ())
	    mlog2 ("Recv", ObjectWord (this));
	if (head->LRC () == 1) {
	    Connect (((AJ_NC_t *) head)->Next_joint ());
	    ((AJ_NC_t *) head)->Free ();
	}
	else {
	    head->LRC ()--;
	    head->ResetMessageQueue ();
	    (void) ((AJ_NC_t *) head)->mut2_AJ_C (ObjectWord (this));
	}
	return;

    case IMP_INLET:
	Connect_with_IMP_INLET ((MJ_IMP_INLET_t *) head);
	return;

    case MJ_C:
    case AJ_C:
    case MJ_W:
    case IMP_OBJ:
    case IMP_OBJ_NT:
    case IMP_OUTLET:
	connect_arg_already_connected (ObjectWord (this), head);

    default:
	connect_arg_not_joint (ObjectWord (this), head);
    }
}

void
Object::Connect_with_IMP_INLET (MJ_IMP_INLET_t * head)
    // {}
    // ͢줿üȤ³ʤΤǡI_am_here ͢и롥
    // I_am_here ΰϼ֥Ȥ͢ɽϿϤȳ
    // ȲνͤǤ롥ޤhead λȲϣʤΤ³
    //  head ΰ롥η̤ȤƼʬȤλȲ
    // 롥ʬȤλȲ͢ɽϿƤʬ
    // 顤褷ƣˤϤʤʤ
    // {}
{
    assert (head->LRC () == 1);
    GlobalID gid = ExportTable->Register (this, WEIGHT);
    head->Return_I_am_here (gid, WEIGHT_of_IamHere);
    h.lrc--;
    assert (h.lrc != 0);
}

void
Object::Connect_and_Schedule (J_NC_t * head)
    // {}
    // 祤head ˤƤΥåʬˤĤʤľ³
    // ̡祤ȤλȲˤʤä餽ʬ
    // ȲʬȤ麹ߤˤʤʤХ祤
    // head Υå塼ˤ롥Ǹ˼ʬȤ򥹥塼
    // Ͽ롥
    // {}
{
    Connect (head);
    if (MessageExist ())
	Scheduling ();
}

void
Object::Scheduling ()
    // {}
    // ֥Ȥ򥹥塼Ͽ롥
    // {}
{
    ScheduleTable.AppendObject (this);
    doREADY ();
}

#ifdef PAS_DEBUGGER

Word   *
Object::Slot_address (u_long i)
{
    return (slot + i);
}

Boolean
Object::IsBreakObject ()
{
    return (debugg_bits & 0x01) ? TRUE : FALSE;
}

Boolean
Object::IsTraceObject ()
{
    return (debugg_bits & 0x02) ? TRUE : FALSE;
}

void
Object::SetBreakObject ()
{
    debugg_bits |= 0x01;
}

void
Object::SetTraceObject ()
{
    debugg_bits |= 0x02;
}

void
Object::UnSetBreakObject ()
{
    debugg_bits &= ~0x01;
}

void
Object::UnSetTraceObject ()
{
    debugg_bits &= ~0x02;
}

Boolean
Object::IsBreakObjectSlot (int pos = 0)
{
    int	    no_of_all_slots = classtmpl->no_of_all_slots ();
    if (pos >= no_of_all_slots)
	return FALSE;
    int	    rewrite_location = no_of_all_slots + (pos * 2) / (sizeof (Word) * 8);
    int	    bit_locate = (pos * 2) % (sizeof (Word) * 8);
    return (slot[rewrite_location] & (0x01 << bit_locate)) ? TRUE : FALSE;
}

Boolean
Object::IsTraceObjectSlot (int pos = 0)
{
    int	    no_of_all_slots = classtmpl->no_of_all_slots ();
    if (pos >= no_of_all_slots)
	return FALSE;
    int	    rewrite_location = no_of_all_slots + (pos * 2 + 1) / (sizeof (Word) * 8);
    int	    bit_locate = (pos * 2 + 1) % (sizeof (Word) * 8);
    return (slot[rewrite_location] & (0x01 << bit_locate)) ? TRUE : FALSE;
}

void
Object::SetBreakObjectSlot (int pos = 0)
{
    int	    no_of_all_slots = classtmpl->no_of_all_slots ();
    if (pos >= no_of_all_slots)
	return;
    int	    rewrite_location = no_of_all_slots + (pos * 2) / (sizeof (Word) * 8);
    int	    bit_locate = (pos * 2) % (sizeof (Word) * 8);
    slot[rewrite_location] |= (0x01 << bit_locate);
}

void
Object::SetTraceObjectSlot (int pos = 0)
{
    int	    no_of_all_slots = classtmpl->no_of_all_slots ();
    if (pos >= no_of_all_slots)
	return;
    int	    rewrite_location = no_of_all_slots + (pos * 2 + 1) / (sizeof (Word) * 8);
    int	    bit_locate = (pos * 2 + 1) % (sizeof (Word) * 8);
    slot[rewrite_location] |= (0x01 << bit_locate);
}

void
Object::UnSetBreakObjectSlot (int pos = 0)
{
    int	    no_of_all_slots = classtmpl->no_of_all_slots ();
    if (pos >= no_of_all_slots)
	return;
    int	    rewrite_location = no_of_all_slots + (pos * 2) / (sizeof (Word) * 8);
    int	    bit_locate = (pos * 2) % (sizeof (Word) * 8);
    slot[rewrite_location] &= ~(0x01 << bit_locate);
}

void
Object::UnSetTraceObjectSlot (int pos = 0)
{
    int	    no_of_all_slots = classtmpl->no_of_all_slots ();
    if (pos >= no_of_all_slots)
	return;
    int	    rewrite_location = no_of_all_slots + (pos * 2 + 1) / (sizeof (Word) * 8);
    int	    bit_locate = (pos * 2 + 1) % (sizeof (Word) * 8);
    slot[rewrite_location] &= ~(0x01 << bit_locate);
}

Boolean
Object::IsBreakObjectMethod (int pos = 0)
{
    int	    no_of_all_slots = classtmpl->no_of_all_slots ();
    int	    no_of_all_methods = classtmpl->no_of_methods ();
    if (pos >= no_of_all_methods)
	return FALSE;
    int	    rewrite_location = no_of_all_slots +
    ((pos + no_of_all_slots) * 2) / (sizeof (Word) * 8);
    int	    bit_locate = ((pos + no_of_all_slots) * 2) % (sizeof (Word) * 8);
    return (slot[rewrite_location] & (0x01 << bit_locate)) ? TRUE : FALSE;
}

Boolean
Object::IsTraceObjectMethod (int pos = 0)
{
    int	    no_of_all_slots = classtmpl->no_of_all_slots ();
    int	    no_of_all_methods = classtmpl->no_of_methods ();
    if (pos >= no_of_all_methods)
	return FALSE;
    int	    rewrite_location = no_of_all_slots +
    ((pos + no_of_all_slots) * 2 + 1) / (sizeof (Word) * 8);
    int	    bit_locate = ((pos + no_of_all_slots) * 2 + 1) % (sizeof (Word) * 8);
    return (slot[rewrite_location] & (0x01 << bit_locate)) ? TRUE : FALSE;
}

void
Object::SetBreakObjectMethod (int pos = 0)
{
    int	    no_of_all_slots = classtmpl->no_of_all_slots ();
    int	    no_of_all_methods = classtmpl->no_of_methods ();
    if (pos >= no_of_all_methods)
	return;
    int	    rewrite_location = no_of_all_slots +
    ((pos + no_of_all_slots) * 2) / (sizeof (Word) * 8);
    int	    bit_locate = ((pos + no_of_all_slots) * 2) % (sizeof (Word) * 8);
    slot[rewrite_location] |= (0x01 << bit_locate);
}

void
Object::SetTraceObjectMethod (int pos = 0)
{
    int	    no_of_all_slots = classtmpl->no_of_all_slots ();
    int	    no_of_all_methods = classtmpl->no_of_methods ();
    if (pos >= no_of_all_methods)
	return;
    int	    rewrite_location = no_of_all_slots +
    ((pos + no_of_all_slots) * 2 + 1) / (sizeof (Word) * 8);
    int	    bit_locate = ((pos + no_of_all_slots) * 2 + 1) % (sizeof (Word) * 8);
    slot[rewrite_location] |= (0x01 << bit_locate);
}

void
Object::UnSetBreakObjectMethod (int pos = 0)
{
    int	    no_of_all_slots = classtmpl->no_of_all_slots ();
    int	    no_of_all_methods = classtmpl->no_of_methods ();
    if (pos >= no_of_all_methods)
	return;
    int	    rewrite_location = no_of_all_slots +
    ((pos + no_of_all_slots) * 2) / (sizeof (Word) * 8);
    int	    bit_locate = ((no_of_all_slots + pos) * 2) % (sizeof (Word) * 8);
    slot[rewrite_location] &= ~(0x01 << bit_locate);
}

void
Object::UnSetTraceObjectMethod (int pos = 0)
{
    int	    no_of_all_slots = classtmpl->no_of_all_slots ();
    int	    no_of_all_methods = classtmpl->no_of_methods ();
    if (pos >= no_of_all_methods)
	return;
    int	    rewrite_location = no_of_all_slots +
    ((pos + no_of_all_slots) * 2 + 1) / (sizeof (Word) * 8);
    int	    bit_locate = ((no_of_all_slots + pos) * 2 + 1) % (sizeof (Word) * 8);
    slot[rewrite_location] &= ~(0x01 << bit_locate);
}

#endif				/* DEBUGER */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
