/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/mj-nc.h"
#include "aum/mj-c.h"
#include "aum/mj-imp.h"
#include "aum/globlmsg.h"
#include "table/import.h"

// ///////////////////////////////////////////////////////////////
// {}
// Merger joint Waited type
// {}

// mutation other type merger-joint
MJ_C_t* MJ_W_t::mut2_MJ_C(MJ_IMP_t* dest)
{
    ((J_C_t*)this)->Initialize(MJ_C, ObjectWord(dest));
    return (MJ_C_t*)this;
}

MJ_IMP_t* MJ_W_t::mut2_MJ_IMP(ObjectTag t, GlobalID g, int i)
{
    assert (i >= 0);
    tag = t;
    ((MJ_IMP_t*)this)->Reset(g, i);
    return (MJ_IMP_t*)this;
}

static void
reply_IamHere_GRC(const GlobalID& dest, GlobalMessage* gm, u_long grc)
    // {}
    // {}
{
    assert (grc != 0);
    assert (grc <= (1<<WEIGHT));
    const GlobalID reply = gm->Reply ();

    if (gm->PID () == PID_CTL_GM) {
	gm->mTag (Msg_IamHere_GRC);
	gm->set_CtlInfo (dest, grc);
	send_to_other_pe (reply, gm);
    }
    else {
	send_to_other_pe (reply, new_IamHere_GRC (dest, grc));
	if (gm->Arity () == 0)
	    gm->mTag (Msg_Atomic);
	else
	    gm->mTag (Msg_Shared_Args);
	send_to_other_pe (dest, gm);
    }
}

static MessageLink*
reply_wru(MessageLink* mp, int n, u_long grc, const GlobalID& dest)
    // {}
    // Ȳ grc  n Ĥʬ򤷡줾˱ IamHere 
    // 롥
    // {}
{
    assert (0 < n);
    int m = 0;
    if (grc < (u_long)n) {
	m = n - grc;
	n = grc;
    }
    for (;n > 0 && grc >= (u_long)n; n--) {
	int rest = grc / n;
	if (rest > (1<<WEIGHT))
	    rest = (1<<WEIGHT);
	grc -= rest;
	MessageLink* next = mp->nextMessage ();
	reply_IamHere_GRC (dest, (GlobalMessage*)mp, rest);
	mp = next;
    }
    n += m;
    while (--n >= 0) {
	MessageLink* next = mp->nextMessage ();
	send_to_other_pe (dest, (GlobalMessage*)mp);
	mp = next;
    }
    return mp;
}

void
MJ_W_t::Forward_and_Close(const GlobalID& dest, u_long grc)
    // {}
    // å塼Ƭ where_are_you åС
    // Ŀ GRC ʬ䤷IamHere å롥
    // where_are_you åĤʤСgrc ʬγȲ
    // ĺåȤ롥Ĥäåϳå
    // Ѵơdest ž롥ǸˡMJ_W ΰ롥
    // {}
{
    int n = 0;
    MessageLink* mp;
    for (mp = next; mp; mp = mp->nextMessage()) {
	if (mp->mTag() == Msg_WhereAreYou)
	    n++;
	else
	    break;
    }
    if (n != 0) {
	next = reply_wru (next, n, grc, dest);
	Forward_except_first_wrus (dest);
    }
    else {
	if (next) {
	    GlobalMessage* gm;
	    mp = next;
	    MessageLink* mp_next = mp->nextMessage ();
	    while (mp_next) {
		gm = ((Message*) mp)->mut2_global_message ();
		send_to_other_pe (dest, gm);
		mp = mp_next, mp_next = mp->nextMessage ();
	    }
	    switch (mp->mTag ()) {
	    case Msg_WhereAreYou:
		gm = ((Message*) mp)->mut2_ctl_gm (Msg_WhereAreYou_Close);
		gm->Dismiss (grc);
		break;

	    case Msg_Private_Args:
	    case Msg_Shared_Args:
		gm = ((Message*) mp)->mut2_ctl_gm (Msg_Close);
		gm->Dismiss (grc);
		break;

	    case Msg_IamHere_GRC:
	    case Msg_Close:
	    case Msg_WhereAreYou_Close:
		gm = ((Message*) mp)->mut2_ctl_gm (mp->mTag ());
		gm->Dismiss (grc + ((GlobalMessage*) mp)->Dismiss ());
		break;

	    case Msg_Iam:
	    case Msg_Atomic:
	    default:
		send_to_other_pe (dest, (GlobalMessage*)mp);
		gm = new_Close (grc);
		break;
	    }
	    send_to_other_pe (dest, gm);
	}
	else
	    send_to_other_pe (dest, new_Close(grc));
    }
}

static MessageLink*
reply_wru_and_return_rest(MessageLink* mp, int n, u_long& grc,
			  const GlobalID& dest)
    // {}
    // Ȳ grc  n Ĥʬ򤷡줾˱ IamHere 
    // n-1 롥Ĥä grc ֤
    // {}
{
    assert (1 < n);
    int m = 0;
    if (grc < (u_long)n) {
	m = n - grc;
	n = grc;
    }
    for (; n > 1 && grc >= (u_long)n; n--) {
	int rest = grc / n;
	if (rest > (1<<WEIGHT))
	    rest = (1<<WEIGHT);
	grc -= rest;
	MessageLink* next = mp->nextMessage ();
	reply_IamHere_GRC (dest, (GlobalMessage*)mp, rest);
	mp = next;
    }
    n += m;
    while (--n > 0) {
	MessageLink* next = mp->nextMessage ();
	send_to_other_pe (dest, (GlobalMessage*)mp);
	mp = next;
    }
    return mp;
}

void
MJ_W_t::Forward(const GlobalID& dest, u_long grc)
    // {}
    // ᥻塼Ƭ WhereAreYou åСθĿ
    //  GRC ʬ䤷IamHere å롥GRC 
    // 餺ʬȤʬGRC ĤĤäåϳå
    // Ѵ dest žʬȤ IMP_OBJ/IMP_OBJ_NT ˤ
    // ͢ɽϿ롥
    // {}
{
    ObjectTag tag = IMP_OBJ_NT;

    int n = 0;
    MessageLink* mp;
    for (mp = next; mp; mp = mp->nextMessage()) {
	if (mp->mTag() == Msg_WhereAreYou) {
	    n++;
	    if (((Message*)mp)->PID() != PID_CTL_GM)
		tag = IMP_OBJ;
	}
	else {
	    tag = IMP_OBJ;
	    break;
	}
    }
    if (n > 0)
	next = reply_wru_and_return_rest(next, n+1, grc, dest);

    Forward_except_first_wrus(dest);
    ResetMessageQueue();
    ImportTable->Register(dest, grc, this, tag);
}

void
MJ_W_t::Forward_except_first_wrus(const GlobalID& dest)
    // {}
    // Forward()  Forward_and_Free() ؿMJ_W Υå塼
    // ˷ѤäƤå dest ž롥WhreAreYou 
    // ޤǤνϡReply_wru.. ǹԤʤäƤΤ
    // Ǥϲ⤷ʤ
    // {}
{
    MessageLink* mp_next;
    for (MessageLink* mp = next; mp; mp = mp_next) {

	mp_next = mp->nextMessage();

	switch (mp->mTag()) {
	case Msg_Private_Args:
	    send_to_other_pe (dest, ((Message*)mp)->mut2_global_message ());
	    break;

	default:
	    send_to_other_pe (dest, (GlobalMessage*)mp);
	    break;
	}
    }
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
