/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/mj-nc.h"
#include "aum/mj-imp.h"
#include "aum/aj-c.h"
#include "aum/aj-nc.h"
#include "aum/message.h"
#include "aum/globlmsg.h"
#include "aum/connect.h"
#include "aum/trace.h"


// ///////////////////////////////////////////////////////////////
// {}
// Merger Joint Not Connected type
// {}

void
MJ_NC_t::Send (MJ_IMP_OBJ_t * mj)
    // {}
    // ʬȤΥå塼˷ѤäƤåư
    // gid 롥
    // {}
{
    for (Message * mp = PopMessage (); mp; mp = PopMessage ())
	send_to_other_pe (mj->GID (), mp->mut2_global_message ());
}

void
MJ_NC_t::Send (MJ_IMP_OBJ_NT_t * mj)
    // {}
    // åΤ IMP_OBJ_NT  IMP_OBJ ˤIMP_OBJ Ѥ
    // Send () Ƥ֡
    // {}
{
    mj->mut2_IMP_OBJ ();
    Send ((MJ_IMP_OBJ_t *) mj);
}

void
MJ_NC_t::Send_with_dismiss (MJ_IMP_OBJ_t * mj)
    // {}
    // ʬȤΥå塼˷ѤäƤå͢
    //  mj 롥͢ѥ祤 mj ĺå
    // Close 򤪤롥
    // {}
{
    Send (mj);
    mj->Close ();
}

void
MJ_NC_t::Send_with_dismiss (MJ_IMP_OBJ_NT_t * mj)
    // {}
    // åΤ IMP_OBJ_NT  IMP_OBJ ˤIMP_OBJ Ѥ
    // Send_with_dismiss () Ƥ֡
    // {}
{
    mj->mut2_IMP_OBJ ();
    Send_with_dismiss ((MJ_IMP_OBJ_t *) mj);
}

void
MJ_NC_t::Connect (J_NC_t * head)
    // {}
    // 祤head ˤƤΥåʬˤĤʤľ³
    // ̡祤ȤλȲˤʤä餽ʬ
    // ȲʬȤ麹ߤˤʤʤХ祤
    // head Υå塼ˤ롥
    // {}
{
    assert (h.lrc > 1);

    switch (head->Type ()) {
    case MJ_NC:
	Join (head);
	if (TraceMessage && head->MessageExist ())
	    mlog2 ("Recv", ObjectWord (this));
	if (head->LRC () == 1) {
	    ((MJ_NC_t *) head)->Free ();
	    h.lrc--;
	}
	else {
	    head->LRC ()--;
	    ((MJ_NC_t *) head)->mut2_MJ_C (ObjectWord (this));
	}
	return;

    case AJ_NC:
	Join (head);
	if (TraceMessage && head->MessageExist ())
	    mlog2 ("Recv", ObjectWord (this));
	if (head->LRC () == 1) {
	    Word    tail = ObjectWord (this);
	    doConnect (tail, ((AJ_C_t *) head)->Next_joint ());
	    ((AJ_NC_t *) head)->Free ();
	}
	else {
	    head->LRC ()--;
	    ((AJ_NC_t *) head)->mut2_AJ_C (ObjectWord (this));
	}
	return;

    case IMP_INLET:

	// ͢Ƥ INLET Ĥơwhere_are_you å
	// 褿׾Ʊˤ롥

	GlobalMessage * gm = ((MJ_IMP_INLET_t *) head)->mut2_where_are_you ();
	// GLobalMessageTable->Register(gm);
	AppendMessage (gm);
	h.lrc--;
	return;

    case MJ_C:
    case AJ_C:
    case MJ_W:
    case IMP_OBJ:
    case IMP_OBJ_NT:
    case IMP_OUTLET:
	connect_arg_already_connected (ObjectWord (this), head);

    default:
	connect_arg_not_joint (ObjectWord (this), head);
    }
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
