/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/mj-imp.h"
#include "aum/globlmsg.h"
#include "aum/trace.h"
#include "table/import.h"
#include "aum/alloc.h"


// ///////////////////////////////////////////////////////////////
// {}
// Merger joint Mutationed type
// {}

// constructor
void MJ_IMP_t::Initialize(ObjectTag t, const GlobalID& g, int i)
    // {}
    // ͢ѤΥ祤Ȥ롥ȲΣϥåΰ
    // Ȥƥ쥸ؤȹͤ롥
    // {}
{
    assert (i >= 0);
    Header::Initialize(t, 1);
    gid = g;
    import_table_index = i;
    passed_count = 0;
}

void MJ_IMP_t::Reset(const GlobalID& g, int i)
    // {}
    // ͢ѤΥ祤ȤγϤ͢ɽΥǥåꤹ롥
    // {}
{
    assert (i >= 0);
    gid = g;
    import_table_index = i;
    passed_count = 0;
}


MJ_IMP_t*
new_MJ_IMP_t(ObjectTag t, const GlobalID& g, int i)
    // {}
    // ͢ѤΥ祤Ȥ롥
    // {}
{
    MJ_IMP_t* mj = (MJ_IMP_t*)mj_alloc();
    mj->Initialize(t, g, i);
    if (Trace->doit()) Trace->Create("Joint", mj->Print());
    return mj;
}

void MJ_IMP_t::Free()
    // {}
    // ͢ѤΥ祤ΰ롥
    // {}
{
    mj_free(this);
}

void MJ_IMP_t::Close()
{
    u_long grc = ImportTable->Delete (this);
    send_to_other_pe(gid, new_Close (grc));
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
