/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/stdlib.h"
#include "aum/message.h"
#include "aum/globlmsg.h"
#include "aum/msgobj.h"
#include "aum/j-c.h"
#include "aum/aj-nc.h"
#include "aum/trace.h"
#include "aum/tstream.h"
#include "aum/printstack.h"
#include "aum/allocmsg.h"
#include "aum/parallel.h"
#include "aum/sndrcvstats.h"

#ifdef PAS_DEBUGGER
#include "aum/debugger.h"
#endif

void
Message::Initialize (MessageTag t, u_char arity, u_char nbytes, const ProtocolID & p)
{
    MessageLink::Initialize (t, arity, nbytes);
    gid = 0;
    pid = p;
}

Word
Message::Geta (int i)
const
    // {}
    // åΰǥե󥹤֤ͤ
    // {}
{
    Word    x = argv[i];
    while (Is_J_C (x))
	x = J_C_ptr (x)->Destination ();
    return x;
}

Word
Message::CreateMessageObject ()
    // {}
    // ʬʥåˤå֥Ȥ롥
    // {}
    // åȥߥååξˤϡȥߥå֥
    // ȤʤPID ֤
    // {}
    // ȥߥååǤʤˤϡǤˡʬΥԡǤ
    // åˤȤƥå
    // ֥Ȥ롥ˤϿå
    // ˰򥳥ԡΰˤ SYNCOBJ 򥻥åȤ롥å
    // 򥳥ԡΤϼʬϤ¾äƤ뤫Ǥ롥
    // {}
{
    int	    arity = Arity ();
    if (arity == 0)
	return PID ().asWord ();

    LocalMessage* lm = new_LocalMessage (arity, PID ());
    for (int n = 0; n < arity; n++) {
	lm->argv[n] = argv[n];
	argv[n] = SINKOBJ;
    }
    return new_MessageObject (lm);
}

void
Message::Free ()
    // {}
    // å롥
    // {}
{
    int	    nbytes = no_of_bytes ();

#ifndef NDEBUG
    if (mTag () != Msg_Copy)
	assert (MIN_MESSAGE_SIZE <= nbytes && nbytes <= MAX_MESSAGE_SIZE);
#endif
    MESSAGE_FREE (this, nbytes);
}

void
Message::Terminate ()
    // {}
    // å SINK ˷Ҥ˼¹Ԥ롥ü SINK ˷Ҥ
    // üĺ롥ǸˡFree() ˤå롥
    // {}
{
    int arity = Arity ();
    if (arity > 0) {
	u_long	modes = Mode_mask ();
	for (register int i = 0; i < arity; i++) {
	    if (modes & 1)
		doClose (argv[i]);
	    else
		doConnect (SINKOBJ, (J_NC_t *) Pointer (argv[i]));
	    modes >>= 1;
	}
    }
    Free ();
}

static	Boolean
cannot_split (Word x)
    // {}
    // ȥ졼ѤؿåΰץåȤǤʤ
    // 򤽤Ǥʤе֤
    // {}
{
    if (Type_of (x) != AUm_Object)
	return FALSE;
    switch (Pointer (x)->Type ()) {
    case IMP_INLET:
    case TRACE_INLET:
	break;
    default:
	return FALSE;
    }
    return TRUE;
}

void
Message::TraceSplit ()
    // {}
    // åΰλȲܣ롥ϥȥ졼˥å
    // ߤȤƲʤȤݾڤ뤿Ѥ롥
    // ץåȤǤʤ INLET ξϡ祤Ȥ򥳥ԡ롥
    // {}
{
    if (mTag () == Msg_Private_Args) {
	int	argc = Arity ();
	for (int n = 0; n < argc; n++) {
	    if (!cannot_split (argv[n]))
		doSplit (argv[n]);
	}
    }
}

void
Message::TraceClose ()
    // {}
    // Message::Split() ˤäơܣȲ򸵤̤᤹Ȥơ
    // ߤȤʤäˤϲԤʤץåȤǤʤ
    // INLET ξϡԡƤΰ롥
    // {}
{
    if (mTag () == Msg_Private_Args) {
	int	argc = Arity ();
	for (int n = 0; n < argc; n++) {
	    Word    x = argv[n];
	    if (cannot_split (x)) {
		if (J_NC_ptr (x)->oTag () == TRACE_INLET)
		    MJ_NC_ptr (x)->Free ();
	    }
	    else
		doClose (x);
	}
    }
}

Name const
Message::Printname ()
const
    // {}
    // åΰ̾øʸȤ֤
    // {}
{
    if (mTag () == Msg_Atomic)
	return print (pid.asWord ());
    else
	return pid.Name ();
}

Name
Message::PrintFunctor ()
const
    // {}
    // ǥХåѴؿåmessage-name/modeηǰ
    // ᡼ʸȤ֤
    // {}
{
    char    mode[AUM_MAXARGS];
    u_char  arity = Arity ();

    if (arity > 0)
	sprint_protocol_mode (mode, arity, Mode_mask ());

    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    if (arity > 0)
	tout.form ("%s/%d(%s)", Printname (), arity, mode);
    else
	tout.form ("%s/%d", Printname (), arity);
    return tout.Result ();
}

Name
Message::Print ()
const
    // {}
    // ǥХåѴؿåmessage-name(arg0,arg1,...)ɸ
    // Ϥ˽Ϥ롥
    // {}
{
    return print_with_dereference (FALSE);
}


Name
Message::xPrint ()
const
    // {}
    // ȥ졼Ѵؿåmessage-name(arg0,arg1,...)ɸ
    // Ϥ˽Ϥ롥ηޤäޡξ
    // dereference 롥
    // {}
{
    return print_with_dereference (TRUE);
}

Name
Message::print_with_dereference (Boolean deref)
const
    // {}
    // ǥХåѴؿåmessage-name(arg0,arg1,...)η
    // ᡼ʸȤ֤deref ͤʤС
    // ΰĴ١ηޤäޡξ dereference
    // 롥
    // {}
{
    switch (mTag ()) {
    default:
	abort ();

    case Msg_Atomic:
	return print (pid.asWord ());

    case Msg_WhereAreYou:
    case Msg_Close:
    case Msg_WhereAreYou_Close:
    case Msg_IamHere_GRC:
    case Msg_Iam:
    case Msg_Create:
    case Msg_Copy:
	return ((GlobalMessage *) this)->print_ctl_message ();
#ifdef PAS_DEBUGGER
    case Msg_Debugger:
	if (argv[0] == TRECEIVE) {
	    int np = argv[1];
	    char tem[BUFSIZ];
	    tstream tout = tstream(BUFSIZ,tem);
	    tout.form (" %x #PE: %d ", this, np);
	    for (int ind = 3;ind < 32;ind++){
		if (argv[ind] == 0) break;
		if (0xff00 & argv[ind]){
		    tout.form("%c",((argv[ind]>>8)&0xff));
		    tout.form("%c",(argv[ind]&0xff));
		}else{
		    tout.form("%c",(argv[ind]&0xff));
		}
	    }
	    return tout.Result();
	}else{
	    int np = argv[1];
	    char tem[BUFSIZ];
	    tstream tout = tstream(BUFSIZ,tem);
	    tout.form (" %x #PE:%d controll %x", this, np, argv[0]);
	    return tout.Result();
	}
	break;
#endif
    case Msg_Shared_Args:
    case Msg_Private_Args:
	Name printname = Printname ();
	u_char	arity = Arity ();
	if (arity == 0) {
	    return printname;
	}
	else {
	    char    tem[BUFSIZ];
	    tstream tout = tstream (BUFSIZ, tem);
	    tout << printname << "(" << print_args (deref, mTag ()) << ")";
	    return tout.Result ();
	}
    }
#ifdef PAS_DEBUGGER
    // for delete warning
    return (char*)0;
#endif
}

Name
Message::print_args (Boolean deref, MessageTag t)
const
    // {}
    // ǥХåѴؿåΰ arg0,arg1,.. ηǰ
    // ᡼ʸȤ֤deref ͤʤСå
    // ΰĴ١ηޤäޡξ dereference 롥
    // {}
{
    if (!TraceStream->TooDeep ()) {
	u_char	arity = Arity ();
	u_long	modes = Mode_mask ();
	char	tem[BUFSIZ];
	tstream tout = tstream (BUFSIZ, tem);

	TraceStream->Enter ();
	for (register int i = 0; i < arity; i++) {
	    Word    x = argv[i];
	    if ((modes & (1 << i)) == 0)
		tout << "^";
	    if (deref && t == Msg_Private_Args) {
		while (Is_J_C (x)) {
		    x = J_C_ptr (x)->Destination ();
		}
		argv[i] = x;
	    }
	    if (t == Msg_Private_Args)
		tout << print_by_private (x);
	    else
		tout << print_by_shared (x);
	    if (i + 1 != arity)
		tout << ",";
	    PrintStack.push (x);
	}
	for (i = 0; i < arity; i++)
	    PrintStack.pop ();
	TraceStream->Exit ();
	return tout.Result ();
    }
    return "...";
}

Name
Message::printLink ()
const
    // {}
    // ǥХåѴؿåΥéäơҤäƤ
    // ɸϤ˥ץȥȤ롥塼Ĺ
    // ʾˤʤäϡ":..." Ȥƾά򤹤롥
    // {}
{
    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    tout << ":" << Print ();
    int	    ln = 10;
    for (MessageLink * mp = next; mp && --ln >= 0; mp = mp->nextMessage ()) {
	tout << ":" << ((Message *) mp)->Print ();
    }
    if (mp)
	tout << ":...";
    return tout.Result ();
}

#ifdef SNDRCV_STATS
void
calc_sndrcv_stats (u_char pe, GlobalMessage * gm)
{
    switch (gm->mTag ()) {
    case Msg_Atomic:
	UPDATE_SNDRCV_STATS (pe, atomic);
	return;

    case Msg_Shared_Args:
	UPDATE_SNDRCV_STATS (pe, shared_args);
	return;

    case Msg_Close:
	UPDATE_SNDRCV_STATS (pe, close);
	break;

    case Msg_WhereAreYou_Close:
	UPDATE_SNDRCV_STATS (pe, where_are_you_close);
	break;

    case Msg_WhereAreYou:
	UPDATE_SNDRCV_STATS (pe, where_are_you);
	break;

    case Msg_IamHere_GRC:
	UPDATE_SNDRCV_STATS (pe, iam_here);
	break;

    case Msg_Iam:
	UPDATE_SNDRCV_STATS (pe, iam);
	break;

    case Msg_Copy:
	UPDATE_SNDRCV_STATS (pe, copy);
	break;

    default:
	abort ();
    }
    if (gm->PID () != PID_CTL_GM) {
	if (gm->Arity () == 0) {
	    UPDATE_SNDRCV_STATS (pe, atomic);
	}
	else {
	    UPDATE_SNDRCV_STATS (pe, shared_args);
	}
    }
}
#endif				/* SNDRCV_STATS */

void
send_to_other_pe (const GlobalID & gid, GlobalMessage * gm)
{
    assert (gm != 0);
    u_char  pe = gid.PE ();
    gm->GID (gid);
    if (PElog)
	pelog ("Forward :%s to PE%s {%x}", gm->Print (), gid.Print (), gm);
#ifdef SNDRCV_STATS
    calc_sndrcv_stats (pe, gm);
#endif
    PAS_send (pe, gm);
}

void
Message::Check_size ()
const
{
#ifndef NDEBUG
    int	    nbytes = h.nbytes;
    if (mTag () != Msg_Copy)
	assert (MIN_MESSAGE_SIZE <= nbytes && nbytes <= MAX_MESSAGE_SIZE);
#endif
}

void
Message::Check_tag ()
const
{
    switch (tag) {
    case Msg_Atomic:
    case Msg_Private_Args:
    case Msg_Shared_Args:
    case Msg_Close:
    case Msg_WhereAreYou_Close:
    case Msg_WhereAreYou:
    case Msg_IamHere_GRC:
    case Msg_Iam:
    case Msg_Create:
    case Msg_Resource:
    case Msg_Request_resource:
    case Msg_Initialize:
    case Msg_Terminate:
    case Msg_Copy:
	return;
    default:
	abort ();
    }
}

void
Message::Check ()
const
{
    Check_size ();
    Check_tag ();
}


#ifdef SOCKET_COMM

Message *
new_SockMessage (MessageTag tag, u_long resource)
    // {}
    // ΰݤƳå롥å
    //  tag, ο arity, ƥץȥɣĤ pid ˽
    // 롥 GID ӥåΰϽʤ
    // {}
{
    int	    nbytes = sizeof (GlobalMessage) - sizeof (Word);
    switch (tag) {
    case Msg_Resource:
    case Msg_Request_resource:
    case Msg_Initialize:
    case Msg_Terminate:
	break;
    default:
	abort ();
    }
    GlobalMessage *gm = (GlobalMessage *) MESSAGE_ALLOC (nbytes);
    gm->Initialize (tag, 0, nbytes, 0);
    gm->Resource (resource);
    gm->MsgNo (0);
    return gm;
}

#ifndef BIG_ENDIAN

#include <sys/types.h>
#include <netinet/in.h>

extern "C" {
    unsigned long htonl (unsigned long);
    unsigned short htons (unsigned short);
    unsigned long ntohl (unsigned long);
    unsigned short ntohs (unsigned short);
}

void
Message::Convert_network_byte_order ()
{
    h.nbytes = htons (h.nbytes);
    gid = htonl (u_long (gid.peep ()));
    pid = htonl (u_long (pid.peep ()));
    resource = htonl (resource);
    msgno = htonl (msgno);
    for (int n = 0; n < arity; n++)
	argv[n] = htonl (argv[n]);
}

void
Message::Convert_host_byte_order ()
{
    h.nbytes = ntohs (h.nbytes);
    gid = ntohl (u_long (gid.peep ()));
    pid = ntohl (u_long (pid.peep ()));
    resource = ntohl (resource);
    msgno = ntohl (msgno);
    for (int n = 0; n < arity; n++)
	argv[n] = ntohl (argv[n]);
}

#endif				/* not BIG_ENDIAN */
#endif				/* SOCKET_COMM */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-continued-brace-offset:0
 * c-brace-offset:0
 * c-brace-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-empty-arglist-indent:4
 * c++-friend-offset:0
 * c-imaginary-offset:0
 * c++-electric-colon:t
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
