/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/error.h"
#include "aum/fetch.h"
#include "aum/merger.h"
#include "aum/message.h"
#include "aum/trace.h"
#include "aum/execbmsg.h"
#include "aum/globlmsg.h"
#include "aum/alloc.h"
#include "aum/allocstats.h"
#include "aum/parallel.h"

// #define ALLOC_DEBUG 1

#ifdef ALLOC_DEBUG
#include <stream.h>
#endif

//
// ι¤Τ礭ϡMJ_NC ƱǤʤƤϤʤʤ
//
struct MJ_Rec {
    int header;
    struct MJ_Rec *next;
    int dummy;
};

static MJ_Rec *mj_first_p;
static void reallocate_merger_memory (char *);

#define MJ_POOL_SIZE  1024
static char mj_memory[MJ_POOL_SIZE];

void
Initialize_merger_memory ()
{
#ifndef NDEBUG
    int sizeof_MJ_NC_t = sizeof (MJ_NC_t);
    int sizeof_MJ_Rec = sizeof (MJ_Rec);
    assert (sizeof_MJ_NC_t == sizeof_MJ_Rec);
#endif
    reallocate_merger_memory (mj_memory);
}

static void
reallocate_merger_memory (char *top)
{
#ifdef ALLOC_DEBUG
    pelog ("mj realloc %x", top);
#endif
    MJ_Rec *p = mj_first_p = (MJ_Rec *) &top[0];
    {
	int nitems = MJ_POOL_SIZE / sizeof (MJ_Rec) - 1;
	while (--nitems >= 0) {
	    p->next = p + 1;
	    p++;
	}
    }
    p->next = NULL;
}

void   *
mj_alloc ()
{
    assert ((unsigned) mj_first_p >= (unsigned) mj_memory);
    assert ((unsigned) mj_first_p < 0x10000000);
    void   *v = mj_first_p;
    mj_first_p = mj_first_p->next;
    UPDATE_ALLOC_STATS (mj_alloc);
    if (!mj_first_p)
	reallocate_merger_memory (SHARED_ALLOC (MJ_POOL_SIZE));
    assert ((unsigned) mj_first_p >= (unsigned) mj_memory);
    assert ((unsigned) mj_first_p < 0x10000000);
#ifdef ALLOC_DEBUG
    pelog ("mj alloc %x", v);
#endif
    return v;
}

void
mj_free (void *v)
{
    MJ_Rec *p = (MJ_Rec *) v;

#ifdef ALLOC_DEBUG
    pelog ("mj free %x", v);
#endif
#ifndef NDEBUG
    switch (((Header *) v)->oTag ()) {
    case MJ_NC:
    case MJ_W:
    case MJ_C:
    case MJ_Mut:
    case IMP_OBJ:
    case IMP_OBJ_NT:
    case IMP_INLET:
    case IMP_OUTLET:
    case TRACE_INLET:
	break;
    default:
	abort ();
    }
    p->header = -1;
    p->dummy = -1;
#endif

    assert ((unsigned) mj_first_p >= (unsigned) mj_memory);
    assert ((unsigned) mj_first_p < 0x10000000);
    UPDATE_ALLOC_STATS (mj_free);
    p->next = mj_first_p;
    mj_first_p = p;
    assert ((unsigned) mj_first_p >= (unsigned) mj_memory);
    assert ((unsigned) mj_first_p < 0x10000000);
}

// //////////////////////////////////////////////////////////////////////
// //////////////////////////////////////////////////////////////////////
// //////////////////////////////////////////////////////////////////////

Boolean
IsInlet (Word x)
    // {}
    //  x üȤ³ǽʤп򡤤Ǥʤе
    // 
    // {}
{
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case AJ_NC:
	case MJ_NC:
	case IMP_INLET:
	    return TRUE;
	default:
	    break;
	}
    }
    return FALSE;
}

Word
new_Merger (int rc = 1)
    // {}
    // ʻ祸祤Ȥ֤Ȳ rc ꤹ롥
    // {}
{
    MJ_NC_t *mj = (MJ_NC_t *) mj_alloc ();
    mj->Initialize (MJ_NC, rc);
    if (Trace->doit ())
	Trace->Create ("Joint", mj->Print ());
    return ObjectWord (mj);
}

void
MJ_NC_t::Free ()
    // {}
    // ޡ롥褬¸ߤ硤Ĥ롥
    // {}
{
    if (Trace->doit ())
	Trace->Destroy (form ("Joint_%x", this), Print ());
    mj_free (this);
}

void
MJ_C_t::Free ()
    // {}
    // ޡ롥褬¸ߤ硤Ĥ롥
    // {}
{
    if (Trace->doit ())
	Trace->Destroy (form ("Joint_%x", this), Print ());
    mj_free (this);
}

void
J_NC_t::Reached_atomic (Word dest)
    // {}
    // ޡμꥹȤ˷ҤäƤå¹Ԥ롥dest 
    // ȥߥå֥ȤǤʤƤϤʤåϡȹ
    // ΣУɣĤäƤʤФʤʤ
    // {}
{
    assert (Type_of (dest) != AUm_Object);
    for (Message * mp = PopMessage (); mp; mp = PopMessage ()) {
	switch (mp->mTag ()) {
	case Msg_Atomic:
	case Msg_Private_Args:
	    ExecuteBuiltinMessage (dest, mp);
	    break;
	case Msg_Shared_Args:
	    // GlobalMessageTable->Delete(mp);
	    ExecuteGlobalMessage (dest, (GlobalMessage *) mp);
	    break;
	case Msg_WhereAreYou:
	    Answer_where_are_you ((GlobalMessage *) mp, dest);
	    break;
	case Msg_WhereAreYou_Close:
	case Msg_IamHere_GRC:
	case Msg_Iam:
	case Msg_Create:
	case Msg_Close:
	default:
	    abort ();
	}
    }
}

void
J_NC_t::Reached_structure (Word dest)
    // {}
    // ޡμꥹȤ˷ҤäƤå¹Ԥ롥¤
    // Ȥ߹ߥ֥ȤǤ롥åϡȹΣУɣĤ
    // äƤʤФʤʤ
    // {}
{
    assert (Type_of (dest) == AUm_Object);
    for (Message * mp = PopMessage (); mp; mp = PopMessage ()) {
	switch (mp->mTag ()) {
	case Msg_Atomic:
	case Msg_Private_Args:
	    ExecuteBuiltinMessage (dest, mp);
	    break;
	case Msg_Shared_Args:
	    // GlobalMessageTable->Delete(mp);
	    ExecuteGlobalMessage (dest, (GlobalMessage *) mp);
	    break;
	case Msg_WhereAreYou:
	    Answer_where_are_you ((GlobalMessage *) mp, Pointer (dest));
	    break;
	case Msg_WhereAreYou_Close:
	case Msg_IamHere_GRC:
	case Msg_Iam:
	case Msg_Create:
	case Msg_Close:
	default:
	    abort ();
	}
    }
}

void
J_NC_t::DiscardMessage (void)
    // {}
    // ޡμꥹȤ˷ҤäƤ˴롥åä
    // ޡ򥷥󥯥֥Ȥ³Ѥ롥
    // {}
{
    for (Message * msg = PopMessage (); msg != NULL; msg = PopMessage ())
	msg->Free ();
}

METHOD (create_mjoint, R1_OP)
    // {}
    // create_mjoint Ri;
    // {}
    // [	   address ]
    // [  Ri|	0|	  0]
    // {}
    // ޡ㡼롥
    // {}
{
    Fetch112 ();
    Reg[ip->b0] = new_Merger ( /* RC= */ 2);
    JumpNextInstruction ();
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
