/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "config.h"

#ifndef PAS_DEBUGGER

#include <stream.h>
#include "aum/global.h"
#include "aum/time.h"
#include "aum/parallel.h"

extern const char Version[];
extern const char CompileDate[];

extern void Toplevel (int n_pes);
extern void PrintWord (Word);
extern void Initialize_shared (int s_atom, int s_protocol);
extern void parse_options (const int argc, const char *argv[]);
extern void loader (const int argc, const char* argv[]);

extern	"C" {
    void    moncontrol ();
};

int
main (int argc, char *argv[])
{
    // moncontrol (0);
    cout.form ("***** PAS %s (%s) *****\n", Version, CompileDate);
    cout.flush ();

    Program_filename = argv[0];
    parse_options (argc, argv);

    Initialize_shared (Tatom, Tprotocol);

    // moncontrol (1);
    loader (PasArgc, PasArgv);
    // moncontrol (0);

    long    rstart = mctime ();
    long    cstart = mcputime ();

    // moncontrol (1);
    Toplevel (PAS_npe);
    // moncontrol (0);

    long    cend = mcputime ();
    long    rend = mctime ();

    cout.form ("PAS done. Time is %d msecs, CPU is %d msecs.\n",
	       rend - rstart, cend - cstart);
    cout.flush ();

    if (Statistics_flag) {
	PAS_report_monitoring ();
#ifdef SNDRCV_STATS
	SndRcvStats.Report (statistics_flag);
#endif
#ifdef ALLOC_STATS
	AllocStats.Report (statistics_flag);
#endif
    }
    return 0;
}

#endif /* PAS_DEBUGGER */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
