/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/allocmsg.h"
#include "table/export.h"
#include "table/import.h"
#include "aum/localmsg.h"
#include "aum/globlmsg.h"

#define sizeof_LocalMessage	(sizeof(LocalMessage)-sizeof(Word))
extern int MessageCount;

LocalMessage *
new_AtomicMessage (const ProtocolID & id)
    // {}
    // ץȥɣ id ĸϥå롥
    // {}
{
    MessageCount++;
    LocalMessage *lm = (LocalMessage *) MESSAGE_ALLOC (sizeof_LocalMessage);
    lm->Initialize (Msg_Atomic, 0, sizeof_LocalMessage, id);
    return lm;
}

LocalMessage *
new_LocalMessage (u_char arity, const ProtocolID & id)
    // {}
    // ץȥɣ idο arity å
    // 롥arity ϣʾǤʤƤϤʤʤåΰϽ
    // ʤ
    // {}
{
    assert (arity > 0);
    MessageCount++;
    int	    nbytes = sizeof_LocalMessage + arity * sizeof (Word);
    LocalMessage *lm = (LocalMessage *) MESSAGE_ALLOC (nbytes);
    lm->Initialize (Msg_Private_Args, arity, nbytes, id);
    return lm;
}

LocalMessage *
CreateMessage (u_char arity, const ProtocolID & id)
    // {}
    // ץȥɣ idο arity å
    // 롥åƤΰǽ롥
    // {}
{
    LocalMessage *lm = new_LocalMessage (arity, id);
    for (register int n = arity; --n >= 0; lm->Argv (n, INT0));
    return lm;
}

LocalMessage *
CreateAtomicMessage (Word atomic)
    // {}
    // ϥ֥ atomic ΤȤ븶ϥå롥
    // ץȥɣĤϸϥ֥ȤΤΤѤ롥
    // {}
{
    return new_AtomicMessage (ProtocolID (atomic));
}

Message *
CreateMessage (const ProtocolID & id, Word a0)
    // {}
    // {}
{
    LocalMessage *lm = new_LocalMessage (1, id);
    lm->Argv (0, a0);
    return (Message *) lm;
}

Message *
CreateMessage (const ProtocolID & id, Word a0, Word a1)
    // {}
    // {}
{
    LocalMessage *lm = new_LocalMessage (2, id);
    lm->Argv (0, a0);
    lm->Argv (1, a1);
    return (Message *) lm;
}

Message *
CreateMessage (const ProtocolID & id, Word a0, Word a1, Word a2)
    // {}
    // {}
{
    LocalMessage *lm = new_LocalMessage (3, id);
    lm->Argv (0, a0);
    lm->Argv (1, a1);
    lm->Argv (2, a2);
    return (Message *) lm;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
