/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "config.h"

#include <stddef.h>
#include <sys/types.h>
#include <sys/file.h>
#include <stdio.h>
#include <stream.h>
#include <string.h>
#ifndef NO_SYS_FCNTL_H
#include <unistd.h>
#endif
#include <stdlib.h>
#include <errno.h>

#include "aum/global.h"
#include "aum/error.h"
#include "table/nlist.h"

////////////////////////////////////////////////////////////////////////

extern int aum_assembler (const char *);
extern void Initialize_NameList (const char *);

////////////////////////////////////////////////////////////////////////

static Boolean
read_access_ok (const char* filename)
{
    if (Verbose)
	cout << "try to open: " << filename;
    if (access (filename, R_OK) == 0) {
	if (Verbose)
	    cout << ", done.\n";
	return TRUE;
    }
    if (Verbose)
	cout << ": " << sys_errlist[errno] << "\n";
    return FALSE;
}

static int
find_assembler_file (const char* path, const char* file, char* fullpathname)
    // {}
    // ѥ̾Υꥹ(ǥߥ`:')Ϳǥ쥯ȥ꤫顤file
    // Ϳե̾򸫤Ĥ롥Ĥäˤϡ
    // fullpathname ˥եΥեѥ̾򥻥åȤ1 ֤Ĥ
    // ʤäˤ 0 ֤顼ˤ -1 ֤
    // {}
{
    if (file[0] == '/') {
	strcpy (fullpathname, file);
	return read_access_ok (fullpathname) == TRUE ? 1 : 0;
    }
    const char* start = path;
    do {
	int i = 0;
	const char* s = start;
	for (;;) {
	    if (*s == ':') {
		start = s + 1;
		break;
	    }
	    if (*s == '\0') {
		start = s;
		break;
	    }
	    fullpathname[i++] = *s++;
	}
	if (i >= 1 && fullpathname[i-1] != '/')
	    fullpathname[i++] = '/';
	for (const char* t = file; *t; t++) {
	    fullpathname[i++] = *t;
	}
	fullpathname[i] = '\0';
	if (read_access_ok (fullpathname) == TRUE)
	    return 1;
    } while (*start);
    return 0;
}

static Boolean
aum_source_file_p (const char* filename)
{
    const char* s = strrchr (filename, '.');
    if (s == NULL)
	return FALSE;
    if (strcmp (s, ".aao") == 0 || strcmp (s, ".aas") == 0)
	return TRUE;
    return FALSE;
}

#ifdef DYNAMIC_LINK
static void
check_undefined_symbols ()
{
    const char** undefs = dld_list_undefined_sym ();
    if (undefs) {
	cout << "Following functions or symbols are Undefined:\n";
	for (int i = 0; i < dld_undefined_sym_count; i++) {
	    const char* name = undefs[i];
	    cout << name << "\n";
	}
	exit (dld_undefined_sym_count);
    }
}
#endif /* DYNAMIC_LINK */

void
loader (const int argc, const char* argv[])
{
    if (Verbose)
	cout << "A'um loader start...\n";

    const char *path = getenv ("AUMLOADPATH");
    if (!path)
	path = AUMLOADPATH;

    int nerrs = 0;
    for (register int n = 0; n < argc; n++) {
	const char   *filename = argv[n];

	char fullpathname[BUFSIZ];
	switch (find_assembler_file (path, filename, fullpathname)) {
	case 1:
	    break;
	case 0:
	    error (filename,
		   "Can't open in the directories: AUMLOADPATH=%s", path);
	    nerrs++;
	    continue;
	case -1:
	    fatal ("loader", "Can't recover the errors");
	default:
	    abort ();
	}

	if (aum_source_file_p (fullpathname)) {
	    if (aum_assembler (fullpathname) != 0) {
		error ("loader", "Can't recover the errors");
		exit (ExitStatus);
	    }
	}
	else {
#ifdef DYNAMIC_LINK
	    if (NameList_load_p == FALSE) {
		Initialize_NameList (Program_filename);
		NameList_load_p = TRUE;

	    }
	    if (dld_link (fullpathname) != 0) {
		dld_perror (fullpathname);
		nerrs++;
	    }
#else /* DYNAMIC_LINK */
	    error ("loader", "invalid filename : %s",filename);
	    nerrs++;
#endif /* DYNAMIC_LINK */

	}
    }
    if (Verbose)
	cout.flush ();
    if (nerrs)
	exit (nerrs);
#ifdef DYNAMIC_LINK
    check_undefined_symbols ();
#endif /* DYNAMIC_LINK */
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
