/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

// {}
// ååѴ롥
// {}

#include <assert.h>
#include "aum/error.h"
#include "aum/globlmsg.h"
#include "aum/mj-nc.h"
#include "aum/trace.h"
#include "aum/builtin.h"
#include "aum/string.h"

Message *
GlobalMessage::mut2_local ()
// {}
// ååѴ롥˳Ϥ
// ä顤ImportTable Ͽ롥ޤdouble/string Ͽ
// Ͽ򤹤
// {}
//  ImportTable->Register  2 δؿ3 ΤȤΤϰ
// ʤΤա ˡϿƤСХ뻲ȥȤ
// Ťߤ ûΥ祤ȤΥɥ쥹֤ Ǥʤ
// ˤϡ˥祤Ȥ, dest, indexꤷ
// 祤Ȥ ImportTable Ͽ롥 Х뻲ȥȤ
// ꤹ롥 祤ȤΥɥ쥹֤
// {}
{
    if (tag == Msg_Atomic) {
	gid = 0;
	return (Message *) this;
    }

    int	    argc = Arity ();

    for (int i = 0; i < argc; i++) {
	GlobalID x = argv[i];
	switch (x.Tag ()) {
	case GID_Fixnum:
	case GID_Atom:
	    continue;

	case GID_Pointer:
	    argv[i] = ImportTable->Register (x, x.Hint ());
	    continue;

	case GID_Constant:
	    {
		Word	w = argv[i];
		if (IsSObject (w)) {
		    switch (SObjectType_of (w)) {
		    case AUm_Sink:
			continue;

		    case AUm_UndefOutlet:
		    case AUm_UndefInlet:
		    case AUm_ErrorObject:
			abort ();

		    case AUm_Encoded_DFLOAT:
			argv[i] = CopyDFloat (decode_word (w));
			continue;

#if nodef
		    case AUm_Encoded_ASCII_STR:
			argv[i] = CopyASCIIString (decode_word (w));
			continue;

		    case AUm_Encoded_EUC_STR:
			argv[i] = CopyEUCString (decode_word (w));
#endif

		    default:
			abort ();
		    }
		}
	    }
	    continue;
	}
    }
    tag = Msg_Private_Args;
    gid = 0;
    return (Message *) this;
}

Word
GlobalMessage::decode_word (Word w)
{
    int	    offset = EncodedVal (w);
#define MESSAGE_SIZE ((no_of_bytes()-sizeof(Message))/sizeof(Word)-1)
    assert (offset <= MESSAGE_SIZE);
    Word    x = ObjectWord (&argv[offset]);
    return x;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-continued-brace-offset:0
 * c-brace-offset:0
 * c-brace-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-empty-arglist-indent:4
 * c++-friend-offset:0
 * c-imaginary-offset:0
 * c++-electric-colon:t
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
