/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "config.h"
#include "aum/aj-c.h"
#include "aum/error.h"
#include "aum/fetch.h"
#include "aum/global.h"
#include "aum/globlmsg.h"
#include "aum/msgobj.h"
#include "aum/parallel.h"
#include "aum/scheduler.h"
#include "aum/stdlib.h"
#include "aum/sndrcvstats.h"
#include "aum/debugger.h"
#include "class/template.h"

// #define TIMESLICE 128
// #define TIMESLICE 8
// #define TIMESLICE 10000
#define TIMESLICE 32

extern int Texport;
extern int Timport;
extern Boolean TraceInstruction;
extern Boolean Initialize_private (int s_export, int s_import);
extern void End_private ();
extern void Receive_SystemMessage (GlobalMessage *);
extern void doTerminate ();
extern void PrintInstruction (const Instruction *);

extern	"C" {
    void    Initialize_PE ();
};

const Instruction *InstructionPointer;

int	MessageCount;
int	TimeSlice = TIMESLICE;

static void doInterpreter ();
static void Execute ();

#ifdef ENABLE_INSTRUCTION_TRACE
#define TraceMessageSplit {if(TraceInstruction)CurrentMessage->TraceSplit();}
#define TraceMessageClose {if(TraceInstruction)CurrentMessage->TraceClose();}

#else
#define TraceMessageSplit ;
#define TraceMessageClose ;
#endif

#ifdef PAS_DEBUGGER

#include "aum/trace.h"
#include "aum/send.h"
#include "aum/close.h"
#include "aum/parallel.h"
#include "class/clink.h"
#include "class/method.h"
#include "table/protocol.h"
#include "table/atomhash.h"
#include "table/export.h"
#include "table/import.h"
#include "debugger/src/debugpe.h"

extern ProtocolEntry *SearchProtocolID (ProtocolID & so);
extern void display_command_argment ();
extern Boolean is_enter_debuggging_mode (Object * o);
extern debugger_symbol BreakLoop (Boolean * t, Object * o);
extern void Listener ();
extern Boolean ableToSendGo ();
extern void message_to_Listener (debugger_symbol com);
extern void message_to_Listener (debugger_symbol, unsigned char *);
extern void refresh_mg_link ();
extern void CommandShell ();

GlobalMessage *global_message_queue;
Boolean trace_switch;
Boolean stop;
Boolean break_method;
Boolean step;
Boolean next_step;
Boolean IsFirst;
debugger_symbol db_cont;
int	receive_messages = 0;
void	doInterpreter ();
extern void is_enter_break_loop_close(Object* object);
extern void is_enter_break_loop(Object* object,Message* cmp);
#else
static void doInterpreter ();
#endif
void
Interpreter ()
{
    if (PElog)
	pelog ("Starting ...");
    PAS_begin_monitoring ();
#ifdef PAS_DEBUGGER
    if (Initialize_private (Texport, Timport) == FALSE)
	fatal ("Initialize", "System initialization failed. Good-bye!");
    if (PAS_self_peno == DEBUGGER_PE)
	Listener ();
    else
	CommandShell ();
    // refresh_mg_link();
#else
    if (Initialize_private (Texport, Timport) == FALSE)
	fatal ("Initialize", "System initialization failed. Good-bye!");
    doInterpreter ();
#endif
    PAS_end_monitoring ();

#ifdef SNDRCV_STATS
    SndRcvStats.Send_to_PE0 ();
#endif
    if (PElog)
	pelog ("Done.");
    End_private ();
    return;
}

#ifdef PAS_DEBUGGER
void
#else
static void
#endif
doInterpreter ()
{
#ifdef PAS_DEBUGGER
    global_message_queue = (GlobalMessage *) 0;
    if (PAS_self_peno == 0)
	ableToSendGo ();
#endif
scheduling:
    for (;;) {
	if (PElog)
	    pelog ("Scheduling ...");
	if (ScheduleTable.PriorityControl () == FALSE) {
#ifdef PAS_DEBUGGER
	    if (global_message_queue) {
		Receive_SystemMessage (global_message_queue);
		global_message_queue = (GlobalMessage *) 0;
		message_to_Listener (RECD_MESSAGE);
		continue;
	    }
#endif
#ifdef PAS_DEBUGGER
	    if (ScheduleTable.NoWhere ())
		message_to_Listener (WAIT_MESSAGE);
	    receive_messages--;
#endif

	    GlobalMessage *message = PAS_receive_in_nonblocking ();
	    while (!message) {
		switch (PAS_wait_for_terminate ()) {
		case -1:
		    return;
		case 0:
		    message = PAS_receive_in_nonblocking ();
		    continue;
		case 1:
		    message = PAS_receive ();
		    continue;
		default:
		    abort ();
		}
	    }

#ifdef PAS_DEBUGGER
	    message_to_Listener (RECD_MESSAGE);
	    receive_messages--;
	    if (message->Type () == Msg_Debugger) {
		MessageLink *next;
		next = message->nextMessage (), message->nextMessage (NULL);
		message->Free ();
		GlobalMessage *gmm;
		gmm = (GlobalMessage *) next;
		receive_messages++;
		while (gmm) {
		    next = gmm->nextMessage (), gmm->nextMessage (NULL);
		    gmm->Free ();
		    receive_messages++;
		    if (receive_messages >= 0)
			break;
		    gmm = (GlobalMessage *) next;
		}
		return;
	    }
#endif
	    Receive_SystemMessage (message);
	}
	else {
	    register Object *object;
	    register Message *cmp;

	    if ((object = ScheduleTable.ActiveObject ()) == (Object *) 0)
		continue;
#ifdef PAS_DEBUGGER
	    else {
		message_to_Listener (RECD_MESSAGE);
		receive_messages--;
	    }
#endif
	    switch (object->Type ()) {
	    case READY:
		break;
	    case ERROR:
	    case SINK:
	    case SLEEPING:
	    case SUSPENDED:
		goto scheduling;

	    case CLOSED:
		CurrentObject = object;
		InstructionPointer = object->ClassTemplate ()->SearchCloseMethod ();
#ifdef PAS_DEBUGGER
		is_enter_break_loop_close(object);
		InstructionPointer = (Instruction*)0;
		BREAK_LOOP;
		if (db_cont == QUIT)
		    return;
#endif
		if (InstructionPointer) {
		    CurrentMessage = NULL;
		    Execute ();
		    if (object->MessageExist () == TRUE) {
			object->doREADY ();
			break;
		    }
		    if (object->Type () == ERROR && object->LRC () == 0)
			object->Free ();
#ifdef PAS_DEBUGGER
		    if (db_cont == QUIT)
			return;
#endif
		}
		else {
		    object->TerminateSlots ();
		    object->Free ();
		}
		goto scheduling;

	    default:
		abort ();
	    }
	    CurrentObject = object;
	    if (PElog)
		pelog ("Execute %x w/ %s", object, object->Print ());

	    MessageCount = 0;
	    for (cmp = object->PopMessage (); cmp; cmp = object->PopMessage ()) {
		CurrentMessage = cmp;
		switch (cmp->mTag ()) {
		case Msg_Atomic:
		case Msg_Private_Args:
		    break;

		case Msg_Shared_Args:
		    cmp = ((GlobalMessage *) cmp)->mut2_local ();
		    break;

		case Msg_WhereAreYou:
		    if (TraceMessage)
			mlog3 ("Exec", ObjectWord (object), cmp);
		    Answer_where_are_you ((GlobalMessage *) cmp, object);
		    continue;

		default:
		    if (TraceMessage)
			mlog3 ("Exec", ObjectWord (object), cmp);
		    fatal ("Execute", "Unknown message: %s", cmp->Print ());
		}
#ifdef PAS_DEBUGGER
		is_enter_break_loop(object,cmp);
		InstructionPointer = (Instruction*)0;
		BREAK_LOOP;
		if (db_cont == QUIT)
		    return;
#endif
		if (TraceMessage)
		    mlog3 ("Exec", ObjectWord (object), cmp);
		InstructionPointer = object->ClassTemplate ()->SearchMethod (cmp);
		if (InstructionPointer == NULL) {
		    cmp->Free ();
		    continue;
		}
#ifdef PAS_DEBUGGER
		if (TraceInstruction || trace_switch || step ){
		    CurrentMessage->TraceSplit ();
		}
#else
		TraceMessageSplit;
#endif
		Execute ();
#ifdef PAS_DEBUGGER
		if (db_cont == QUIT)
		    return;
#endif
#ifdef PAS_DEBUGGER
		if (TraceInstruction || trace_switch || step ){
		    CurrentMessage->TraceClose ();
		}
#else
		TraceMessageClose;
#endif
		cmp->Free ();
		switch (object->Type ()) {
		case READY:
		    if (ScheduleTable.IsDirty () || ++MessageCount > TimeSlice) {
			object->Priority (ScheduleTable.CurrentPriority ());
			if (object->MessageExist ()) {
			    if (MessageCount > TimeSlice)
				ScheduleTable.AppendObject (object);
			    else
				ScheduleTable.Register (object);
			    if (PAS_message_may_be_received) {
				GlobalMessage *message = PAS_receive_in_nonblocking ();
#ifdef PAS_DEBUGGER
				if (global_message_queue) {
				    Receive_SystemMessage (global_message_queue);
				    global_message_queue = (GlobalMessage *) 0;
				}
#endif
				if (message) {
				    Receive_SystemMessage (message);
#ifdef PAS_DEBUGGER
				    message_to_Listener (RECD_MESSAGE);
#endif
				}
			    }
			    goto scheduling;
			}
			goto finish_execution;
		    }
		    break;
		case ERROR:
		case SINK:
		    if (object->LRC () == 0)
			object->Free ();
		    goto scheduling;

		case SLEEPING:
		case SUSPENDED:
		    goto scheduling;

		case CLOSED:
		    pelog (" close");
		default:
		    abort ();
		}
#if 0
		if (PAS_message_may_be_received) {
		    GlobalMessage *message = PAS_receive_in_nonblocking ();
		    if (message) {
			Receive_SystemMessage (message);
		    }
		}
#endif
	    }
    finish_execution:
	    if (object->LRC () == 0) {
		object->doCLOSED ();
		ScheduleTable.AppendObject (object);
	    }
	    else
		object->doSLEEPING ();
	}
    }
}

static void
Execute ()
{
    PushRegisters ();
    CallNextInstruction ();
    PopRegisters ();
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
