/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/stdlib.h"
#include "aum/object.h"
#include "aum/fetch.h"
#include "aum/parallel.h"
#include "aum/globlmsg.h"
#include "aum/sndrcvstats.h"
#include "class/template.h"
#include "class/clink.h"
#include "table/protocol.h"

extern Boolean Always_external_creation;
extern Boolean Odd_external_creation;
extern Boolean Even_external_creation;

METHOD (create_instance, R1D1_OP)
    // {}
    // create_instance Ri, Lc
    // {}
    // [	   address ]
    // [  Ri|	0|	 Lc]
    // {}
    // 󥹥󥹡֥Ȥ Ri Ȥ롥饹
    // ٥ХХȡեå: Lcˤǻꤹ롥֥Ȥ
    // ץ饤ƥϣ˽롥
    // {}
{
    Fetch112 ();
    const ClassInfo *cip = (const ClassInfo *) Indirection (ip->s0);
    Reg[ip->b0] = Create_instance (cip);
    JumpNextInstruction ();
}

METHOD (create_local_instance, R1D1_OP)
    // {}
    // create_local_instance Ri, Lc
    // {}
    // [	   address ]
    // [  Ri|	0|	 Lc]
    // {}
    // {}
    // 󥹥󥹡֥Ȥ Ri Ȥ롥饹
    // ٥ХХȡեå: Lcˤǻꤹ롥֥Ȥ
    // ץ饤ƥϣ˽롥
    // {}
{
    Fetch112 ();
    const ClassInfo *cip = (const ClassInfo *) Indirection (ip->s0);
    Reg[ip->b0] = Create_local_instance (cip);
    JumpNextInstruction ();
}

METHOD (create_instance3, R2D1_OP)
    // {}
    // create_instance3 Ri, Rj, Lc
    // {}
    // [	   address ]
    // [  Ri|  Rj|	 Lc]
    // {}
    // ץåֹ Rj ˥󥹥󥹡֥Ȥ
    //  Ri Ȥ롥饹ϥ٥ХХȡեå: Lcˤǻ
    // ꤹ롥֥ȤΥץ饤ƥϣ˽롥
    // {}
{
    Fetch112 ();

    if (!IsFixnum (Reg[ip->b1]))
	fatal ("create_instance3", "2nd argument must be PE number");

    const ClassInfo *cip = (const ClassInfo *) Indirection (ip->s0);
    Reg[ip->b0] = Create_instance_on_it (cip, Fix2Int (Reg[ip->b1]));
    JumpNextInstruction ();
}

METHOD (create_volatile, R2D1_OP)
    // {}
    // create_volatile Ri, Rj, Lc
    // {}
    // [	   address ]
    // [  Ri|  Rj|	 Lc]
    // {}
    // ܥ饿롦֥Ȥ Ri Ȥ롥饹ϥ
    // ٥ХХȡեå: Lcˤǻꤹ롥ܥ饿롦
    // Ȥϡ㣲ĤΥåȤġǽΥåȤϡü
    // åȤǡܥ饿롦֥Ȥƥ֥Ȥ
    // ɽܤΥåȤϡüåȤǤ Rj Ϳ
    // ޡǼ롥飲ĤΥåȤϡܥ饿륪֥
    // ȤοƻҴ֤̿Ѥ롥֥ȤΥץ饤ƥϣ
    // 롥
    // {}
{
    Fetch112 ();

    if (!Is_MJ_NC (Reg[ip->b1])) {
	fatal ("create_volatile", "2nd argument must be MJ_NC");
    }

    const ClassInfo *cip = (const ClassInfo *) Indirection (ip->s0);
    Word    instance = cip->ClassTemplate ()->MakeInstance (0);

    Object_ptr (instance)->Slot (0, Reg[ip->b1]);
    Object_ptr (instance)->Slot (1, ObjectWord (CurrentObject));
    CurrentObject->LRC_plus (1);

    Reg[ip->b0] = instance;

    JumpNextInstruction ();
}

Word
Create_instance (const ClassInfo * cip)
    // {}
    // ƥե饰ˤꡤɤPE˥֥Ȥ뤫ꤹ롥
    // {}
{
    static int counter;
    Word    instance;
    if (PAS_npe == 1) {
	if (Odd_external_creation) {
	    if (counter++ & 0x1)
		instance = Create_instance_on_it (cip, 0);
	    else
		instance = cip->ClassTemplate ()->MakeInstance (0);
	}
	else {
	    if (Always_external_creation)
		instance = Create_instance_on_it (cip, 0);
	    else
		instance = cip->ClassTemplate ()->MakeInstance (0);
	}
    }
    else {
	if (Odd_external_creation) {
	    if (counter++ & 0x1)
		instance = Create_instance_on_it (cip, 0);
	    else
		instance = cip->ClassTemplate ()->MakeInstance (0);
	}
	u_char	pe = PAS_next_pe ();
	if (Always_external_creation)
	    instance = Create_instance_on_it (cip, pe);
	else {
	    if (pe == PAS_self_peno || ((Even_external_creation && (pe & 1))))
		instance = cip->ClassTemplate ()->MakeInstance (0);
	    else
		instance = Create_instance_on_it (cip, pe);
	}
    }
    return instance;
}

Word
Create_instance_on_it (const ClassInfo * const cip, u_char pe)
    // {}
    // ¾PE˥֥ȤΥåꡤ MJ_W 
    // ֤
    // {}
{
    if (pe >= PAS_npe) {
	fatal ("create instance","No such PE#%d\n",pe);
    }

    GlobalMessage *gm = new_ctl_GlobalMessage (Msg_Create);
    Word    mjw = new_Merger (1);
    int	    index = cip - &ClassInfoTable[0];

    // ϥ饹ơ֥ΥǥåǤ
    gm->set_reply_and_value (MJ_NC_ptr (mjw), index);
    MJ_NC_ptr (mjw)->oTag (MJ_W);
    if (PElog)
	pelog ("Send :%s to PE#%d {%x}", gm->Print (), pe, gm);
    UPDATE_SNDRCV_STATS (pe, create);
    PAS_send (pe, gm);
    return mjw;
}

Word
Create_local_instance (const ClassInfo * const cip)
{
    return cip->ClassTemplate ()->MakeInstance (0);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
