/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include <stdio.h>
#include "aum/stdlib.h"
#include "aum/fetch.h"
#include "aum/object.h"
#include "class/template.h"

#ifdef PAS_DEBUGGER
#include "aum/global.h"
#endif

static const char GET_INLET[] = "get_inlet";
static const char SET_INLET[] = "set_inlet";

static void mlog_get_inlet (const char *, u_short slotno, Word);
static void mlog_set_inlet (const char *, u_short slotno, Word);

static inline void
must_be_inlet (const Word x)
{
    if (Type_of (x) == AUm_Object) {
	switch (Pointer (x)->oTag ()) {
	case MJ_NC:
	case MJ_W:
	case AJ_NC:
	case IMP_INLET:
	    return;
	default:
	    break;
	}
    }
    fatal (SET_INLET, "%s is not a joint", print (x));
}

#ifdef PAS_DEBUGGER
extern void message_to_Listener(debugger_symbol,unsigned char* );
extern int inletslotindex(const ClassTmpl* ctmp,unsigned char* str,Boolean s = TRUE);
extern void is_enter_break_loop_getinlet(Word x,int index,short lab);
extern void is_enter_break_loop_setinlet(Word x,int index,short lab);
#endif

// get_inlet Ri, Vn;
// {}
// [	       address ]
// [  Ri|   0|	     Vn]
// {}
METHOD (get_inlet, R1X1_OP)
    // {}
    // üåȤ򥯥饹⥪եåȤˤ껲Ȥ롥ü
    // Τޤ Ri ˼ü򥨥顼åꥸ祤
    // ǽ.
    // {}
{
    Fetch112 ();
    Word    x = InletSlotBase[ip->s0];
#ifdef PAS_DEBUGGER
    Word*    xadd = InletSlotBase+ip->s0;
    ClassTmpl *ctmpl = CurrentObject->ClassTemplate ();
    int	    index = inletslotindex (ctmpl, (unsigned char *) (CurrentClass->InletSlotName (ip->s0)));
    if ((index >= 0)&&(xadd == (CurrentObject->Slot_address(index)))) {
	is_enter_break_loop_getinlet(x,index,(short)(ip->s0));
	if (next_step){
	    next_step = FALSE;
	}else{
	    if (stop){
		BREAK_LOOP;
	    }
	}
    }
#endif
    if (WordEq (x, UNDEFINLET))
	error (GET_INLET, "Inlet slot \"%s\" is not initialized",
	       CurrentClass->InletSlotName (ip->s0));
    else {
	Reg[ip->b0] = x;
	InletSlotBase[ip->s0] = UNDEFINLET;
	if (TraceMessage)
	    mlog_get_inlet ("Gets", ip->s0, x);
    }
    JumpNextInstruction ();
}

// {}
// set_inlet Ri, Vn;
// {}
// [	       address ]
// [  Ri|   0|	     Vn]
METHOD (set_inlet, R1X1_OP)
    // {}
    // üåȤ򥯥饹⥪եåȤˤ깹롥ü
    // 󥯤˷ҤRi üȤ롥
    // {}
{
    Fetch112 ();
#ifdef PAS_DEBUGGER
    ClassTmpl *ctmpl = CurrentObject->ClassTemplate ();
    int	    index =
    inletslotindex (ctmpl, (unsigned char *) (CurrentClass->InletSlotName (ip->s0)));
    Boolean is_this = FALSE;
#endif
    {
	Word	old = InletSlotBase[ip->s0];
#ifdef PAS_DEBUGGER
	Word*	 oldadd = InletSlotBase+ip->s0;
	if (oldadd == (CurrentObject->Slot_address(index))) is_this = TRUE;
#endif
	if (!IsUndefInlet (old))
	    doConnect (ERROROBJECT, MJ_NC_ptr (old));
    }
    {
	Word	x = Reg[ip->b0];
	must_be_inlet (x);
#ifdef PAS_DEBUGGER
	if ((index >= 0)&&is_this) {
	    is_enter_break_loop_setinlet(x,index,ip->s0);
	    if (next_step){
		next_step = FALSE;
	    }else{
		if (stop){
		    BREAK_LOOP;
		}
	    }
	}
#endif

	InletSlotBase[ip->s0] = x;
	if (TraceMessage)
	    mlog_set_inlet ("Sets", ip->s0, x);
    }
    JumpNextInstruction ();
}

static void
mlog_get_inlet (const char *tag, u_short slotno, Word x)
{
    char    name[BUFSIZ];
    sprintf (name, "%s: @%s", CurrentObject->Printname (),
	     CurrentClass->InletSlotName (slotno));
    mlog4 ("Gets", name, "=> ", print (x));
}

static void
mlog_set_inlet (const char *tag, u_short slotno, Word x)
{
    char    name[BUFSIZ];
    sprintf (name, "%s: @%s", CurrentObject->Printname (),
	     CurrentClass->InletSlotName (slotno));
    mlog4 ("Sets", name, "<= ", print (x));
}


/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
