/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stream.h>
#include "aum/scheduler.h"
#include "aum/global.h"
#include "aum/close.h"
#include "aum/send.h"
#include "aum/trace.h"
#include "aum/tstream.h"
#include "aum/parallel.h"
#include "aum/printstack.h"
#include "aum/builtin.h"
#include "aum/string.h"
#include "aum/vector.h"
#include "aum/error.h"
#include "table/atomhash.h"
#include "table/protocol.h"
#include "class/template.h"
#include "class/clink.h"

extern void Initialize_Memory ();
extern void Initialize_AtomTable (int size);
extern void Initialize_ProtocolID (int size);
extern void Initialize_NameList (const char *);

extern void Initialize_merger_memory ();
extern void Initialize_ExportTable (int size);
extern void Initialize_ImportTable (int size);
extern void End_ExportTable ();
extern void End_ImportTable ();

extern void Initialize_Trace ();
extern void Initialize_TraceStream ();

#ifdef PAS_DEBUGGER
extern void End_AtomTable ();
extern void End_ProtocolID ();
extern void End_TraceStream ();
extern void End_ClassInfo ();
extern void deallocate_table ();
//extern void End_Trace ();
#endif

static Word initArgs (int argc, const char **argv);

void
Initialize_shared (int s_atom, int s_protocol)
{
    Initialize_Memory ();
    Initialize_AtomTable (s_atom);
    Initialize_ProtocolID (s_protocol);
    Initialize_Trace ();
    Initialize_TraceStream ();

    NILATOM = InternAtom ("[]");
    PLUS_ATOM = InternAtom ("+");
    MINUS_ATOM = InternAtom ("-");
    ASTERISK_ATOM = InternAtom ("*");
    SLASH_ATOM = InternAtom ("/");
    INSTANTIATED_ATOM = InternAtom ("instantiated");
    AUM_ATOM = InternAtom ("aum");

    ClassNameInteger = InternAtom ("integer");
    ClassNameSFloat = InternAtom ("single_float");
    ClassNameAtom = InternAtom ("symbol");
    ClassNameBool = InternAtom ("boolean");
    ClassNameList = InternAtom ("cons");
    ClassNameString = InternAtom ("string");
    ClassNameVector = InternAtom ("vector");
    ClassNameDFloat = InternAtom ("double_float");
    ClassNameClass = InternAtom ("class");
    ClassNameMessage = InternAtom ("message");
    ClassNameForeign = InternAtom ("foreign");
    ClassNameFileStream = InternAtom ("file_stream");

#ifdef UNION_TYPE
    SINK = _make_sobject_ (0);
    UNDEFOUTLET = _make_sobject_ (1);
    UNDEFINLET = _make_sobject_ (2);
    BOOLTRUE = _make_bool_ (0);
    BOOLFALSE = _make_bool_ (1);
    NISMSG = NormalMessage ((class LocalMessage *) 0);
#endif

    PAS_initialize_shared ();
    PrintStack.Initialize (256, 0);

    if (NameList_load_p)
	Initialize_NameList (Program_filename);
}

#ifdef PAS_DEBUGGER
void
End_shared ()
{
    End_AtomTable ();
    End_ProtocolID ();
    End_TraceStream ();
    End_ClassInfo ();
}

Boolean
ableToSendGo ()
{
    if (PAS_self_peno != 0)
	return TRUE;
    Boolean created;
    ClassInfo *initClass = Intern_class_info ("aum", created);

    if (!initClass) {
	cerr << "Error: I can't find the initial class \"aum\".\n";
	cerr << "Error: You must define it.\n";
	return FALSE;
    }

    Word    initObject = initClass->ClassTemplate ()->MakeInstance (0);

    //go (+)
	ProtocolID pid = intern_pid ("go", 1, 0x1);
    Message *initMessage = (Message *) CreateMessage (1, pid);
    Word    arg = initArgs (Argc, Argv);
    initMessage->Argv (0, arg);
    doSend (initObject, initMessage);
    doClose (initObject);

    return TRUE;
}

Boolean
Initialize_private (int s_export, int s_import)
{
    Initialize_merger_memory ();
    Initialize_ExportTable (s_export);
    Initialize_ImportTable (s_import);

    PAS_initialize_private ();
    return TRUE;
}
#else
Boolean
Initialize_private (int s_export, int s_import)
{
    Initialize_merger_memory ();
    Initialize_ExportTable (s_export);
    Initialize_ImportTable (s_import);

    PAS_initialize_private ();

    if (PAS_self_peno != 0) {
	return TRUE;
    }

    Boolean created;
    ClassInfo *initClass = Intern_class_info ("aum", created);

    if (!initClass) {
	cerr << "Error: I can't find the initial class \"aum\".\n";
	cerr << "Error: You must define it.\n";
	return FALSE;
    }

    Word    initObject = initClass->ClassTemplate ()->MakeInstance (0);

    //go (+)
	ProtocolID pid = intern_pid ("go", 1, 0x1);
    Message *initMessage = (Message *) CreateMessage (1, pid);
    Word    arg = initArgs (Argc, Argv);
    initMessage->Argv (0, arg);
    doSend (initObject, initMessage);
    doClose (initObject);

    return TRUE;
}
#endif

void
End_private ()
{
    End_ImportTable ();
    End_ExportTable ();
}

static Word
initArgs (int argc, const char **argv)
{
    Word    init = CreateVector (argc, INT0);
    for (int n = 0; n < argc; n++) {
	Word	x = CreateASCIIString (argv[n]);
	VectorObject_ptr (init)->SetElement (n, x, 'o');
    }
    return init;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
