/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/error.h"
#include "aum/mj-imp.h"
#include "aum/mj-nc.h"
#include "aum/connect.h"
#include "aum/globlmsg.h"
#include "aum/merger.h"
#include "aum/trace.h"


MJ_W_t *
MJ_IMP_OUTLET_t::Send (Message * msg)
    // {}
    // WhereAreYou()  Close(Х뻲ȥ)å
    // ǥåƱžåĹ +2
    // (CtrlInfo)Ȥʤ롥IMP_OUTLET Ǥä祤Ȥ MJ_W Ȥʤ뤬
    // ϤȤƻȤäƤΰå奦˻ѤΤ
    // ɬפ롥
    // {}
{
    GlobalMessage *gm = msg->mut2_where_close ((J_NC_t *) this, this);
    send_to_other_pe (gid, gm);
    return mut2_MJ_W ();
}

void
MJ_IMP_OUTLET_t::Connect (Header * head)
    // {}
    // ͢줿 OUTLET ȥ祤Ȥ³롥
    // {}
{
    switch (head->Type ()) {
    case MJ_NC:
	Connect_with_MJ_NC ((MJ_NC_t *) head);
	return;

    case AJ_NC:
	Connect_with_AJ_NC ((AJ_NC_t *) head);
	return;

    case IMP_INLET:
	Connect_with_IMP_INLET ((MJ_IMP_INLET_t *) head);
	return;

    case MJ_C:
    case AJ_C:
    case MJ_W:
    case IMP_OBJ:
    case IMP_OBJ_NT:
    case IMP_OUTLET:
	connect_arg_already_connected (ObjectWord (this), head);
	return;

    default:
	connect_arg_not_joint (ObjectWord (this), head);
    }
}

void
MJ_IMP_OUTLET_t::Connect_with_MJ_NC (MJ_NC_t * head)
    // {}
    // connectη
    // (1) this.ref_count == 0 && head.ref_count == 0
    //	  (a) head˥å
    //	    (i) å2İʾ夢
    //		    [ǽΥå & WhereAreYou & Close]
    //		    (WhereAreYouΰhead!)
    //		    this
    //	    (ii) å1Ĥʤ
    //		    [ǽΥå & Close]
    //		    head, this Ȥ˲
    //	  (b) head˥åʤ
    //		    [Close]
    //		    head,thisȤ˲
    // (2) this.ref_count > 0  && head.ref_count == 0
    //	  (a) head˥å
    //		    [ǽΥå & WhereAreYou & Close]
    //		    (WhereAreYouΰthis!)
    //		    headΥåžơhead
    //	  (b) head˥åʤ
    //		    [WhereAreYou & Close]
    //		    (WhereAreYouΰthis!)
    //		    head
    // (3) this.ref_count == 1 && head.ref_count > 1
    //	  (a) head˥å
    //		    [ǽΥå & WhereAreYou & Close]
    //		    (WhereAreYouΰhead!)
    //		    this
    //	  (b) head˥åʤ
    //		    [WhereAreYou & Close]
    //		    (WhereAreYou˰head!)
    //		    this
    // (4) this.ref_count > 1  && head.ref_count > 1
    //	  (a) head˥å
    //		    [ǽΥå & WhereAreYou & Close]
    //		    (WhereAreYouΰthis!)
    //		    ĤΥåthisž롥
    //		    headΥMJ_C
    //	  (b) head˥åʤ
    //		    [WhereAreYou & Close]
    //		    (WhereAreYouΰthis!)
    //		    headΥMJ_C
    // {}
{
    if (--head->LRC () == 0) {

	// headλȲ0Ǥ롥

	if (--h.lrc == 0) {

	    // ξλȲȤʤä

	    if (head->MessageExist () == TRUE) {
		Message *msg = head->PopMessage ();
		if (head->MessageExist () == TRUE) {
		    MJ_NC_t save = *head;
		    Send_with_where_are_you_and_dismiss (msg, head);
		    head->Join (&save);
		}
		else {
		    Send_with_dismiss (msg);
		    head->Free ();
		}
	    }
	    else {
		Send_dismiss ();
		head->Free ();
	    }
	    Free ();
	}
	else {

	    // head λȲ 0 Ȥʤäthis λȲ 0 
	    // Ϥʤ

	    if (head->MessageExist () == TRUE) {
		Message *msg = head->PopMessage ();
		MJ_W_t *mjw =
		Send_with_where_are_you_and_dismiss (msg, (J_NC_t *) this);
		mjw->Join (head);
		if (TraceMessage)
		    mlog2 ("Recv", ObjectWord (head));
	    }
	    else {
		Send_where_are_you_and_dismiss ((J_NC_t *) this);
	    }
	    head->Free ();
	}
    }
    else {

	// headλȲ0ǤϤʤ

	if (h.lrc == 1) {

	    // headλȲ0ǤʤthisλȲ1Ǥ롥¨
	    // ³headʳϻȤʤäơthisϺ

	    if (head->MessageExist () == TRUE) {
		Message *msg = head->PopMessage ();
		MJ_NC_t save = *head;
		Send_with_where_are_you_and_dismiss (msg, head);
		head->Join (&save);
	    }
	    else {
		Send_where_are_you_and_dismiss (head);
	    }
	    Free ();
	}
	else {

	    // headλȲthisλȲ0ǤϤʤ

	    if (head->MessageExist () == TRUE) {
		Message *msg = head->PopMessage ();
		MJ_W_t *mjw
		    = Send_with_where_are_you_and_dismiss (msg, (J_NC_t *) this);
		mjw->Join (head);
		if (TraceMessage)
		    mlog2 ("Recv", ObjectWord (head));
	    }
	    else {
		Send_where_are_you_and_dismiss ((J_NC_t *) this);
	    }
	    head->mut2_MJ_C (ObjectWord (this));
	}
    }
}

void
MJ_IMP_OUTLET_t::Connect_with_AJ_NC (AJ_NC_t * head)
    // {}

    // ͢ OUTLET ˥ڥ³롥ڥå
    // Ƥ硤ƤΥåPE֥Ȥž롥³
    // ̡ڥλȲȤʤä顤ڥݻ른
    // Ȥʬ³롥Ǹ˥ڥΰ롥
    // ڥλȲˤʤʤäϥڥɤ³줿
    // ڥˤ롥

    // {}
{
    Word mj = new_Merger (2);
    doConnect (mj, (J_NC_t*) head);
    Connect ((Header*) Object_ptr (mj));
}

void
MJ_IMP_OUTLET_t::Connect_with_IMP_INLET (MJ_IMP_INLET_t * head)
    // {}
    // ͢ OUTLET  ͢ INLET ³롥
    // {}
    // Connect η̡͢Ƥ OUTLET λȥȤȤʤä
    // ˤϡ[WhereAreYou & Close]head, thisȤ˲
    // 롥where_are_you ΰϡ͢ INLET ΰǤ롥close
    // ΰ͢ OUTLET γȲǤ롥
    // {}
    // ͢ OUTLET λȲʳξˤϡ͢Ƥ
    // INLET  where_are_you å ͢ OUTLET 
    // 롥(͢줿 OUTLET  where_are_you å
    // ϼºݤ˥åʤޤʤȤȤ)
    // {}
{
    GlobalMessage *gm = head->mut2_where_are_you ();

    if (--h.lrc == 0) {
	gm->mTag (Msg_WhereAreYou_Close);
	gm->set_dismiss (this);
	send_to_other_pe (gid, gm);
	Free ();
    }
    else {
	send_to_other_pe (gid, gm);
    }
}

MJ_W_t *
MJ_IMP_OUTLET_t::Send_with_where_are_you_and_dismiss (Message * msg, J_NC_t * reply)
    // {}
    // å where_are_you ղä롥å
    // åǤˤϡPE ƳåѴ
    // 롥ååǡ where_are_you 
    // ǤˤϡĤ where_are_you 뤳ȤϤǤʤ
    // Τǡʬ򿷤̤ΥåȤƼФ
    // ФåϰͿ reply Υå塼
    // Ƭ˷ҤǤwhere_are_you ͤǤϡϡ
    // reply ͢ɽϿ GID Ǥ롥reply ʬ
    // (this)Ʊ礬뤫顤MJ_W ˤʤɬפʾ(gid)
    // ФƤɬפ롥
    // {}
{
    GlobalMessage *gm;
    const GlobalID dest = gid;
    MJ_W_t *mjw;

    switch (msg->Tag ()) {
    case Msg_Atomic:
    case Msg_Private_Args:
    case Msg_Shared_Args:
    case Msg_Close:
	gm = msg->mut2_ctl_gm (Msg_WhereAreYou_Close);
	gm->set_reply_and_dismiss (reply, this);
	mjw = reply->mut2_MJ_W ();
	break;

    case Msg_WhereAreYou:
    case Msg_WhereAreYou_Close:
	GlobalMessage * wru = ((GlobalMessage *) msg)->dissolve_ctl_message ();
	gm = msg->mut2_ctl_gm (Msg_WhereAreYou_Close);
	gm->set_reply_and_dismiss (reply, this);
	mjw = reply->mut2_MJ_W ();
	mjw->PrependMessage (wru);
	break;

    default:
	abort ();
    }
    send_to_other_pe (dest, gm);
    return mjw;
}

void
MJ_IMP_OUTLET_t::Send_with_dismiss (Message * msg)
    // {}
    // åȤȤˡ͢Ϥĺ롥ݻ
    // Ƥ¾УŤ Ȳ GRC 򸺤åղä롥
    // åǤˤϡPE Ƴå 
    // 
    // {}
{
    GlobalMessage *gm;

    switch (msg->mTag ()) {
    case Msg_Atomic:
    case Msg_Private_Args:
    case Msg_Shared_Args:
	gm = msg->mut2_ctl_gm (Msg_Close);
	gm->set_dismiss (this);
	break;

    case Msg_WhereAreYou:
	((GlobalMessage *) msg)->Dismiss (0);
    case Msg_WhereAreYou_Close:
	gm = (GlobalMessage *) msg;
	gm->mTag (Msg_WhereAreYou_Close);
	gm->Dismiss (gm->Dismiss () + ImportTable->Delete (this));
	break;

    case Msg_Close:
	gm = (GlobalMessage *) msg;
	gm->Dismiss (gm->Dismiss () + ImportTable->Delete (this));
	break;

    case Msg_IamHere_GRC:
    case Msg_Iam:
    case Msg_Create:
    default:
	gm = (GlobalMessage *) msg;
	send_to_other_pe (gid, gm);
	Send_dismiss ();
	return;
    }
    send_to_other_pe (gid, gm);
}

MJ_W_t *
MJ_IMP_OUTLET_t::Send_where_are_you_and_dismiss (J_NC_t * reply)
    // {}
    //  reply Ȥ where_are_you å롥
    // where_are_you å뤳ȤˤꡤݻƤ¾УŤ
    // Ȳ GRC 򸺤åղä롥
    // {}
{
    GlobalMessage *gm = new_ctl_GlobalMessage (Msg_WhereAreYou_Close);
    gm->set_reply_and_dismiss (reply, this);
    send_to_other_pe (gid, gm);
    return reply->mut2_MJ_W ();
}

void
MJ_IMP_OUTLET_t::Send_dismiss ()
    // {}
    // ݻƤ¾УŤγȲ GRC 򸺤å롥
    // {}
{
    GlobalMessage *gm = new_ctl_GlobalMessage (Msg_Close);
    gm->set_dismiss (this);
    send_to_other_pe (gid, gm);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
