/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/mj-imp.h"
#include "aum/mj-nc.h"
#include "aum/aj-nc.h"
#include "aum/connect.h"
#include "aum/globlmsg.h"


void
MJ_IMP_OBJ_t::Send (Message * mp)
    // {}
    // ͢Ƥ륪֥Ȥ˥å롥
    // {}
{
    send_to_other_pe (gid, mp->mut2_global_message ());
}

void
MJ_IMP_OBJ_t::Connect (Header * head)
    // {}
    // ͢줿֥Ȥȥ祤Ȥ³롥
    // {}
{
    switch (head->Type ()) {
    case MJ_NC:
	Connect_with_MJ_NC ((MJ_NC_t *) head);
	return;

    case AJ_NC:
	Connect_with_AJ_NC ((AJ_NC_t *) head);
	return;

    case IMP_INLET:
	Connect_with_IMP_INLET ((MJ_IMP_INLET_t *) head);
	return;

    case MJ_C:
    case AJ_C:
    case MJ_W:
    case IMP_OBJ:
    case IMP_OBJ_NT:
    case IMP_OUTLET:
	connect_arg_already_connected (ObjectWord (this), head);
	return;

    default:
	connect_arg_not_joint (ObjectWord (this), head);
    }
}

void
MJ_IMP_OBJ_t::Connect_with_MJ_NC (MJ_NC_t * head)
    // {}
    // ͢줿֥Ȥ˥祤Ȥ³롥祤Ȥ
    // äƤ硤ƤΥåPE֥Ȥ
    // 롥³η̡祤¤Ӥ˼ʬȤλȲȤʤä
    // ̿ϩĺ롥ǸˡʬȤλȲξΰ
    // 롥
    // {}
{
    if (--head->LRC () == 0) {
	if (--h.lrc == 0) {
	    if (head->MessageExist () == TRUE)
		head->Send_with_dismiss (this);
	    Free ();
	}
	else if (head->MessageExist () == TRUE)
	    head->Send (this);
	head->Free ();
    }
    else {
	if (head->MessageExist () == TRUE)
	    head->Send (this);
	head->mut2_MJ_C (ObjectWord (this));
    }
}

void
MJ_IMP_OBJ_t::Connect_with_AJ_NC (AJ_NC_t * head)
    // {}
    // ͢줿֥Ȥ˥ڥ³롥ڥå
    // äƤ硤ƤΥåPE֥Ȥž
    // 롥³η̡ڥλȲȤʤä顤ڥ
    // 른祤Ȥʬ³롥Ǹ˥ڥΰ
    // 롥ڥλȲˤʤʤäϥڥɤ
    // ³줿ڥˤ롥
    // {}
{
    if (head->MessageExist () == TRUE)
	head->Send (this);
    Word self = ObjectWord (this);
    if (--head->LRC () == 0) {
	doConnect (self, head->Next_joint ());
	head->Free ();
    }
    else
	head->mut2_AJ_C (self);
}

void
MJ_IMP_OBJ_t::Connect_with_IMP_INLET (MJ_IMP_INLET_t * head)
    // {}
    // ͢ OBJECT  ͢ INLET ³롥
    // {}
    // Connect η̡͢Ƥ OBJECT λȥȤȤʤä
    // ˤϡ[WhereAreYou & Close]head, thisȤ˲
    // 롥where_are_you ΰϡ͢ INLET ΰǤ롥close
    // ΰ͢ OBJECT γȲǤ롥
    // {}
    // ͢ OBJECT λȲʳξˤϡ͢Ƥ
    // INLET  where_are_you å ͢ OBJECT 
    // 롥
    // {}
    // IMP_OBJ_NT Ȥΰ㤤ϡǤ˥åƤˤϡ
    // åݾڤ뤿ˡľ¾PE˥ɥ쥹
    // ȤϤǤʤȤǤ롥
    // {}
{
    GlobalMessage *gm = head->mut2_where_are_you ();

    if (--h.lrc == 0) {
	gm->mTag (Msg_WhereAreYou_Close);
	gm->set_dismiss (this);
	send_to_other_pe (gid, gm);
	Free ();
    }
    else {
	send_to_other_pe (gid, gm);
    }
}

void
MJ_IMP_OBJ_t::Answer_where_are_you (GlobalMessage * gm)
    // {}
    // å֤ݾڤ뤿ˡֻ򤳤λǤ뤳
    // ϤǤʤä where_are_you å򤽤Τޤޤ롥
    // {}
{
    assert (gm->mTag () == Msg_WhereAreYou);
    send_to_other_pe (gid, gm);
}

void
MJ_IMP_OBJ_t::Close_and_answer_where_are_you (GlobalMessage * gm)
    // {}
    // ͢ɽƸƤФ뤳Ȥꤹ롥ǽȲ
    //  -1 롥̤Ȥ LRC == 0 ʤС͢ɽκԤ
    // ǤʤСAnswer_where_are_you (gm) ƤӽФ͢
    // ɽκϼΤ褦ˤƹԤʤǽ͢ɽγȲ
    // Ĵ٤롥줬ĤΥå³ۤƤʤС
    // ۤƤʬ rest ȤݻĺåȤ͢и
    // 롥ˡwhere_are_you å where_are_you and
    // close åѹơĺѤγȲդä롥
    // {}
{
    assert (gm->mTag () == Msg_WhereAreYou);
    if (--LRC () == 0) {
	u_long	grc = (u_long) ImportTable->Delete (this);

	if (grc > (1 << WEIGHT)) {
	    u_long  rest = grc - (1 << WEIGHT);
	    grc = (1 << WEIGHT);
	    send_to_other_pe (gid, new_Close (rest));
	}

	gm->mTag (Msg_WhereAreYou_Close);
	gm->Dismiss (grc);
	send_to_other_pe (gid, gm);

	Free ();
    }
    else
	Answer_where_are_you (gm);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
