/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/mj-imp.h"
#include "aum/object.h"
#include "aum/globlmsg.h"
#include "aum/trace.h"
#include "table/import.h"
#include "table/export.h"

#ifdef PAS_DEBUGGER
extern Boolean trace_switch;
#endif

GlobalMessage*
MJ_IMP_INLET_t::mut2_where_are_you()
    // {}
    // ͢Ƥ INLET ĺ(gid) where_are_you 
    // 롥ϡINLET ͢κŬ򤷤ʤäξ
    // 롥ʤwhere_are_you å褿
    // Ʊˤ롥͢ɽγȲ̵뤹ΤϤλ
    // ȲǤꡤ IamHere 껦뤫Ǥ롥
    // {}
{
    assert (h.lrc == 1);
    ImportTable->Delete(this);
    GlobalMessage* gm = new_WhereAreYou (gid);
#ifdef PAS_DEBUGGER
    if ((!TraceInstruction)&&(!trace_switch))
	Free();
#else
    if (!TraceInstruction)
	Free();
#endif
    else
	tag = TRACE_INLET;
    return gm;
}

void
MJ_IMP_INLET_t::Return_I_am_here(const GlobalID& iamhere, u_long grc)
    // {}
    // ͢Ƥ INLET ĺIamHere å֤⤷
    // grc ٤³ۤƤʤСγȲʬ
    // ĺåȤ͢и iamhere ֤
    // {}
{
    assert (h.lrc == 1);
    assert (grc != 0);
    ImportTable->Delete(this);
    if (grc > (1<<WEIGHT)) {
	u_long rest = grc - (1<<WEIGHT);
	grc = (1<<WEIGHT);
	send_to_other_pe (iamhere, new_Close (rest));
    }
    GlobalMessage* gm = new_IamHere_GRC (iamhere, grc);
    send_to_other_pe (gid, gm);
#ifdef PAS_DEBUGGER
    if ((!TraceInstruction)&&(!trace_switch))
	Free();
#else
    if (!TraceInstruction)
	Free();
#endif
    else
	tag = TRACE_INLET;
}

void
MJ_IMP_INLET_t::Forward_IamHere_GRC (Header *const ptr)
    // {}
    // Iam å͢иͤ롥
    // {}
{
    assert (h.lrc == 1);
    ImportTable->Delete(this);
    const GlobalID iamhere = ExportTable->Register(ptr, WEIGHT);
    GlobalMessage *const gm = new_IamHere_GRC (iamhere, WEIGHT_of_IamHere);
    send_to_other_pe(gid, gm);
#ifdef PAS_DEBUGGER
    if ((!TraceInstruction)&&(!trace_switch))
	Free();
#else
    if (!TraceInstruction)
	Free();
#endif
    else
	tag = TRACE_INLET;
}

void
MJ_IMP_INLET_t::ExecuteMessage(Word atomic)
    // {}
    // Iam å͢иͤ롥
    // {}
{
    assert (h.lrc == 1);
    ImportTable->Delete(this);
    GlobalMessage* gm = new_Iam(atomic);
    send_to_other_pe(gid, gm);
#ifdef PAS_DEBUGGER
    if ((!TraceInstruction)&&(!trace_switch))
	Free();
#else
    if (!TraceInstruction)
	Free();
#endif
    else
	tag = TRACE_INLET;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
