/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/error.h"
#include "aum/stdlib.h"
#include "aum/globlmsg.h"
#include "aum/tstream.h"
#include "aum/allocmsg.h"
#include "aum/execbmsg.h"
#include "aum/object.h"

GlobalMessage *
new_GlobalMessage (MessageTag tag, u_char arity, const ProtocolID & pid)
    // {}
    // ΰݤƳå롥å
    //  tag, ο arity, ƥץȥɣĤ pid ˽
    // 롥 GID ӥåΰϽʤ
    // {}
{
    int	    nbytes = sizeof (GlobalMessage) - sizeof (Word);
    switch (tag) {
    case Msg_Shared_Args:
#ifdef PAS_DEBUGGER
    case Msg_Debugger:
#endif
	nbytes += arity * sizeof (Word);
	break;

    case Msg_Close:
    case Msg_WhereAreYou_Close:
    case Msg_WhereAreYou:
    case Msg_IamHere_GRC:
    case Msg_Iam:
    case Msg_Create:
	nbytes += (arity + 2) * sizeof (Word);
	break;

    default:
	abort ();
    }
    GlobalMessage *gm = (GlobalMessage *) MESSAGE_ALLOC (nbytes);
    gm->Initialize (tag, arity, nbytes, pid);
    return gm;
}

GlobalMessage *
new_ctl_GlobalMessage (MessageTag mtag)
    // {}
    // ΰݤΤߤγå롥
    // {}
{
    ProtocolID pid = PID_CTL_GM;
    GlobalMessage *gm = new_GlobalMessage (mtag, 0, pid);
    return gm;
}

GlobalMessage *
new_Iam (Word atomic)
    // {}
    // WhereAreYou åͤȤƤ Iam å롥
    //  atomic ϸϥ֥ȤΤߤ롥
    // {}
{
    assert (Type_of (atomic) != AUm_Object);
    GlobalMessage *gm = new_ctl_GlobalMessage (Msg_Iam);
    gm->set_CtlInfo (*(GlobalID *) & atomic, 0);
    return gm;
}

GlobalMessage *
new_IamHere_GRC (const GlobalID & gid, u_long grc)
    // {}
    //  IamHere_GRC åΰݤ֥
    // gid  Ȳ grc ꤷå֡
    // {}
{
    GlobalMessage *gm = new_ctl_GlobalMessage (Msg_IamHere_GRC);
    gm->set_CtlInfo (gid, grc);
    return gm;
}

GlobalMessage *
new_WhereAreYou (const GlobalID & gid)
    // {}
    //  WhereAreYou åΰݤϤ gid 
    // å֤
    // {}
{
    GlobalMessage *gm = new_ctl_GlobalMessage (Msg_WhereAreYou);
    gm->set_CtlInfo (gid, 0);
    return gm;
}

GlobalMessage *
new_Close (u_long grc)
    // {}
    //  Close åΰݤȲ grc Ȥ
    // å֤
    // {}
{
    GlobalMessage *gm = new_ctl_GlobalMessage (Msg_Close);
    gm->set_CtlInfo (0, grc);
    return gm;
}

GlobalMessage *
GlobalMessage::dissolve_ctl_message ()
    // {}
    // դåФ
    // ĳåꤽ֤Υåʼʬȡ
    // ϥΤߤѹѹϹԤʤʤޤĤ
    // Фդååơ֥Ͽ
    // 롥
    // {}
{
    GlobalID gid;
    u_long  grc;

    get_CtlInfo (gid, grc);

    GlobalMessage *wru = new_ctl_GlobalMessage (Tag ());
    wru->set_CtlInfo (gid, grc);
    // GlobalMessageTable->Register(wru);

    tag = Arity () == 0 ? Msg_Atomic : Msg_Shared_Args;
    return wru;
}


Name
GlobalMessage::print_ctl_message ()
    // {}
    // ѤΥåΰɽ֤
    // {}
{
    GlobalID a;
    u_long  b;
    get_CtlInfo (a, b);

    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    switch (mTag ()) {
    default:
	tout << "*no control message*";
	break;
    case Msg_WhereAreYou:
	tout.form ("%%wru (%s)", a.Print ());
	break;
    case Msg_Close:
	tout.form ("%%close (%d)", b);
	break;
    case Msg_WhereAreYou_Close:
	tout.form ("%%wru and close (%s,%d)", a.Print (), b);
	break;
    case Msg_IamHere_GRC:
	tout.form ("%%I am here (%s,%d)", a.Print (), b);
	break;
    case Msg_Iam:
	{
	    Word    x = a;
	    tout.form ("%%I am (%s)", print (x));
	}
	break;
    case Msg_Copy:
	tout.form ("%%copy (%d,%s)",
		   no_of_bytes (), name_of_object_tag (ObjectTag (argv[0])));
	break;
    case Msg_Create:
	tout.form ("%%create (%s,%d)", a.Print (), b);
	break;
    }
    if (pid != PID_CTL_GM) {
	MessageTag mtag = mTag ();
	if (pid.Type () == PT_Compound)
	    mTag (Msg_Shared_Args);
	else
	    mTag (Msg_Atomic);
	tout << ":" << Print ();
	mTag (mtag);
    }
    return tout.Result ();
}

// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//

GlobalMessage *
Message::mut2_ctl_gm (MessageTag mtag)
    // {}
    // åդåѴ롥
    // դåʤСѹǤ롥
    // ʤåʤСդå
    // ݤơåƤ򤽤˥ԡ롥å
    // ʤ(Msg_Global)ˤϡʬȤإԡ򤹤롥ü
    // Ρʥ٥Ȥˤλν copy_from() Ǥ롥
    // {}
{
    GlobalMessage *gm;

    switch (mTag ()) {
    case Msg_Atomic:
	gm = new_GlobalMessage (mtag, 0, pid);
	Free ();
	return gm;
    case Msg_Private_Args:
	int	local_size =
	(Arity () - 1) * sizeof (Word) + sizeof (GlobalMessage);
	if (local_size == no_of_bytes ()) {
	    gm = new_GlobalMessage (mtag, Arity (), pid);
	    gm = gm->Copyfrom ((LocalMessage *) this);
	    Free ();
	    return gm;
	}
	if (local_size + 2 * sizeof (Word) == no_of_bytes ()) {
	    gm = ((GlobalMessage *) this)->Copyfrom ((LocalMessage *) this);
	    gm->mTag (mtag);
	    return gm;
	}
	abort ();

    default:
	mTag (mtag);
	return (GlobalMessage *) this;
    }
}

GlobalMessage *
Message::mut2_global_message ()
    // {}
    // åѴ롥(դ)åʤ
    // С⤷ʤåξˤϡå
    // ΰݤơåƤ򤽤˥ԡ롥
    // {}
{
    switch (mTag ()) {
    case Msg_Private_Args:
	GlobalMessage * gm = (GlobalMessage *) this;
	gm = gm->Copyfrom ((LocalMessage *) gm);
	gm->mTag (Msg_Shared_Args);
	return gm;

    default:
	return (GlobalMessage *) this;
    }
}

GlobalMessage *
Message::mut2_where_close (J_NC_t * where, MJ_IMP_t * close)
    // {}
    // åդåѴ롥
    // դåʤСѹǤ롥
    // ʤåʤСդå
    // ݤơåƤ򤽤˥ԡ롥
    // {}
{
    GlobalMessage *gm = mut2_ctl_gm (Msg_WhereAreYou_Close);
    gm->set_reply_and_dismiss (where, close);
    return gm;
}

void
ExecuteGlobalMessage (Word dest, GlobalMessage * gm)
    // {}
    // åȹ֥ȤϤƤФ롥dest ȹ
    // ֥ȤǤʤƤϤʤʤåĤʤС
    // åѴ롥åΰ ExecuteBuiltin-
    // Message ǲ롥
    // {}
{
    assert (IsUserObject (dest) == FALSE);
    Message *lm;
    if (gm->PID ().Type () == PT_Compound) {
	lm = ((GlobalMessage *) gm)->mut2_local ();
    }
    else {
	gm->mTag (Msg_Atomic);
	lm = gm;
    }
    // if (TraceInstruction) lm->TraceSplit();

    ExecuteBuiltinMessage (dest, lm);
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

GlobalMessage*
new_Iam_copy (ObjectTag t, void* ptr, int nbytes)
{
    int total_nbytes = nbytes + MIN_MESSAGE_SIZE + sizeof (Word);
    assert (total_nbytes <= 0xFFFF);
    GlobalMessage *gm = (GlobalMessage *) MESSAGE_ALLOC (total_nbytes);

    gm->MessageLink::Initialize (Msg_Copy, 0, total_nbytes);
    gm->gid = 0;
    gm->pid = PID_CTL_GM;
    gm->argv[0] = Word (t);
    memcpy (&gm->argv[1], ptr, nbytes);
    return gm;
}

Word
new_object_from_Iam_copy (const GlobalMessage* mp)
{
    ObjectTag t = (ObjectTag) mp->argv[0];
    int nbytes = mp->no_of_bytes () - MIN_MESSAGE_SIZE - sizeof (Word);
    void* ptr = SHARED_ALLOC (nbytes);
    memcpy (ptr, &mp->argv[1], nbytes);
    Word x = ObjectWord (ptr);
    Pointer (x)->Initialize (t, 1);
    return x;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
