/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
// globalid.c

#include "aum/stdlib.h"
#include "aum/globalid.h"
#include "aum/tstream.h"
#include "aum/trace.h"
#include "table/export.h"

extern ExportTableClass* ExportTable;

GlobalID::GlobalID(Word word, GidHintBit hint, u_char weight = 0)
{
#ifndef NDEBUG
    if (IsPointer(word) == FALSE) abort();
#endif
    Pointer(word)->LRC_plus(-1);
    gid = ExportTable->Register(Pointer(word), weight) | hint | GID_Pointer;
}

GlobalID GlobalID::Tagging(GidHintBit hint, u_long wrc)
{
    register u_long x = 0;
    while (wrc >>= 1)
	x += (1<<GID_WRC_SHIFT_WIDTH);
    return (gid & GID_ADDRESS_MASK) | x | hint | GID_Pointer;
}

Name GlobalID::Print() const
{
    switch (Tag()) {
    case GID_Atom:
    case GID_Fixnum:
    case GID_Constant:
	return print(Word(gid));

    case GID_Pointer:
	break;
    }
    char tem[BUFSIZ];
    tstream tout = tstream(BUFSIZ, tem);
    tout.form("#%d[%d]", PE(), Index());
    if (ShowRC) tout.form("*%d", WRC() >> GID_WRC_SHIFT_WIDTH);
    return tout.Result();
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
