/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#define GLOBAL_VARIABLE

#include "aum.h"
#include "aum/merger.h"
#include "aum/split.h"
#include "aum/aj-c.h"

Word _make_sfloat_(float x)
{
    int* p = (int*) &x;
    return Word(((*p) & ~7) + int(AUm_SFloat));
}

#ifdef	UNION_TYPE

Word	INT0;
Word	SINK;
Word	UNDEFOUTLET;
Word	UNDEFINLET;
Word	BOOLTRUE;
Word	BOOLFALSE;
Word	TempWord;

LocalMessage*	NILMSG;
LocalMessage*	TempMessage;

Bool _wordeq_(Word x, Word y)
{
    return x.ival == y.ival ? TRUE : FALSE;
}

Bool _msgeq_(LocalMessage* x, LocalMessage* y)
{
    return x.ival == y.ival ? TRUE : FALSE;
}

Word _make_word_ptr_(void* x, AUm_Type t)
{
    TempWord.t2.tag = t;
    TempWord.t2.val = (int)x;
    return TempWord;
}

Word _make_fixnum_(int x)
{
    TempWord.t3.tag = AUm_Fixnum;
    TempWord.t3.val = x;
    return TempWord;
}

Word _make_atom_(unsigned x)
{
    TempWord.t5.tag = AUm_Atom;
    TempWord.t5.val = x;
    return TempWord;
}

Word _make_bool_(unsigned x)
{
    TempWord.t6.tag = AUm_Bool;
    TempWord.t6.val = x;
    return TempWord;
}

Word _make_sobject_(unsigned x)
{
    TempWord.t6.tag = AUm_SObject;
    TempWord.t6.val = x;
    return TempWord;
}

MessagePtr _make_message_(class LocalMessage* x, MessageType t)
{
    TempMessage.t2.tag = t;
    TempMessage.t2.val = (int)x;
    return TempMessage;
}

LocalMessage* w2m(Word w)
{
    LocalMessage* m;
    m.ival = w.ival;
    return m;
}

Word m2w(LocalMessage* m)
{
    Word w;
    w.ival = m.ival;
    return w;
}

#endif	UNION_TYPE

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
