/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/message.h"
#include "aum/global.h"
#include "aum/fetch.h"
#include "aum/trace.h"
#include "aum/split.h"

// {}
// void SetMessageArgs(Message* mp, u_char argc)
// {}
// [  Ri|  Rj|	Rk|  Rl]
// [  Rm|  Rn| ........]
// {}
// 쥸 Reg[n]ͤ mp ɽåΰ˥åȤ롥
// θĿϡargc Ϳ롥
// @example
// argc = 1 :- [  A0|	0|   0|	  0]
// argc = 5 :- [  A0|  A1|  A2|	 A3]
//	       [  A4|	0|   0|	  0]
// {}
void SetMessageArgs(Message* mp, u_char argc)
{
    register int n;
    register RegNumber* v;

    v = FetchSkip((argc+3)/4);
    for (n = 0; n < argc; n++) {
	mp->Argv(n, Reg[*v++]);
    }
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
