/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/stdlib.h"
#include "aum/error.h"
#include "aum/message.h"
#include "aum/globlmsg.h"
#include "aum/object.h"
#include "aum/mj-nc.h"
#include "aum/aj-c.h"
#include "aum/execbmsg.h"
#include "aum/send.h"
#include "aum/close.h"
#include "aum/tstream.h"
#include "aum/trace.h"
#include "aum/parallel.h"
#include "class/template.h"
#include "class/clink.h"

static char TAG[] = "Execute_SystemMessage";

#define STATISTICS;
#ifdef STATISTICS
extern	"C" {
    int	    PE_nmsgrcv;
};
#endif

static void got_normal_message (GlobalMessage * const);
static void got_Close (GlobalMessage * const);
static void got_WhereAreYou_Close (GlobalMessage * const);
static void got_WhereAreYou (GlobalMessage * const);
static void got_IamHere_GRC (GlobalMessage * const);
static void got_Iam (GlobalMessage * const);
static void got_Create (GlobalMessage * const);
static void got_Copy (GlobalMessage * const);

static void
answer_where_are_you (const GlobalID & back, Header * const ptr)
    // {}
    // WhereAreYou Υå֤֥ ptr ͢ɽ
    // ϿγϤȳȲĥå back 
    // 롥ptr ϴ͢ɽϿƤ륪֥ȤǤ롥
    // {}
{
    const GlobalID gid = ExportTable->Register (ptr, WEIGHT);
    GlobalMessage *const gm = new_IamHere_GRC (gid, WEIGHT_of_IamHere);
    send_to_other_pe (back, gm);
}

static void
answer_where_are_you (const GlobalID & back, const Word atomic)
    // {}
    // ȥߥå֥Ȥ줿 WhereAreYou Υå
    // ֤
    // {}
{
    send_to_other_pe (back, new_Iam (atomic));
}

#ifdef PAS_DEBUGGER
void
execute_sys_message (GlobalMessage * mp)
    // {}
    // FUNCTION
    // void execute_sys_message (GlobalMessage * mp)
    // {}
    // ƥåmpμ¹ԤΤߤԤǥХååդƤϡ
    // exitνΤߤԤ¾ΥǥХååǤϡԤʤ
    // å塼δϾ̴ؿǤ롥
    // {}
{
    if (!(mp->Tag () == Msg_Debugger)) {
	if (PElog) {
	    TraceStream->Initialize ();
	    pelog ("[%d] Receive :%s {%x}",
		   mp->GID ().Index (), mp->Print (), mp);
	}
    }
#ifdef STATISTICS
	PE_nmsgrcv++;
#endif
    switch (mp->Tag ()) {
    case Msg_Private_Args:
    default:
	cerr << "Invalid Message " << mp->Print () << '\n';
	abort ();
    case Msg_Debugger:
	if (mp->Argv (0) == QUIT)
	    exit (0);
	break;
    case Msg_Atomic:
    case Msg_Shared_Args:
	got_normal_message (mp);
	break;
    case Msg_Close:
	got_Close (mp);
	break;
    case Msg_WhereAreYou_Close:
	got_WhereAreYou_Close (mp);
	break;
    case Msg_WhereAreYou:
	got_WhereAreYou (mp);
	break;
    case Msg_IamHere_GRC:
	got_IamHere_GRC (mp);
	break;
    case Msg_Iam:
	got_Iam (mp);
	break;
    case Msg_Create:
	got_Create (mp);
	break;
    case Msg_Copy:
	got_Copy (mp);
	break;
    }
}
#endif

void
Receive_SystemMessage (GlobalMessage * msg)
    // {}
    // ¾PE줿åŪΥ֥ȤϤ롥
    // {}
{
    MessageLink *next;
    GlobalMessage *mp;
    for (mp = msg; mp; mp = (GlobalMessage *) next) {
#ifdef PAS_DEBUGGER
	if (!(mp->Tag () == Msg_Debugger)) {
	    if (PElog) {
		TraceStream->Initialize ();
		pelog ("[%d] Receive :%s {%x}",
		       mp->GID ().Index (), mp->Print (), mp);
	    }
	}
#else
	if (PElog) {
	    TraceStream->Initialize ();
	    pelog ("[%d] Receive :%s {%x}",
		   mp->GID ().Index (), mp->Print (), mp);
	}
#endif
#ifdef STATISTICS
	PE_nmsgrcv++;
#endif
	next = mp->nextMessage (), mp->nextMessage (NULL);

	switch (mp->Tag ()) {
	case Msg_Private_Args:
	default:
	    abort ();
#ifdef PAS_DEBUGGER
	case Msg_Debugger:
	    if (mp->Argv (0) == QUIT)
		exit (0);
	    break;
#endif
	case Msg_Atomic:
	case Msg_Shared_Args:
	    got_normal_message (mp);
	    break;
	case Msg_Close:
	    got_Close (mp);
	    break;
	case Msg_WhereAreYou_Close:
	    got_WhereAreYou_Close (mp);
	    break;
	case Msg_WhereAreYou:
	    got_WhereAreYou (mp);
	    break;
	case Msg_IamHere_GRC:
	    got_IamHere_GRC (mp);
	    break;
	case Msg_Iam:
	    got_Iam (mp);
	    break;
	case Msg_Create:
	    got_Create (mp);
	    break;
	case Msg_Copy:
	    got_Copy (mp);
	    break;
	}
    }
}

static void
forward (Word mjw, GlobalMessage * const mp)
{
    if (PElog)
	pelog ("Deliver :%s to %s {%x}", mp->Print (), print (mjw), mp);
    if (IsObject (mjw)) {
	switch (Pointer (mjw)->mTag ()) {
	case MJ_C:
	case MJ_Mut:
	case AJ_C:
	case MJ_NC:
	case AJ_NC:
	case READY:
	case SUSPENDED:
	case SLEEPING:
	case ERROR:
	case SINK:
	    doSend (mjw, mp->mut2_local ());
	    return;

	default:
	    break;
	}
    }
    doSend (mjw, mp);
}

static void
forward_rest_message (Word mjw, GlobalMessage * const mp)
{
    if (mp->PID () == PID_CTL_GM)
	mp->Free ();
    else {
	if (mp->Arity () > 0)
	    mp->mTag (Msg_Shared_Args);
	else
	    mp->mTag (Msg_Atomic);
	forward (mjw, mp);
    }
}

// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
// \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//

static void
got_normal_message (GlobalMessage * const mp)
    // {}
    // ʤåäνԤʤ
    // mp->GID() б͢ɽΥ֥ȤФƥå mp
    // 롥
    // {}
{
    Word    mjw = ExportTable->Lookup (mp->GID ());
    forward (mjw, mp);
}

static void
got_Close (GlobalMessage * const mp)
    // {}
    // ĺåνԤʤ͢ɽ鳰Ȳ
    // ̤ȤʤäʤС͢ɽϿƤ륪֥
    // Ȥĺ롥
    // ޤο礭åνԤ
    // ǤʤХåΰ롥
    // {}
{
    GlobalID gid = mp->GID ();
    u_long  minus_grc;
    mp->geti_GRC (minus_grc);

    u_long  restgrc = ExportTable->GRCminus (gid, minus_grc);
    Word    mjw = ExportTable->Lookup (gid);
    forward_rest_message (mjw, mp);
    if (restgrc == 0)
	doClose (mjw);
}

static void
got_WhereAreYou_Close (GlobalMessage * const mp)
{
    GlobalID dest = mp->GID ();
    GlobalID back;
    u_long  grc;
    mp->get_CtlInfo (back, grc);
    Word    mjw = ExportTable->Lookup (dest);

    if (PElog)
	pelog ("[%d] Deliver to %s {%x}", dest.Index (), print (mjw), mp);

    u_long  restgrc = ExportTable->GRCminus (dest, grc);

    switch (Type_of (mjw)) {
    case AUm_Fixnum:
    case AUm_Atom:
    case AUm_Constant:
	answer_where_are_you (back, mjw);
	forward_rest_message (mjw, mp);
	return;

    case AUm_Object:
	switch (Pointer (mjw)->Type ()) {
	case MJ_W:
	    if (dest.Address () == back.Address ())
		fatal ("where_are_you", "cyclic structure: %s", print (mjw));
	    /* no break */
	case MJ_NC:
	    if (restgrc == 0) {
		Pointer (mjw)->LRC ()--;
		assert (Pointer (mjw)->LRC () > 0);
	    }
	    // {}
	    // Υå¾PEžǽ뤿ᡤ
	    // ͢ɽؤϿϤǤϹԤʤʤ (֥
	    // Ȥ³줿ǹԤʤ) GlobalIDĥå
	    // GCΤ˵Ͽ롥 WhereAreYouTable
	    // GlobalMessageTableˤ
	    // {}
	    mp->mTag (Msg_WhereAreYou);
	    // GlobalMessageTable->Register(msg);
	    MJ_NC_ptr (mjw)->AppendMessage (mp);
	    if (TraceMessage)
		mlog2 ("Recv", mjw);
	    return;

	case IMP_OUTLET:
	    if (restgrc == 0) {
		if (--Pointer (mjw)->LRC () == 0) {
		    // {}
		    // Υ祤Ȥï⻲ȤƤʤClose
		    // GRCդѤž롥
		    // {}
		    u_long  x = (u_long) ImportTable->Delete (MJ_IMP_ptr (mjw));
		    mp->set_CtlInfo (back, x);
		    send_to_other_pe (MJ_IMP_OUTLET_ptr (mjw)->GID (), mp);
		    MJ_IMP_OUTLET_ptr (mjw)->Free ();
		    return;
		}
	    }
	    // {}
	    // Υ祤Ȥï黲ȤƤΤǡΥ
	    // ȤФ WhereAreYou_Close 
	    // {}
	    MJ_IMP_OUTLET_ptr (mjw)->Send_where_are_you_and_dismiss (J_NC_ptr (mjw));
	    mp->mTag (Msg_WhereAreYou);
	    // GlobalMessageTable->Register(mp);
	    MJ_W_ptr (mjw)->AppendMessage (mp);
	    if (TraceMessage)
		mlog2 ("Recv", mjw);
	    return;

	case IMP_OBJ_NT:
	    mp->mTag (Msg_WhereAreYou);
	    if (restgrc == 0)
		MJ_IMP_OBJ_NT_ptr (mjw)->Close_and_answer_where_are_you (mp);
	    else
		MJ_IMP_OBJ_NT_ptr (mjw)->Answer_where_are_you (mp);
	    return;

	case IMP_OBJ:
	    mp->mTag (Msg_WhereAreYou);
	    if (restgrc == 0)
		MJ_IMP_OBJ_ptr (mjw)->Close_and_answer_where_are_you (mp);
	    else
		MJ_IMP_OBJ_ptr (mjw)->Answer_where_are_you (mp);
	    return;

	case AJ_C:
	case AJ_NC:
	case READY:
	case SUSPENDED:
	case SLEEPING:
	case ERROR:
	case DFLOAT:
	case CLASS_OBJ:
	case MESSAGE_OBJ:
	case WC_MESSAGE_OBJ:
	case FOREIGN_OBJ:
	case ASCII_STR:
	case WC_ASCII_STR:
	case EUC_STR:
	case WC_EUC_STR:
	case VECTOR:
	case WC_VECTOR:
	case FILE_STREAM:
	case WC_LISTii:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISToo:
	case LISTii:
	case LISTio:
	case LISToi:
	case LISToo:
	    answer_where_are_you (back, Pointer (mjw));
	    if (restgrc == 0) {
		--Pointer (mjw)->LRC ();
		assert (Pointer (mjw)->LRC () >= 1);
	    }
	    forward_rest_message (mjw, mp);
	    return;

	case SINK:
	    answer_where_are_you (back, SINKOBJ);
	    mjw = SINKOBJ;
	    forward_rest_message (mjw, mp);
	    return;

	default:
	    abort ();
	}
    }
}

static void
got_WhereAreYou (GlobalMessage * const mp)
{
    GlobalID dest = mp->GID ();
    GlobalID back;
    mp->geti_Iam (back);
    Word    mjw = ExportTable->Lookup (dest);

    if (PElog)
	pelog ("[%d] Deliver to %s {%x}", dest.Index (), print (mjw), mp);

    switch (Type_of (mjw)) {
    case AUm_Fixnum:
    case AUm_Atom:
    case AUm_Constant:
	answer_where_are_you (back, mjw);
	forward_rest_message (mjw, mp);
	return;

    case AUm_Object:
	switch (Pointer (mjw)->Type ()) {
	case MJ_W:
	    if (dest.Address () == back.Address ())
		fatal ("where_are_you", "cyclic structure: %s", print (mjw));
	    /* no break */
	case MJ_NC:
	    // {}
	    // Υå¾PEžǽ뤿ᡤ 
	    // ͢ɽؤϿϤǤϹԤʤʤ (֥Ȥ
	    // ³줿ǹԤʤ) GlobalIDĥå
	    // GCΤ˵Ͽ롥 WhereAreYouTable
	    // GlobalMessageTableˤ
	    // {}
	    // GlobalMessageTable->Register(msg);
	    MJ_NC_ptr (mjw)->AppendMessage (mp);
	    if (TraceMessage)
		mlog2 ("Recv", mjw);
	    return;
	case IMP_OUTLET:
	    // {}
	    // Υ祤Ȥï黲ȤƤΤǡΥ
	    // ȤФ WhereAreYou_Close 
	    // {}
	    MJ_IMP_OUTLET_ptr (mjw)->Send_where_are_you_and_dismiss (J_NC_ptr (mjw));
	    // GlobalMessageTable->Register(mp);
	    MJ_W_ptr (mjw)->AppendMessage (mp);
	    if (TraceMessage)
		mlog2 ("Recv", mjw);
	    return;

	case IMP_OBJ_NT:
	    MJ_IMP_OBJ_NT_ptr (mjw)->Answer_where_are_you (mp);
	    return;

	case IMP_OBJ:
	    MJ_IMP_OBJ_ptr (mjw)->Answer_where_are_you (mp);
	    return;

	case AJ_C:
	case AJ_NC:
	case READY:
	case SUSPENDED:
	case SLEEPING:
	case ERROR:
	case DFLOAT:
	case CLASS_OBJ:
	case WC_MESSAGE_OBJ:
	case MESSAGE_OBJ:
	case FOREIGN_OBJ:
	case ASCII_STR:
	case WC_ASCII_STR:
	case EUC_STR:
	case WC_EUC_STR:
	case VECTOR:
	case WC_VECTOR:
	case FILE_STREAM:
	case WC_LISTii:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISToo:
	case LISTii:
	case LISTio:
	case LISToi:
	case LISToo:
	    answer_where_are_you (back, Pointer (mjw));
	    forward_rest_message (mjw, mp);
	    return;

	case SINK:
	    answer_where_are_you (back, SINKOBJ);
	    mjw = SINKOBJ;
	    forward_rest_message (mjw, mp);
	    return;

	default:
	    abort ();
	}
    }
}

static void
got_IamHere_GRC (GlobalMessage * const mp)
    // {}
    // IamHere_GRC νԤʤå裰¾УŤΥ֥
    // ȤγϤǤ롥裱ϤΥ֥ȤγȲ
    // ɽͤϣѾͤǤϤʤǤ롥
    // {}
    // IamHere å͢ɽϿƤ MJ_W Ф
    // Τǡб͢ɽ GRC  -1 롥̤Ȥ GRC
    // ʤä顤λȤʤʤäȹͤ롥͢ɽΥȥ
    //  GRC ͤξ˶ȹͤΤǡä˺νԤʤɬ
    // פϤʤˡMJ_W Υ祤Ȥˤ͢ɽλȲ
    //  -1 롥̤Ȥƥ祤ȤλȲȤʤä餽
    // 롥
    // {}
    // MJ_W 祤ȤߤǤʤϡϤ͢ɽϿ
    //  IMP_OBJ_NT ˤ롥
    // {}
    // MJ_W ίäƤåϡ裰Ϳ¾УŤΥ֥
    // Ȥž롥åϳåѴ祤
    // ȤΥ IMP_OBJ_NT ǤϤʤ IMP_OBJ Ȥ롥å
    // Ƭ WhereAreYou åϡФƤϡľ
    //  IamHere ֤Ȳ WhereAreYou Фʬ
    // 䤹롥
    // {}
{
    GlobalID iam;
    u_long  grc;
    GlobalID dst = mp->GID ();
    mp->get_CtlInfo (iam, grc);
    assert (grc > 0);
    assert (mp->Arity () == 0);

    Word    mjw = ExportTable->Lookup (dst);

    if (PElog)
	pelog ("[%d] Deliver to %s {%x}", dst.Index (), print (mjw), mp);

    mp->Free ();

    if (Type_of (mjw) == AUm_Object) {
	switch (Pointer (mjw)->Type ()) {
	case MJ_W:
	    if (ExportTable->decrGRC (dst) == 0) {
		if (--Pointer (mjw)->LRC () == 0) {
		    MJ_W_ptr (mjw)->Forward_and_Close (iam, grc);
		    MJ_W_ptr (mjw)->Free ();
		    return;
		}
	    }
	    MJ_W_ptr (mjw)->Forward (iam, grc);
	    return;

	default:
	    break;
	}
    }
    fatal (TAG, "message \"IamHere\" is received, but no MJ_W");
}

static void
got_Iam (GlobalMessage * const mp)
    // {}
    // Iam νԤʤԤäƤ祤Ȥ˥åίäƤ
    // 顤¹Ԥ롥͢ɽ鳰Ȳݣˤʤä饸
    // Ȥΰ롥
    // {}
{
    GlobalID iam;
    mp->geti_Iam (iam);
    assert (Type_of (iam) != AUm_Object);
    GlobalID dst = mp->GID ();
    assert (mp->Arity () == 0);
    mp->Free ();

    {
	Word	mjw = ExportTable->Lookup (dst);

	if (Type_of (mjw) == AUm_Object) {
	    switch (Pointer (mjw)->Type ()) {
	    case MJ_W:
		if (MJ_NC_ptr (mjw)->MessageExist ()) {
		    MJ_NC_ptr (mjw)->Reached_atomic ((Word) iam);
		}
		if (ExportTable->decrGRC (dst) == 0) {
		    if (--Pointer (mjw)->LRC () == 0) {
			MJ_NC_ptr (mjw)->Free ();
			return;
		    }
		}
		MJ_NC_ptr (mjw)->mut2_MJ_C (iam);
		return;

	    default:
		break;
	    }
	}
	fatal (TAG, "message \"Iam\" is received, but no MJ_W");
    }
}

static void
got_Create (GlobalMessage * const mp)
    // {}
    // ֥̿νԤʤå裰
    // ֥ȤϤǤ롥裱ϥ饹ơ
    // ֥ΥǥåɽΥǥå饤󥹥󥹥
    // Ȥ͢ɽϿϤ֤͢
    // 륪֥ȤγȲ WEIGHT Ǥ롥
    // ֥ȤλȲ͢ɽؤ룱ΤߤǤ롥
    // {}
{
    GlobalID answer;
    u_long  index;
    mp->get_CtlInfo (answer, index);
    assert (mp->Arity () == 0);
    mp->Free ();

    Object *obj = new_InstanceObject (index);
    GlobalID gid = ExportTable->Register (obj, WEIGHT);
    obj->LRC () = 1;

    GlobalMessage *gm = new_IamHere_GRC (gid, WEIGHT_of_IamHere);

    if (PElog)
	pelog ("[%d] Create %s {%x}", gid.Index (), obj->Print (), gm);
    else if (TraceMessage)
	mlog4 ("Create", obj->Print (), " as ", gid.Print ());

    send_to_other_pe (answer, gm);
}

void
Answer_where_are_you (GlobalMessage * gm, Header * ptr)
    // {}
    // ¤ĥ֥Ȥ where_are_you åϤ
    // ֤
    // {}
{
    GlobalID back;
    gm->geti_Iam (back);
    answer_where_are_you (back, ptr);
    // GlobalMessageTable->Delete (gm);
    forward_rest_message (ObjectWord (ptr), gm);
}

void
Answer_where_are_you (GlobalMessage * gm, Word dest)
    // {}
    // ȥߥå֥Ȥ where_are_you åϤ
    // ֤
    // {}
{
    assert (Type_of (dest) != AUm_Object);
    GlobalID back;
    gm->geti_Iam (back);
    answer_where_are_you (back, dest);
    // GlobalMessageTable->Delete (gm);
    forward_rest_message (dest, gm);
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

static void
got_Copy (GlobalMessage * const mp)
    // {}
    // ưʸΣУŴ֥ԡԤʤå
    // argv[0] ˥ǡ롥argv[1] ʹߤ˥֥ȤΥإå
    // ޤƤΥԡäƤ롥
    // {}
{
    assert (mp->Arity () == 0);

    GlobalID dst = mp->GID ();
    Word    mjw = ExportTable->Lookup (dst);

    if (Type_of (mjw) == AUm_Object && Pointer (mjw)->Type () == MJ_W) {
	Word iam = new_object_from_Iam_copy (mp);

	if (PElog)
	    pelog ("[%d] Copy %s {%x}", dst.Index (), print (iam), mp);
	else if (TraceMessage)
	    mlog4 ("Copy", print (iam), " as ", dst.Print ());
	mp->Free ();

	if (MJ_NC_ptr (mjw)->MessageExist ()) {
	    MJ_NC_ptr (mjw)->Reached_structure (iam);
	}
	if (ExportTable->decrGRC (dst) == 0) {
	    if (--Pointer (mjw)->LRC () == 0) {
		MJ_NC_ptr (mjw)->Free ();
		return;
	    }
	}
	MJ_NC_ptr (mjw)->mut2_MJ_C (iam);
	return;
    }
    fatal (TAG, "message \"Copy\" is received, but no MJ_W");
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-continued-brace-offset:0
 * c-brace-offset:0
 * c-brace-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-empty-arglist-indent:4
 * c++-friend-offset:0
 * c-imaginary-offset:0
 * c++-electric-colon:t
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
