/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stdio.h>
#include <stream.h>
#include <stdarg.h>
#include "aum/stdlib.h"
#include "aum/word.h"
#include "aum/error.h"
#include "aum/fetch.h"
#include "aum/object.h"
#include "aum/message.h"
#include "aum/global.h"
#include "aum/tstream.h"

#ifdef PAS_DEBUGGER
extern void	message_to_Listener(debugger_symbol com);
extern void	message_to_Listener(debugger_symbol, unsigned char *);
#endif

/////////////////////////// 顼å //////////////////////////////////

extern const char OUT_OF_INDEX_RANGE[]	  = "Index is out of range";
extern const char INDEX_MUST_BE_INTEGER[] = "Index must be an integer";
extern const char INVALID_DATA_TYPE[]	  = "%s invalid data type";
extern const char CAN_NOT_FIND_METHOD[]	  = "Can't find the method :%s";
extern const char Classnamelist[] = "list";

const char*
errmsg_undefined_method (Word x)
{
    char buf[BUFSIZ];
    tstream tout = tstream (BUFSIZ, buf);
    tout << "Undefined method. The "
	<< name_of_object_type (x) << " object doesn't suport it";
    return tout.Result ();
}

/////////////////////////// 顼ɽѴؿ //////////////////////////////////

Word
RaiseError ()
{
    cerr << "*** RAISE ERROR ***\n";
    abort ();
    return INT0;
}

static void
item (const char *label, const char *where)
{
    cerr << form ("%s: ", label) << where << nl () << tabs (strlen (label) + 2);
}

void
warn (const char *where, const char *fmt,...)
    // {}
    // եåϤ롥
    // {}
{
    char    buf[BUFSIZ];
    va_list args;
    va_start (args, fmt);
    ExitStatus++;
    item ("Warnning", where);
    vsprintf (buf, fmt, args);
    cerr << buf << ".\n";
    va_end (args);
}

#ifdef PAS_DEBUGGER
void print_message()
{
    tstream tout = tstream();
    switch (CurrentMessage->mTag()) {
    case Msg_Atomic:
    case Msg_Private_Args:
    case Msg_Shared_Args:
	tout << "Current Message :"<< CurrentMessage->Print()<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    default:
	break;
    }
}
#endif

void
error (const char *where, const char *fmt,...)
    // {}
    // 顼åϤ롥
    // {}
{
    char    buf[BUFSIZ];
    va_list args;
    va_start (args, fmt);
    ExitStatus++;
    item ("Error", where);
    vsprintf (buf, fmt, args);
    cerr << buf << ".\n";
    va_end (args);
#ifdef PAS_DEBUGGER
    if (CurrentObject){
	if (CurrentMessage){
	    print_message();
	}
	stop = TRUE;
	if (stop) {
	    stop = FALSE;
	    BreakLoop(&trace_switch,CurrentObject);
	}
    }
#endif
    exit (1);
}

void
fatal (const char *where, const char *fmt,...)
    // {}
    // 顼åϤơܡȤ롥
    // {}
{
    char    buf[BUFSIZ];
    va_list args;
    va_start (args, fmt);
    ExitStatus++;
    item ("System Error ", where);
    vsprintf (buf, fmt, args);
    cerr << buf << ".\n";
    va_end (args);
#ifdef PAS_DEBUGGER
    if (CurrentObject){
	if (CurrentMessage) {
	    print_message();
	}
	stop = TRUE;
	if (stop) {
	    stop = FALSE;
	    BreakLoop(&trace_switch,CurrentObject);
	}
    }
#endif
    exit (1);
}

const char *
tabs (int n)
    // {}
    // ȥ꡼˰ʬΥڡϤ뤿Ѥ롥
    // ex) cout << tabs(4) << "4 spaces\n";
    // {}
{
    static char spaces[80];

    register int i = n;
    register char *p = spaces;
    while (--i >= 0)
	*p++ = ' ';
    *p = '\0';
    return spaces;
}

const char *
nl ()
    // {}
    // ȥ꡼˲ԤϤ뤿Ѥ롥
    // ex) cout << nl();
    // {}
{
    return "\n";
}

const char *
dotnl ()
    // {}
    // ȥ꡼˥ԥꥪɡܲԤϤ뤿Ѥ롥
    // ex) cout << dotnl();
    // {}
{
    return ".\n";
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
